/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.bitzi.util.Base32;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BandwidthTracker;
import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.http.HTTPRequestMethod;
import com.limegroup.gnutella.http.ProblemReadingHeaderException;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.settings.UploadSettings;
import com.limegroup.gnutella.statistics.UploadStat;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.uploader.StalledUploadWatchdog;
import com.limegroup.gnutella.util.Buffer;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.KeyValue;
import com.limegroup.gnutella.util.URLDecoder;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public final class UploadManager
implements BandwidthTracker {
    private final int BYPASS_QUEUE = -1;
    private final int REJECTED = 0;
    private final int QUEUED = 1;
    private final int ACCEPTED = 2;
    public static final int MIN_POLL_TIME = 45000;
    public static final int MAX_POLL_TIME = 120000;
    private List _activeUploadList = new LinkedList();
    private List _queuedUploads = new ArrayList();
    private volatile boolean _hadSuccesfulUpload = false;
    private static final int MAX_SPEED_SAMPLE_SIZE = 5;
    private static final int MIN_SPEED_SAMPLE_SIZE = 5;
    private static final int MIN_SAMPLE_BYTES = 200000;
    private Buffer speeds = new Buffer(5);
    private volatile int highestSpeed = -1;
    private int numMeasures = 0;
    private float averageBandwidth = 0.0f;
    private static final float MINIMUM_UPLOAD_SPEED = 3.0f;
    public static final int BROWSE_HOST_FILE_INDEX = -1;
    public static final int UPDATE_FILE_INDEX = -2;
    public static final int BAD_URN_QUERY_INDEX = -3;
    public static final int MALFORMED_REQUEST_INDEX = -4;
    public static final int PUSH_PROXY_FILE_INDEX = -5;
    public static final boolean RECORD_STATS = !CommonUtils.isJava118();
    private static final boolean debugOn = false;
    private static final boolean log = false;
    private static PrintWriter writer = null;

    public List getUploads() {
        ArrayList clone = new ArrayList();
        clone.addAll(this._activeUploadList);
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void acceptUpload(HTTPRequestMethod method, Socket socket, boolean forceAllow) {
        UploadManager.debug(" accepting upload");
        HTTPUploader uploader = null;
        long startTime = -1L;
        try {
            try {
                int queued = -1;
                String oldFileName = "";
                HTTPRequestMethod currentMethod = method;
                StalledUploadWatchdog watchdog = new StalledUploadWatchdog();
                BufferedInputStream iStream = null;
                boolean startedNewFile = false;
                while (true) {
                    if (uploader != null) {
                        this.assertAsComplete(uploader.getState());
                    }
                    if (iStream == null) {
                        iStream = new BufferedInputStream(socket.getInputStream());
                    }
                    HttpRequestLine line = this.parseHttpRequest(socket, iStream);
                    UploadManager.debug(uploader + " successfully parsed request");
                    String fileName = line._fileName;
                    startedNewFile = uploader == null || currentMethod != uploader.getMethod() || !oldFileName.equalsIgnoreCase(fileName);
                    if (startedNewFile) {
                        UploadManager.debug(uploader + " starting new file");
                        if (uploader != null) {
                            if (queued != 1) {
                                queued = -1;
                            } else {
                                uploader.setState(5);
                            }
                            this.cleanupFinishedUploader(uploader, startTime);
                        }
                        uploader = new HTTPUploader(currentMethod, fileName, socket, line._index, line.getParameters(), watchdog);
                    } else {
                        UploadManager.debug(uploader + " continuing old file");
                        uploader.reinitialize(currentMethod, line.getParameters());
                    }
                    this.assertAsConnecting(uploader.getState());
                    this.setInitialUploadingState(uploader);
                    try {
                        uploader.readHeader(iStream);
                        this.setUploaderStateOffHeaders(uploader);
                    }
                    catch (ProblemReadingHeaderException prhe) {
                        uploader.setState(11);
                    }
                    UploadManager.debug(uploader + " HTTPUploader created and read all headers");
                    if (queued != 2 && (queued = this.processNewRequest(uploader, socket, forceAllow)) == 2) {
                        startTime = System.currentTimeMillis();
                    }
                    if (startedNewFile) {
                        this.addToGUI(uploader);
                    }
                    this.doSingleUpload(uploader);
                    this.assertAsFinished(uploader.getState());
                    oldFileName = fileName;
                    if (!line.isHTTP11()) {
                        Object var18_18 = null;
                        if (uploader != null && uploader.getState() != 4) {
                            uploader.setState(5);
                        }
                        UploadManager uploadManager = this;
                        // MONITORENTER : uploadManager
                        boolean found = false;
                        Iterator iter = this._queuedUploads.iterator();
                        while (iter.hasNext()) {
                            KeyValue kv = (KeyValue)iter.next();
                            if (kv.getKey() != socket) continue;
                            iter.remove();
                            found = true;
                            break;
                        }
                        if (found) {
                            uploader.setState(5);
                        }
                        // MONITOREXIT : uploadManager
                        if (uploader != null) {
                            uploader.stop();
                            this.cleanupFinishedUploader(uploader, startTime);
                        }
                        UploadManager.debug(uploader + " closing socket");
                        this.close(socket);
                        return;
                    }
                    UploadManager.debug(uploader + " waiting for next request with socket ");
                    int oldTimeout = socket.getSoTimeout();
                    if (queued != 1) {
                        socket.setSoTimeout(SharingSettings.PERSISTENT_HTTP_CONNECTION_TIMEOUT.getValue());
                    }
                    String word = IOUtils.readWord(iStream, 4);
                    UploadManager.debug(uploader + " next request arrived ");
                    socket.setSoTimeout(oldTimeout);
                    if (word.equals("GET")) {
                        currentMethod = HTTPRequestMethod.GET;
                        if (!RECORD_STATS) continue;
                        UploadStat.SUBSEQUENT_GET.incrementStat();
                        continue;
                    }
                    if (!word.equals("HEAD")) break;
                    currentMethod = HTTPRequestMethod.HEAD;
                    if (!RECORD_STATS) continue;
                    UploadStat.SUBSEQUENT_HEAD.incrementStat();
                }
                if (RECORD_STATS) {
                    UploadStat.SUBSEQUENT_UNKNOWN.incrementStat();
                }
                Object var18_19 = null;
                if (uploader != null && uploader.getState() != 4) {
                    uploader.setState(5);
                }
                UploadManager uploadManager = this;
                // MONITORENTER : uploadManager
                boolean found = false;
                Iterator iter = this._queuedUploads.iterator();
                while (iter.hasNext()) {
                    KeyValue kv = (KeyValue)iter.next();
                    if (kv.getKey() != socket) continue;
                    iter.remove();
                    found = true;
                    break;
                }
                if (found) {
                    uploader.setState(5);
                }
                // MONITOREXIT : uploadManager
                if (uploader != null) {
                    uploader.stop();
                    this.cleanupFinishedUploader(uploader, startTime);
                }
                UploadManager.debug(uploader + " closing socket");
                this.close(socket);
                return;
            }
            catch (IOException ioe) {
                UploadManager.debug(uploader + " IOE thrown, closing socket");
                Object var18_20 = null;
                if (uploader != null && uploader.getState() != 4) {
                    uploader.setState(5);
                }
                UploadManager uploadManager = this;
                // MONITORENTER : uploadManager
                boolean found = false;
                Iterator iter = this._queuedUploads.iterator();
                while (iter.hasNext()) {
                    KeyValue kv = (KeyValue)iter.next();
                    if (kv.getKey() != socket) continue;
                    iter.remove();
                    found = true;
                    break;
                }
                if (found) {
                    uploader.setState(5);
                }
                // MONITOREXIT : uploadManager
                if (uploader != null) {
                    uploader.stop();
                    this.cleanupFinishedUploader(uploader, startTime);
                }
                UploadManager.debug(uploader + " closing socket");
                this.close(socket);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var18_21 = null;
            if (uploader != null && uploader.getState() != 4) {
                uploader.setState(5);
            }
            UploadManager uploadManager = this;
            // MONITORENTER : uploadManager
            boolean found = false;
            Iterator iter = this._queuedUploads.iterator();
            while (iter.hasNext()) {
                KeyValue kv = (KeyValue)iter.next();
                if (kv.getKey() != socket) continue;
                iter.remove();
                found = true;
                break;
            }
            if (found) {
                uploader.setState(5);
            }
            // MONITOREXIT : uploadManager
            if (uploader != null) {
                uploader.stop();
                this.cleanupFinishedUploader(uploader, startTime);
            }
            UploadManager.debug(uploader + " closing socket");
            this.close(socket);
            throw throwable;
        }
    }

    private boolean shouldShowInGUI(Uploader uploader) {
        return uploader.getIndex() != -1 && uploader.getIndex() != -5 && uploader.getIndex() != -2 && uploader.getIndex() != -4 && uploader.getIndex() != -3 && uploader.getMethod() != HTTPRequestMethod.HEAD;
    }

    private boolean shouldBypassQueue(Uploader uploader) {
        return uploader.getState() != 0 || uploader.getMethod() == HTTPRequestMethod.HEAD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupFinishedUploader(HTTPUploader uploader, long startTime) {
        UploadManager.debug(uploader + " cleaning up finished.");
        int state = uploader.getState();
        int lastState = uploader.getLastTransferState();
        this.assertAsFinished(state);
        long finishTime = System.currentTimeMillis();
        UploadManager uploadManager = this;
        synchronized (uploadManager) {
            if (startTime > 0L) {
                this.reportUploadSpeed(finishTime - startTime, uploader.getTotalAmountUploaded());
            }
            this.removeFromList(uploader);
        }
        uploader.closeFileStreams();
        if (RECORD_STATS) {
            switch (state) {
                case 4: {
                    UploadStat.COMPLETED.incrementStat();
                    if (lastState != 3) break;
                    UploadStat.COMPLETED_FILE.incrementStat();
                    break;
                }
                case 5: {
                    UploadStat.INTERRUPTED.incrementStat();
                }
            }
        }
        if (this.shouldShowInGUI(uploader)) {
            FileDesc fd = uploader.getFileDesc();
            if (fd != null && state == 4 && lastState == 3) {
                fd.incrementCompletedUploads();
                RouterService.getCallback().handleSharedFileUpdate(fd.getFile());
            }
            RouterService.getCallback().removeUpload(uploader);
        }
    }

    private void setInitialUploadingState(HTTPUploader uploader) {
        switch (uploader.getIndex()) {
            case -1: {
                uploader.setState(8);
                return;
            }
            case -5: {
                uploader.setState(12);
                return;
            }
            case -2: {
                uploader.setState(10);
                return;
            }
            case -3: {
                uploader.setState(7);
                return;
            }
            case -4: {
                uploader.setState(11);
                return;
            }
        }
        FileManager fm = RouterService.getFileManager();
        FileDesc fd = null;
        int index = uploader.getIndex();
        if (fm.isValidIndex(index)) {
            fd = fm.get(index);
        }
        if (fd == null) {
            UploadManager.debug(uploader + " fd is null");
            uploader.setState(7);
            return;
        }
        if (!uploader.getFileName().equals(fd.getName())) {
            UploadManager.debug(uploader + " wrong file name");
            uploader.setState(7);
            return;
        }
        try {
            uploader.setFileDesc(fd);
        }
        catch (IOException ioe) {
            UploadManager.debug(uploader + " could not create file stream");
            uploader.setState(7);
            return;
        }
        this.assertAsConnecting(uploader.getState());
    }

    private void setUploaderStateOffHeaders(HTTPUploader uploader) {
        FileDesc fd = uploader.getFileDesc();
        if (uploader.getState() == 0) {
            URN urn = uploader.getRequestedURN();
            if (fd != null && urn != null && !fd.containsUrn(urn)) {
                UploadManager.debug(uploader + " wrong content urn");
                uploader.setState(7);
                return;
            }
            if (fd instanceof IncompleteFileDesc) {
                int upEnd;
                if (!UploadSettings.ALLOW_PARTIAL_SHARING.getValue()) {
                    uploader.setState(7);
                    return;
                }
                IncompleteFileDesc ifd = (IncompleteFileDesc)fd;
                int upStart = uploader.getUploadBegin();
                if (!ifd.isRangeSatisfiable(upStart, upEnd = uploader.getUploadEnd())) {
                    uploader.setState(13);
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int processNewRequest(HTTPUploader uploader, Socket socket, boolean forceAllow) throws IOException {
        UploadManager.debug(uploader + " processing new request.");
        int queued = -1;
        if (!this.shouldBypassQueue(uploader)) {
            if (forceAllow) {
                queued = 2;
            } else {
                queued = this.checkAndQueue(uploader, socket);
                Assert.that(queued != -1);
            }
        } else {
            queued = -1;
        }
        switch (queued) {
            case 0: {
                uploader.setState(2);
                break;
            }
            case 1: {
                uploader.setState(9);
                socket.setSoTimeout(120000);
                break;
            }
            case 2: {
                this.assertAsConnecting(uploader.getState());
                UploadManager uploadManager = this;
                synchronized (uploadManager) {
                    this._activeUploadList.add(uploader);
                    break;
                }
            }
            case -1: {
                break;
            }
            default: {
                Assert.that(false, "Invalid queued state: " + queued);
            }
        }
        return queued;
    }

    private void addToGUI(Uploader uploader) {
        if (RECORD_STATS) {
            UploadStat.ATTEMPTED.incrementStat();
        }
        if (this.shouldShowInGUI(uploader)) {
            RouterService.getCallback().addUpload(uploader);
            FileDesc fd = uploader.getFileDesc();
            if (fd != null) {
                fd.incrementAttemptedUploads();
                RouterService.getCallback().handleSharedFileUpdate(fd.getFile());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSingleUpload(HTTPUploader uploader) throws IOException {
        switch (uploader.getState()) {
            case 13: {
                if (!RECORD_STATS) break;
                UploadStat.UNAVAILABLE_RANGE.incrementStat();
                break;
            }
            case 7: {
                if (!RECORD_STATS) break;
                UploadStat.FILE_NOT_FOUND.incrementStat();
                break;
            }
            case 1: {
                if (!RECORD_STATS) break;
                UploadStat.FREELOADER.incrementStat();
                break;
            }
            case 2: {
                if (!RECORD_STATS) break;
                UploadStat.LIMIT_REACHED.incrementStat();
                break;
            }
            case 9: {
                if (!RECORD_STATS) break;
                UploadStat.QUEUED.incrementStat();
                break;
            }
            case 0: {
                uploader.setState(3);
                if (!RECORD_STATS) break;
                UploadStat.UPLOADING.incrementStat();
                break;
            }
            case 4: 
            case 5: {
                Assert.that(false, "invalid state in doSingleUpload");
            }
        }
        UploadManager.debug(uploader + " doing single upload");
        boolean closeConnection = false;
        try {
            uploader.initializeStreams();
            uploader.writeResponse();
            closeConnection = uploader.getCloseConnection();
            uploader.setState(4);
        }
        finally {
            uploader.closeFileStreams();
        }
        if (closeConnection) {
            throw new IOException("close connection");
        }
    }

    public void close(Socket socket) {
        try {
            if (socket != null) {
                socket.getOutputStream().close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (socket != null) {
                socket.getInputStream().close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (socket != null) {
                socket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized boolean isServiceable() {
        return !this.isBusy() && this._queuedUploads.isEmpty();
    }

    public synchronized boolean isBusy() {
        if (RouterService.getIsShuttingDown()) {
            return true;
        }
        return !this.testTotalUploadLimit();
    }

    public synchronized boolean isQueueFull() {
        if (RouterService.getIsShuttingDown()) {
            return true;
        }
        return this._queuedUploads.size() >= UploadSettings.UPLOAD_QUEUE_SIZE.getValue();
    }

    public synchronized int uploadsInProgress() {
        return this._activeUploadList.size();
    }

    public synchronized int getNumQueuedUploads() {
        return this._queuedUploads.size();
    }

    public boolean hadSuccesfulUpload() {
        return this._hadSuccesfulUpload;
    }

    public synchronized boolean killUploadsForFileDesc(FileDesc fd) {
        boolean ret = false;
        Iterator i = this._activeUploadList.iterator();
        while (i.hasNext()) {
            HTTPUploader uploader = (HTTPUploader)i.next();
            FileDesc upFD = uploader.getFileDesc();
            if (upFD == null || !upFD.equals(fd)) continue;
            ret = true;
            uploader.stop();
        }
        return ret;
    }

    private synchronized int checkAndQueue(Uploader uploader, Socket socket) throws IOException {
        boolean limitReached = this.hostLimitReached(uploader.getHost());
        int size = this._queuedUploads.size();
        int posInQueue = this.positionInQueue(socket);
        int maxQueueSize = UploadSettings.UPLOAD_QUEUE_SIZE.getValue();
        boolean wontAccept = size >= maxQueueSize;
        int ret = -1;
        boolean queue = uploader.supportsQueueing();
        Assert.that(maxQueueSize > 0, "queue size 0, cannot use");
        Assert.that(uploader.getState() == 0, "Bad state: " + uploader.getState());
        Assert.that(uploader.getMethod() == HTTPRequestMethod.GET);
        if (posInQueue == -1) {
            UploadManager.debug(uploader + "Uploader not in que(capacity:" + maxQueueSize + ")");
            if (limitReached || wontAccept) {
                UploadManager.debug(uploader + " limited? " + limitReached + " wontAccept? " + wontAccept);
                return 0;
            }
            this.addToQueue(socket);
            posInQueue = size;
            ret = 1;
            UploadManager.debug(uploader + " new uploader added to queue");
        } else {
            KeyValue kv = (KeyValue)this._queuedUploads.get(posInQueue);
            Long prev = (Long)kv.getValue();
            if (prev + 45000L > System.currentTimeMillis()) {
                this._queuedUploads.remove(posInQueue);
                UploadManager.debug(uploader + " queued uploader flooding-throwing exception");
                throw new IOException();
            }
            kv.setValue(new Long(System.currentTimeMillis()));
            UploadManager.debug(uploader + " updated queued uploader");
            ret = 1;
        }
        UploadManager.debug(uploader + " checking if given uploader is can be accomodated ");
        if (!this.isBusy() && posInQueue == 0) {
            ret = 2;
            UploadManager.debug(uploader + " accepting upload");
            this._queuedUploads.remove(0);
        } else if (!queue) {
            this._queuedUploads.remove(posInQueue);
            ret = 0;
        }
        return ret;
    }

    private synchronized void addToQueue(Socket socket) {
        Long t = new Long(System.currentTimeMillis());
        this._queuedUploads.add(new KeyValue(socket, t));
    }

    public synchronized int positionInQueue(Socket socket) {
        int i = 0;
        Iterator iter = this._queuedUploads.iterator();
        while (iter.hasNext()) {
            Object curr = ((KeyValue)iter.next()).getKey();
            if (curr == socket) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private synchronized void removeFromList(Uploader uploader) {
        this._activeUploadList.remove(uploader);
        if (this._activeUploadList.size() == 0) {
            RouterService.getCallback().uploadsComplete();
        }
    }

    private synchronized boolean hostLimitReached(String host) {
        int max = UploadSettings.UPLOADS_PER_PERSON.getValue();
        int i = 0;
        Iterator iter = this._activeUploadList.iterator();
        while (iter.hasNext()) {
            Uploader u = (Uploader)iter.next();
            if (!u.getHost().equals(host)) continue;
            ++i;
        }
        iter = this._queuedUploads.iterator();
        while (iter.hasNext()) {
            Socket s = (Socket)((KeyValue)iter.next()).getKey();
            if (!s.getInetAddress().getHostAddress().equals(host)) continue;
            ++i;
        }
        return i >= max;
    }

    private boolean testTotalUploadLimit() {
        int current = this.uploadsInProgress();
        if (current >= UploadSettings.MAX_UPLOADS.getValue()) {
            return false;
        }
        if (current < UploadSettings.SOFT_MAX_UPLOADS.getValue()) {
            return true;
        }
        float fastest = 0.0f;
        Iterator iter = this._activeUploadList.iterator();
        while (iter.hasNext()) {
            BandwidthTracker upload = (BandwidthTracker)iter.next();
            float speed = 0.0f;
            try {
                speed = upload.getMeasuredBandwidth();
            }
            catch (InsufficientDataException ide) {
                speed = 0.0f;
            }
            fastest = Math.max(fastest, speed);
        }
        return fastest > 3.0f;
    }

    public int calculateBandwidth() {
        float totalBandwith = this.getTotalBandwith();
        float burstSize = totalBandwith / (float)this.uploadsInProgress();
        return (int)burstSize;
    }

    private float getTotalBandwith() {
        float connectionSpeed = (float)ConnectionSettings.CONNECTION_SPEED.getValue() / 8.0f;
        float speed = UploadSettings.UPLOAD_SPEED.getValue();
        float totalBandwith = connectionSpeed * (speed / 100.0f);
        return totalBandwith;
    }

    public int measuredUploadSpeed() {
        return this.highestSpeed;
    }

    private void reportUploadSpeed(long milliseconds, long bytes) {
        if (bytes < 200000L) {
            return;
        }
        int bandwidth = 8 * (int)((float)bytes / (float)milliseconds);
        this.speeds.add(new Integer(bandwidth));
        if (this.speeds.size() >= 5) {
            int max = 0;
            for (int i = 0; i < this.speeds.size(); ++i) {
                max = Math.max(max, (Integer)this.speeds.get(i));
            }
            this.highestSpeed = max;
        }
    }

    private HttpRequestLine parseHttpRequest(Socket socket, InputStream iStream) throws IOException {
        socket.setSoTimeout(8000);
        ByteReader br = new ByteReader(iStream);
        String str = br.readLine();
        try {
            if (str == null) {
                throw new IOException();
            }
            str.trim();
            if (this.isURNGet(str)) {
                return this.parseURNGet(str);
            }
            if (this.isMalformedURNGet(str)) {
                return this.parseMalformedURNGet(str);
            }
            return UploadManager.parseTraditionalGet(str);
        }
        catch (IOException ioe) {
            if (RECORD_STATS) {
                UploadStat.MALFORMED_REQUEST.incrementStat();
            }
            if (str == null) {
                return new HttpRequestLine(-4, "Malformed Request", false);
            }
            return new HttpRequestLine(-4, "Malformed Request", UploadManager.isHTTP11Request(str));
        }
    }

    private boolean isURNGet(String requestLine) {
        int slash1Index = requestLine.indexOf("/");
        int slash2Index = requestLine.indexOf("/", slash1Index + 1);
        if (slash1Index == -1 || slash2Index == -1) {
            return false;
        }
        String idString = requestLine.substring(slash1Index + 1, slash2Index);
        return idString.equalsIgnoreCase("uri-res");
    }

    private boolean isMalformedURNGet(String requestLine) {
        if (requestLine.startsWith("/get/0//")) {
            return this.isURNGet(requestLine.substring(7));
        }
        return false;
    }

    private static HttpRequestLine parseTraditionalGet(String requestLine) throws IOException {
        try {
            int index = -1;
            StringTokenizer st = new StringTokenizer(requestLine);
            if (st.countTokens() < 2) {
                throw new IOException("invalid request: " + requestLine);
            }
            String fileInfoPart = st.nextToken().trim();
            String fileName = null;
            HashMap<String, Integer> parameters = null;
            if (fileInfoPart.equals("/")) {
                index = -1;
                fileName = "Browse-Host Request";
                if (RECORD_STATS) {
                    UploadStat.BROWSE_HOST.incrementStat();
                }
            } else if (fileInfoPart.equals("/update.xml")) {
                index = -2;
                fileName = "Update-File Request";
                if (RECORD_STATS) {
                    UploadStat.UPDATE_FILE.incrementStat();
                }
            } else if (fileInfoPart.startsWith("/gnutella/push-proxy")) {
                fileInfoPart = fileInfoPart.substring(21);
                index = -5;
                StringTokenizer stLocal = new StringTokenizer(fileInfoPart, "=&");
                if (stLocal.countTokens() < 2 || stLocal.countTokens() % 2 != 0) {
                    throw new IOException("Malformed PushProxy HTTP Request");
                }
                Integer fileIndex = null;
                while (stLocal.hasMoreTokens()) {
                    String k = stLocal.nextToken();
                    String val = stLocal.nextToken();
                    if (k.equalsIgnoreCase("ServerId")) {
                        if (fileName != null) {
                            throw new IOException("Malformed PushProxy Req");
                        }
                        byte[] base16 = Base32.decode(val);
                        if (base16.length != 16) {
                            throw new IOException("Malformed PushProxy Req");
                        }
                        fileName = new GUID(base16).toHexString();
                        continue;
                    }
                    if (k.equalsIgnoreCase("guid")) {
                        if (fileName != null) {
                            throw new IOException("Malformed PushProxy Req");
                        }
                        if (val.length() != 32) {
                            throw new IOException("Malformed PushProxy Req");
                        }
                        fileName = val;
                        continue;
                    }
                    if (!k.equalsIgnoreCase("file")) continue;
                    if (fileIndex != null) {
                        throw new IOException("Malformed PushProxy Req");
                    }
                    fileIndex = Integer.valueOf(val);
                    if (fileIndex < 0) {
                        throw new IOException("Malformed PushProxy Req");
                    }
                    if (parameters == null) {
                        parameters = new HashMap<String, Integer>();
                    }
                    parameters.put("file", fileIndex);
                }
                if (RECORD_STATS) {
                    UploadStat.PUSH_PROXY.incrementStat();
                }
            } else {
                int g = requestLine.indexOf("/get/");
                int d = requestLine.indexOf("/", g + 5);
                String str_index = requestLine.substring(g + 5, d);
                index = Integer.parseInt(str_index);
                int f = requestLine.indexOf(" HTTP/", d);
                try {
                    fileName = URLDecoder.decode(requestLine.substring(d + 1, f));
                }
                catch (IllegalArgumentException e) {
                    fileName = requestLine.substring(d + 1, f);
                }
                if (RECORD_STATS) {
                    UploadStat.TRADITIONAL_GET.incrementStat();
                }
            }
            boolean http11 = UploadManager.isHTTP11Request(requestLine);
            return new HttpRequestLine(index, fileName, http11, parameters);
        }
        catch (NumberFormatException e) {
            throw new IOException();
        }
        catch (IndexOutOfBoundsException e) {
            throw new IOException();
        }
    }

    private HttpRequestLine parseURNGet(String requestLine) throws IOException {
        URN urn = URN.createSHA1UrnFromHttpRequest(requestLine);
        FileDesc desc = RouterService.getFileManager().getFileDescForUrn(urn);
        if (desc == null) {
            if (RECORD_STATS) {
                UploadStat.UNKNOWN_URN_GET.incrementStat();
            }
            return new HttpRequestLine(-3, "Invalid URN query", UploadManager.isHTTP11Request(requestLine));
        }
        if (RECORD_STATS) {
            UploadStat.URN_GET.incrementStat();
        }
        return new HttpRequestLine(desc.getIndex(), desc.getName(), UploadManager.isHTTP11Request(requestLine));
    }

    private HttpRequestLine parseMalformedURNGet(String requestLine) throws IOException {
        return this.parseURNGet(requestLine.substring(7));
    }

    private static boolean isHTTP11Request(String requestLine) {
        return requestLine.endsWith("1.1");
    }

    private void assertAsConnecting(int state) {
        Assert.that(state == 0, "invalid state: " + state);
    }

    private void assertAsComplete(int state) {
        Assert.that(state == 4, "invalid state: " + state);
    }

    private void assertAsFinished(int state) {
        Assert.that(state == 5 || state == 4, "invalid state: " + state);
    }

    public synchronized void measureBandwidth() {
        float currentTotal = 0.0f;
        boolean c = false;
        Iterator iter = this._activeUploadList.iterator();
        while (iter.hasNext()) {
            c = true;
            BandwidthTracker bt = (BandwidthTracker)iter.next();
            bt.measureBandwidth();
            currentTotal += bt.getAverageBandwidth();
        }
        if (c) {
            this.averageBandwidth = (this.averageBandwidth * (float)this.numMeasures + currentTotal) / (float)(++this.numMeasures);
        }
    }

    public synchronized float getMeasuredBandwidth() {
        float sum = 0.0f;
        Iterator iter = this._activeUploadList.iterator();
        while (iter.hasNext()) {
            BandwidthTracker bt = (BandwidthTracker)iter.next();
            float curr = 0.0f;
            try {
                curr = bt.getMeasuredBandwidth();
            }
            catch (InsufficientDataException ide) {
                curr = 0.0f;
            }
            sum += curr;
        }
        return sum;
    }

    public synchronized float getAverageBandwidth() {
        return this.averageBandwidth;
    }

    private static final void debug(String out) {
    }

    private static final void debug(Exception e) {
    }

    static void tBandwidthTracker(UploadManager upman) {
        upman.reportUploadSpeed(100000L, 1000000L);
        Assert.that(upman.measuredUploadSpeed() == -1);
        upman.reportUploadSpeed(100000L, 2000000L);
        Assert.that(upman.measuredUploadSpeed() == -1);
        upman.reportUploadSpeed(100000L, 3000000L);
        Assert.that(upman.measuredUploadSpeed() == -1);
        upman.reportUploadSpeed(100000L, 4000000L);
        Assert.that(upman.measuredUploadSpeed() == -1);
        upman.reportUploadSpeed(100000L, 5000000L);
        Assert.that(upman.measuredUploadSpeed() == 400);
        upman.reportUploadSpeed(100000L, 6000000L);
        Assert.that(upman.measuredUploadSpeed() == 480);
        upman.reportUploadSpeed(1L, 1000L);
        Assert.that(upman.measuredUploadSpeed() == 480);
        upman.reportUploadSpeed(100000L, 1000000L);
        upman.reportUploadSpeed(100000L, 1000000L);
        upman.reportUploadSpeed(100000L, 1000000L);
        upman.reportUploadSpeed(100000L, 1000000L);
        upman.reportUploadSpeed(100000L, 1000000L);
        Assert.that(upman.measuredUploadSpeed() == 80);
    }

    private static final class HttpRequestLine {
        final int _index;
        final String _fileName;
        final boolean _http11;
        final Map _params;

        HttpRequestLine(int index, String fileName, boolean http11) {
            this(index, fileName, http11, DataUtils.EMPTY_MAP);
        }

        HttpRequestLine(int index, String fName, boolean http11, Map params) {
            this._index = index;
            this._fileName = fName;
            this._http11 = http11;
            this._params = params == null ? DataUtils.EMPTY_MAP : params;
        }

        boolean isHTTP11() {
            return this._http11;
        }

        Map getParameters() {
            return this._params;
        }
    }
}

