/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;

public final class UDPService
implements Runnable {
    private static final UDPService INSTANCE = new UDPService();
    private volatile DatagramSocket _socket;
    private final Object _receiveLock = new Object();
    private final Object _sendLock = new Object();
    private final int BUFFER_SIZE = 32768;
    private boolean _acceptedSolicitedIncoming = false;
    private boolean _acceptedUnsolicitedIncoming = false;
    private final Thread UDP_THREAD;
    private final GUID CONNECT_BACK_GUID = new GUID(GUID.makeGuid());

    public static UDPService instance() {
        return INSTANCE;
    }

    private UDPService() {
        this.UDP_THREAD = new Thread((Runnable)this, "UDPService");
        this.UDP_THREAD.setDaemon(true);
    }

    public void start() {
        this.UDP_THREAD.start();
    }

    public GUID getConnectBackGUID() {
        return this.CONNECT_BACK_GUID;
    }

    public DatagramSocket newListeningSocket(int port) throws IOException {
        try {
            return new DatagramSocket(port);
        }
        catch (SocketException se) {
            throw new IOException("socket could not be set on port: " + port);
        }
        catch (SecurityException se) {
            throw new IOException("security exception on port: " + port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListeningSocket(DatagramSocket datagramSocket) {
        if (this._socket != null) {
            this._socket.close();
        }
        Object object = this._receiveLock;
        synchronized (object) {
            Object object2 = this._sendLock;
            synchronized (object2) {
                this._socket = datagramSocket;
                this._receiveLock.notify();
                this._sendLock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            byte[] datagramBytes = new byte[32768];
            MessageRouter router = RouterService.getMessageRouter();
            while (true) {
                DatagramPacket datagram = new DatagramPacket(datagramBytes, 32768);
                Object object = this._receiveLock;
                synchronized (object) {
                    while (this._socket == null) {
                        try {
                            this._receiveLock.wait();
                        }
                        catch (InterruptedException ignored) {}
                    }
                    try {
                        this._socket.receive(datagram);
                    }
                    catch (InterruptedIOException e) {
                        continue;
                    }
                    catch (IOException e) {
                        continue;
                    }
                }
                byte[] data = datagram.getData();
                try {
                    ByteArrayInputStream in = new ByteArrayInputStream(data);
                    Message message = Message.read((InputStream)in, 2);
                    if (message == null) continue;
                    if (!this.isGUESSCapable()) {
                        if (message instanceof PingRequest) {
                            GUID guidReceived = new GUID(message.getGUID());
                            if (this.CONNECT_BACK_GUID.equals(guidReceived)) {
                                this._acceptedUnsolicitedIncoming = true;
                            }
                        } else {
                            this._acceptedSolicitedIncoming = true;
                        }
                    }
                    router.handleUDPMessage(message, datagram);
                }
                catch (IOException e) {
                }
                catch (BadPacketException e) {}
            }
        }
        catch (Throwable t) {
            ErrorService.error(t);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void send(Message msg, InetAddress ip, int port) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            msg.write(baos);
        }
        catch (IOException e) {
            ErrorService.error(e);
            return;
        }
        byte[] data = baos.toByteArray();
        DatagramPacket dg = new DatagramPacket(data, data.length, ip, port);
        Object object = this._sendLock;
        synchronized (object) {
            if (this._socket == null) {
                return;
            }
            try {
                this._socket.send(dg);
            }
            catch (BindException be) {
                return;
            }
            catch (IOException ioe) {
                if ("No buffer space available".equals(ioe.getMessage())) {
                    return;
                }
                throw ioe;
            }
        }
    }

    public boolean isGUESSCapable() {
        return this.canReceiveUnsolicited() && this.canReceiveSolicited();
    }

    public boolean canReceiveUnsolicited() {
        return this._acceptedUnsolicitedIncoming;
    }

    public boolean canReceiveSolicited() {
        return this._acceptedSolicitedIncoming;
    }

    public boolean isListening() {
        if (this._socket == null) {
            return false;
        }
        return this._socket.getLocalPort() != -1;
    }

    public String toString() {
        return "UDPAcceptor\r\nsocket: " + this._socket;
    }
}

