/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PushRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import com.limegroup.gnutella.util.CommonUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class UDPReplyHandler
implements ReplyHandler {
    private final InetAddress IP;
    private final int PORT;
    private static final Set EMPTY_SET = Collections.unmodifiableSet(new HashSet());
    private static final UDPService UDP_SERVICE = UDPService.instance();
    private final boolean RECORD_STATS = !CommonUtils.isJava118();

    public UDPReplyHandler(InetAddress ip, int port) {
        this.IP = ip;
        this.PORT = port;
    }

    public void handlePingReply(PingReply pong, ReplyHandler handler) {
        try {
            UDP_SERVICE.send(pong, this.IP, this.PORT);
        }
        catch (IOException ioe) {
            ErrorService.error(ioe, "ip/port: " + this.IP + ":" + this.PORT);
        }
        if (this.RECORD_STATS) {
            SentMessageStatHandler.UDP_PING_REPLIES.addMessage(pong);
        }
    }

    public void handleQueryReply(QueryReply hit, ReplyHandler handler) {
        try {
            UDP_SERVICE.send(hit, this.IP, this.PORT);
        }
        catch (IOException ioe) {
            ErrorService.error(ioe, "ip/port: " + this.IP + ":" + this.PORT);
        }
        if (this.RECORD_STATS) {
            SentMessageStatHandler.UDP_QUERY_REPLIES.addMessage(hit);
        }
    }

    public void handlePushRequest(PushRequest request, ReplyHandler handler) {
        try {
            UDP_SERVICE.send(request, this.IP, this.PORT);
        }
        catch (IOException ioe) {
            ErrorService.error(ioe, "ip/port: " + this.IP + ":" + this.PORT);
        }
        if (this.RECORD_STATS) {
            SentMessageStatHandler.UDP_PUSH_REQUESTS.addMessage(request);
        }
    }

    public void countDroppedMessage() {
    }

    public Set getDomains() {
        return EMPTY_SET;
    }

    public boolean isPersonalSpam(Message m) {
        return false;
    }

    public boolean isOpen() {
        return true;
    }

    public int getNumMessagesReceived() {
        return 0;
    }

    public boolean isOutgoing() {
        return false;
    }

    public boolean isKillable() {
        return false;
    }

    public boolean isSupernodeClientConnection() {
        return false;
    }

    public boolean isLeafConnection() {
        return false;
    }

    public boolean isHighDegreeConnection() {
        return false;
    }

    public boolean isUltrapeerQueryRoutingConnection() {
        return false;
    }

    public boolean isGoodUltrapeer() {
        return false;
    }

    public boolean isGoodLeaf() {
        return false;
    }

    public boolean supportsPongCaching() {
        return false;
    }

    public boolean allowNewPings() {
        return true;
    }

    public InetAddress getInetAddress() {
        return this.IP;
    }

    public boolean isStable() {
        return false;
    }

    public String toString() {
        return "UDPReplyHandler:\r\n" + this.IP.toString() + "\r\n" + this.PORT + "\r\n";
    }
}

