/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.BandwidthTracker;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.DownloadSettings;
import com.limegroup.gnutella.settings.UltrapeerSettings;
import com.limegroup.gnutella.settings.UploadSettings;
import com.limegroup.gnutella.statistics.BandwidthStat;
import com.limegroup.gnutella.util.CommonUtils;

public final class SupernodeAssigner {
    private static final int MINIMUM_REQUIRED_UPSTREAM_KBYTES_PER_SECOND = 10;
    private static final int MINIMUM_REQUIRED_DOWNSTREAM_KBYTES_PER_SECOND = 20;
    private static final int MINIMUM_AVERAGE_UPTIME = 3600;
    private static final int MINIMUM_CURRENT_UPTIME = 7200;
    private static final boolean ULTRAPEER_OS = CommonUtils.isUltrapeerOS();
    public static final int TIMER_DELAY = 1000;
    private static final int TIMER_DELAY_IN_SECONDS = 1;
    private static BandwidthTracker _uploadTracker;
    private static BandwidthTracker _downloadTracker;
    private static ConnectionManager _manager;
    private static long _currentUptime;
    private static int _maxUpstreamBytesPerSec;
    private static int _maxDownstreamBytesPerSec;
    private static volatile boolean _isTooGoodToPassUp;
    private static long _lastAttempt;
    private static int _ultrapeerTries;
    private static final int RETRY_TIME = 10800000;

    public SupernodeAssigner(BandwidthTracker uploadTracker, BandwidthTracker downloadTracker, ConnectionManager manager) {
        _uploadTracker = uploadTracker;
        _downloadTracker = downloadTracker;
        _manager = manager;
    }

    public void start() {
        Runnable task = new Runnable(){

            public void run() {
                try {
                    SupernodeAssigner.collectBandwidthData();
                }
                catch (Throwable t) {
                    ErrorService.error(t);
                }
            }
        };
        RouterService.schedule(task, 0L, 1000L);
    }

    private static void setUltrapeerCapable() {
        if (UltrapeerSettings.DISABLE_ULTRAPEER_MODE.getValue()) {
            UltrapeerSettings.EVER_ULTRAPEER_CAPABLE.setValue(false);
            return;
        }
        if (RouterService.isSupernode()) {
            return;
        }
        boolean isUltrapeerCapable = !(_maxUpstreamBytesPerSec < 10 && _maxDownstreamBytesPerSec < 20 || ConnectionSettings.CONNECTION_SPEED.getValue() <= 56 || ApplicationSettings.AVERAGE_UPTIME.getValue() < 3600 && _currentUptime < 7200L || !ConnectionSettings.EVER_ACCEPTED_INCOMING.getValue() || !ULTRAPEER_OS);
        long curTime = System.currentTimeMillis();
        boolean bl = _isTooGoodToPassUp = isUltrapeerCapable && curTime - RouterService.getLastQueryTime() > 300000L && BandwidthStat.HTTP_UPSTREAM_BANDWIDTH.getAverage() < 1.0;
        if (isUltrapeerCapable) {
            UltrapeerSettings.EVER_ULTRAPEER_CAPABLE.setValue(true);
        }
        if (_isTooGoodToPassUp && SupernodeAssigner.shouldTryToBecomeAnUltrapeer(curTime)) {
            final int demotes = 4 * ++_ultrapeerTries;
            Runnable ultrapeerRunner = new Runnable(){

                public void run() {
                    RouterService.getConnectionManager().tryToBecomeAnUltrapeer(demotes);
                }
            };
            Thread ultrapeerThread = new Thread(ultrapeerRunner, "UltrapeerAttemptThread");
            ultrapeerThread.setDaemon(true);
            ultrapeerThread.start();
        }
    }

    private static boolean shouldTryToBecomeAnUltrapeer(long curTime) {
        if (curTime - _lastAttempt < 10800000L) {
            return false;
        }
        _lastAttempt = curTime;
        return true;
    }

    public static boolean isTooGoodToPassUp() {
        return _isTooGoodToPassUp;
    }

    private static void collectBandwidthData() {
        ++_currentUptime;
        _uploadTracker.measureBandwidth();
        _downloadTracker.measureBandwidth();
        _manager.measureBandwidth();
        float bandwidth = 0.0f;
        try {
            bandwidth = _uploadTracker.getMeasuredBandwidth();
        }
        catch (InsufficientDataException ide) {
            bandwidth = 0.0f;
        }
        int newUpstreamBytesPerSec = (int)bandwidth + (int)_manager.getMeasuredUpstreamBandwidth();
        bandwidth = 0.0f;
        try {
            bandwidth = _downloadTracker.getMeasuredBandwidth();
        }
        catch (InsufficientDataException ide) {
            bandwidth = 0.0f;
        }
        int newDownstreamBytesPerSec = (int)bandwidth + (int)_manager.getMeasuredDownstreamBandwidth();
        if (newUpstreamBytesPerSec > _maxUpstreamBytesPerSec) {
            _maxUpstreamBytesPerSec = newUpstreamBytesPerSec;
            UploadSettings.MAX_UPLOAD_BYTES_PER_SEC.setValue(_maxUpstreamBytesPerSec);
        }
        if (newDownstreamBytesPerSec > _maxDownstreamBytesPerSec) {
            _maxDownstreamBytesPerSec = newDownstreamBytesPerSec;
            DownloadSettings.MAX_DOWNLOAD_BYTES_PER_SEC.setValue(_maxDownstreamBytesPerSec);
        }
        SupernodeAssigner.setUltrapeerCapable();
    }

    static {
        _currentUptime = 0L;
        _maxUpstreamBytesPerSec = UploadSettings.MAX_UPLOAD_BYTES_PER_SEC.getValue();
        _maxDownstreamBytesPerSec = DownloadSettings.MAX_DOWNLOAD_BYTES_PER_SEC.getValue();
        _isTooGoodToPassUp = false;
        _lastAttempt = 0L;
        _ultrapeerTries = 0;
    }
}

