/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.BadConnectionSettingException;
import com.limegroup.gnutella.BrowseHostHandler;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ConnectionWatchdog;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.HorizonCounter;
import com.limegroup.gnutella.HostCatcher;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.Pinger;
import com.limegroup.gnutella.PushManager;
import com.limegroup.gnutella.QueryUnicaster;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.ResponseVerifier;
import com.limegroup.gnutella.StandardMessageRouter;
import com.limegroup.gnutella.Statistics;
import com.limegroup.gnutella.SupernodeAssigner;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.UrnCache;
import com.limegroup.gnutella.browser.HTTPAcceptor;
import com.limegroup.gnutella.downloader.AlreadyDownloadingException;
import com.limegroup.gnutella.downloader.CantResumeException;
import com.limegroup.gnutella.downloader.FileExistsException;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.filters.SpamFilter;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.search.SearchResultHandler;
import com.limegroup.gnutella.security.Authenticator;
import com.limegroup.gnutella.security.Cookies;
import com.limegroup.gnutella.security.ServerAuthenticator;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.SettingsHandler;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.SimpleTimer;
import com.limegroup.gnutella.xml.MetaFileManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class RouterService {
    private static FileManager fileManager = new MetaFileManager();
    private static final Authenticator authenticator = new ServerAuthenticator();
    private static final SimpleTimer timer = new SimpleTimer(true);
    private static final Acceptor acceptor = new Acceptor();
    private static ConnectionManager manager = new ConnectionManager(authenticator);
    private static HostCatcher catcher = new HostCatcher();
    private static final DownloadManager downloader = new DownloadManager();
    private static UploadManager uploadManager = new UploadManager();
    private static PushManager pushManager = new PushManager();
    private static final ResponseVerifier verifier = new ResponseVerifier();
    private static final Statistics statistics = Statistics.instance();
    private static final UDPService udpService = UDPService.instance();
    private static final SearchResultHandler RESULT_HANDLER = new SearchResultHandler();
    private static boolean isShuttingDown;
    private static ActivityCallback callback;
    private static MessageRouter router;
    private static boolean _started;
    private static long _lastQueryTime;

    public static byte[] queryWithString2(String s) {
        byte[] guid = RouterService.newQueryGUID();
        RouterService.query(guid, s, "", null);
        return guid;
    }

    public RouterService(ActivityCallback callback) {
        this(callback, new StandardMessageRouter());
    }

    public RouterService(ActivityCallback ac, MessageRouter mr, FileManager fm) {
        this(ac, mr);
        fileManager = fm;
    }

    public RouterService(ActivityCallback callback, MessageRouter router) {
        RouterService.callback = callback;
        RouterService.router = router;
    }

    public void start() {
        int outgoing;
        if (RouterService.isStarted()) {
            return;
        }
        _started = true;
        acceptor.start();
        RESULT_HANDLER.start();
        router.initialize();
        manager.initialize();
        downloader.initialize();
        SupernodeAssigner sa = new SupernodeAssigner(uploadManager, downloader, manager);
        sa.start();
        if (ConnectionSettings.CONNECT_ON_STARTUP.getValue() && (outgoing = ConnectionSettings.NUM_CONNECTIONS.getValue()) > 0) {
            RouterService.connect();
        }
        catcher.initialize();
        fileManager.start();
        downloader.postGuiInit();
        QueryUnicaster.instance().start();
        new HTTPAcceptor().start();
        Pinger.instance().start();
        ConnectionWatchdog.instance().start();
    }

    public static boolean isStarted() {
        return _started;
    }

    public static ActivityCallback getCallback() {
        return callback;
    }

    public static MessageRouter getMessageRouter() {
        return router;
    }

    public static FileManager getFileManager() {
        return fileManager;
    }

    public static DownloadManager getDownloadManager() {
        return downloader;
    }

    public static UDPService getUdpService() {
        return udpService;
    }

    public static ConnectionManager getConnectionManager() {
        return manager;
    }

    public static UploadManager getUploadManager() {
        return uploadManager;
    }

    public static PushManager getPushManager() {
        return pushManager;
    }

    public static Acceptor getAcceptor() {
        return acceptor;
    }

    public static HostCatcher getHostCatcher() {
        return catcher;
    }

    public static SearchResultHandler getSearchResultHandler() {
        return RESULT_HANDLER;
    }

    public static void schedule(Runnable task, long delay, long period) {
        timer.schedule(task, delay, period);
    }

    public static ManagedConnection connectToHostBlocking(String hostname, int portnum) throws IOException {
        return manager.createConnectionBlocking(hostname, portnum);
    }

    public static void connectToHostAsynchronously(String hostname, int portnum) {
        InetAddress addr;
        byte[] cIP = null;
        try {
            addr = InetAddress.getByName(hostname);
            cIP = addr.getAddress();
        }
        catch (UnknownHostException e) {
            return;
        }
        if (cIP[0] == 127 && portnum == acceptor.getPort(true) && ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return;
        }
        byte[] managerIP = acceptor.getAddress(true);
        if (Arrays.equals(cIP, managerIP) && portnum == acceptor.getPort(true)) {
            return;
        }
        if (!acceptor.isBannedIP(addr.getHostAddress())) {
            manager.createConnectionAsynchronously(hostname, portnum);
        }
    }

    public static void connect() {
        RouterService.adjustSpamFilters();
        manager.connect();
    }

    public static void disconnect() {
        manager.disconnect();
    }

    public static void removeConnection(ManagedConnection c) {
        manager.remove(c);
    }

    public static void clearHostCatcher() {
        catcher.clear();
    }

    public static int getRealNumHosts() {
        return catcher.getNumHosts();
    }

    public static int getNumDownloads() {
        return downloader.downloadsInProgress();
    }

    public static int getNumActiveDownloads() {
        return downloader.getNumActiveDownloads();
    }

    public static int getNumWaitingDownloads() {
        return downloader.getNumWaitingDownloads();
    }

    public static int getNumIndividualDownloaders() {
        return downloader.getNumIndividualDownloaders();
    }

    public static int getNumUploads() {
        return uploadManager.uploadsInProgress();
    }

    public static int getNumQueuedUploads() {
        return uploadManager.getNumQueuedUploads();
    }

    public static long getCurrentUptime() {
        return statistics.getUptime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        try {
            Statistics.instance().shutdown();
            try {
                catcher.write();
            }
            catch (IOException e) {
            }
            finally {
                SettingsHandler.save();
            }
            File incompleteDir = SharingSettings.INCOMPLETE_DIRECTORY.getValue();
            if (incompleteDir == null) {
                return;
            }
            String[] files = incompleteDir.list();
            if (files == null) {
                return;
            }
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].startsWith("Preview-")) continue;
                File file = new File(incompleteDir, files[i]);
                file.delete();
            }
            downloader.writeSnapshot();
            Cookies.instance().save();
            UrnCache.instance().persistCache();
        }
        catch (Throwable t) {
            ErrorService.error(t);
        }
    }

    public static void forceKeepAlive(int newKeep) {
        manager.setKeepAlive(newKeep);
    }

    public static void setKeepAlive(int newKeep) throws BadConnectionSettingException {
        if (newKeep < 0) {
            throw new BadConnectionSettingException(1, ConnectionSettings.NUM_CONNECTIONS.getValue());
        }
        int max = ConnectionSettings.getMaxConnections();
        if (manager.hasSupernodeClientConnection()) {
            if (newKeep < ConnectionManager.ULTRAPEER_CONNECTIONS) {
                throw new BadConnectionSettingException(4, ConnectionManager.ULTRAPEER_CONNECTIONS);
            }
            if (newKeep > ConnectionManager.ULTRAPEER_CONNECTIONS && newKeep > max) {
                throw new BadConnectionSettingException(2, ConnectionManager.ULTRAPEER_CONNECTIONS > max ? ConnectionManager.ULTRAPEER_CONNECTIONS : max);
            }
        } else if (newKeep > max) {
            throw new BadConnectionSettingException(2, max);
        }
        if (ConnectionSettings.NUM_CONNECTIONS.getValue() == 0) {
            catcher.expire();
        }
        RouterService.forceKeepAlive(newKeep);
    }

    public static void adjustSpamFilters() {
        IPFilter.refreshIPFilter();
        Iterator iter = manager.getConnections().iterator();
        while (iter.hasNext()) {
            ManagedConnection c = (ManagedConnection)iter.next();
            c.setPersonalFilter(SpamFilter.newPersonalFilter());
            c.setRouteFilter(SpamFilter.newRouteFilter());
        }
    }

    public static void setListeningPort(int port) throws IOException {
        acceptor.setListeningPort(port);
    }

    public static void setAlwaysNotifyKnownHost(boolean notify) {
        catcher.setAlwaysNotifyKnownHost(notify);
    }

    public static boolean acceptedIncomingConnection() {
        return acceptor.acceptedIncoming();
    }

    public static int getActiveConnectionMessages() {
        int count = 0;
        Iterator iter = manager.getInitializedConnections().iterator();
        while (iter.hasNext()) {
            ManagedConnection c = (ManagedConnection)iter.next();
            count += c.getNumMessagesSent();
            count += c.getNumMessagesReceived();
        }
        return count;
    }

    public static int countConnectionsWithNMessages(int messageThreshold) {
        int count = 0;
        Iterator iter = manager.getInitializedConnections().iterator();
        while (iter.hasNext()) {
            ManagedConnection c = (ManagedConnection)iter.next();
            int msgs = c.getNumMessagesSent();
            if ((msgs += c.getNumMessagesReceived()) <= messageThreshold) continue;
            ++count;
        }
        return count;
    }

    public static long getNumHosts() {
        return HorizonCounter.instance().getNumHosts();
    }

    public static long getNumFiles() {
        return HorizonCounter.instance().getNumFiles();
    }

    public static long getTotalFileSize() {
        return HorizonCounter.instance().getTotalFileSize();
    }

    public static void dumpConnections() {
        System.out.println("UltraPeer connections");
        RouterService.dumpConnections(manager.getInitializedConnections2());
        System.out.println("Leaf connections");
        RouterService.dumpConnections(manager.getInitializedClientConnections2());
    }

    private static void dumpConnections(Collection connections) {
        Iterator iterator = connections.iterator();
        while (iterator.hasNext()) {
            System.out.println(iterator.next().toString());
        }
    }

    public static void updateHorizon() {
        HorizonCounter.instance().refresh();
    }

    public static byte[] newQueryGUID() {
        return QueryRequest.newQueryGUID(false);
    }

    public static void query(byte[] guid, String query, MediaType type) {
        RouterService.query(guid, query, "", type);
    }

    public static void query(byte[] guid, String query) {
        RouterService.query(guid, query, null);
    }

    public static void query(byte[] guid, String query, String richQuery, MediaType type) {
        try {
            _lastQueryTime = System.currentTimeMillis();
            QueryRequest qr = QueryRequest.createQuery(guid, query, richQuery);
            verifier.record(qr, type);
            router.sendDynamicQuery(qr);
        }
        catch (Throwable t) {
            ErrorService.error(t);
        }
    }

    public static long getLastQueryTime() {
        return _lastQueryTime;
    }

    public static void stopQuery(GUID guid) {
        QueryUnicaster.instance().purgeQuery(guid);
    }

    public static boolean matchesType(byte[] guid, Response response) {
        return verifier.matchesType(guid, response);
    }

    public static boolean isMandragoreWorm(byte[] guid, Response response) {
        return verifier.isMandragoreWorm(guid, response);
    }

    public static Iterator getHosts() {
        return catcher.getHosts();
    }

    public static int getNumConnections() {
        return manager.getNumConnections();
    }

    public static int getNumInitializedConnections() {
        return manager.getNumInitializedConnections();
    }

    public static int getNumUltrapeerToLeafConnections() {
        return manager.getNumInitializedClientConnections();
    }

    public static int getNumLeafToUltrapeerConnections() {
        return manager.getNumClientSupernodeConnections();
    }

    public static int getNumUltrapeerToUltrapeerConnections() {
        return manager.getNumUltrapeerConnections();
    }

    public static int getNumOldConnections() {
        return manager.getNumOldConnections();
    }

    public static boolean isConnected() {
        return manager.isConnected();
    }

    public static void removeHost(String host, int port) {
        catcher.removeHost(host, port);
    }

    public static int getNumSharedFiles() {
        int result = fileManager.getNumFiles() + RouterService.getNumPendingShared();
        return result;
    }

    public static int getNumPendingShared() {
        return fileManager.getNumPendingFiles();
    }

    public static int getSharedFileSize() {
        return fileManager.getSize();
    }

    public static FileDesc[] getIncompleteFileDescriptors() {
        return fileManager.getIncompleteFileDescriptors();
    }

    public static FileDesc[] getSharedFileDescriptors(File directory) {
        if (directory == null) {
            return fileManager.getAllSharedFileDescriptors();
        }
        return fileManager.getSharedFileDescriptors(directory);
    }

    public static Downloader download(RemoteFileDesc[] files, boolean overwrite) throws FileExistsException, AlreadyDownloadingException, FileNotFoundException {
        return downloader.download(files, overwrite);
    }

    public static synchronized Downloader download(URN urn, String textQuery, String filename, String[] defaultURL) throws IllegalArgumentException, AlreadyDownloadingException {
        return downloader.download(urn, textQuery, filename, defaultURL);
    }

    public static Downloader download(File incompleteFile) throws AlreadyDownloadingException, CantResumeException {
        return downloader.download(incompleteFile);
    }

    public static Downloader download(String query, String richQuery, byte[] guid, MediaType type) throws AlreadyDownloadingException {
        return downloader.download(query, richQuery, guid, type);
    }

    public static void doBrowseHost(String host, int port, GUID guid, GUID serventID, Set proxies) {
        BrowseHostHandler handler = new BrowseHostHandler(callback, guid, serventID);
        handler.browseHost(host, port, proxies);
    }

    public static boolean isSupernode() {
        return manager.isSupernode();
    }

    public static boolean isShieldedLeaf() {
        return manager.isShieldedLeaf();
    }

    public static int getNumFreeLeafSlots() {
        return manager.getNumFreeLeafSlots();
    }

    public static int getNumFreeNonLeafSlots() {
        return manager.getNumFreeNonLeafSlots();
    }

    public static void setIsShuttingDown(boolean flag) {
        isShuttingDown = flag;
    }

    public static boolean getIsShuttingDown() {
        return isShuttingDown;
    }

    public static byte[] getAddress() {
        return acceptor.getAddress(true);
    }

    public static byte[] getNonForcedAddress() {
        return acceptor.getAddress(false);
    }

    public static int getPort() {
        return acceptor.getPort(true);
    }

    public static int getNonForcedPort() {
        return acceptor.getPort(false);
    }

    public static boolean isGUESSCapable() {
        return udpService.isGUESSCapable();
    }

    public static GUID getUDPConnectBackGUID() {
        return udpService.getConnectBackGUID();
    }

    static {
        _lastQueryTime = 0L;
    }
}

