/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.xml.sax.SAXException;

public class Response {
    private final long index;
    private final long size;
    private final byte[] nameBytes;
    private final String name;
    private String metadata;
    private byte[] metaBytes;
    private LimeXMLDocument document;
    private final Set urns;
    private final byte[] extBytes;
    private static final String AUDIOS_NAMESPACE = "<audios xsi:noNamespaceSchemaLocation=\"http://www.limewire.com/schemas/audio.xsd\">";
    private static final String AUDIO_TITLE = "<audio title=\"";
    private static final String AUDIO_BITRATE = "bitrate=\"";
    private static final String AUDIO_SECONDS = "seconds=\"";
    private static final String AUDIOS_CLOSE = "</audio></audios>";
    private static final String QUOTE_SPACE = "\" ";
    private static final String CLOSE_TAG = "\">";
    private static final String KBPS = "kbps";
    private static final String KHZ = "kHz";

    public Response(long index, long size, String name) {
        this(index, size, name, "", null, null, null);
    }

    public Response(long index, long size, String name, LimeXMLDocument doc) {
        this(index, size, name, Response.extractMetadata(doc), null, doc, null);
    }

    public Response(long index, long size, String name, String metadata) {
        this(index, size, name, metadata, null, null, null);
    }

    public Response(FileDesc fd) {
        this(fd.getIndex(), fd.getSize(), fd.getName(), "", fd.getUrns(), null, null);
    }

    public Response(long index, long size, String name, String metadata, Set urns, LimeXMLDocument doc, byte[] rawMeta) {
        if ((index & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException("invalid index: " + index);
        }
        if (size > Integer.MAX_VALUE || size < 0L) {
            throw new IllegalArgumentException("invalid size: " + size);
        }
        this.index = index;
        this.size = size;
        this.name = name == null ? "" : name;
        this.nameBytes = this.name.getBytes();
        this.urns = urns == null ? DataUtils.EMPTY_SET : Collections.unmodifiableSet(urns);
        this.extBytes = rawMeta != null ? rawMeta : Response.createExtBytes(this.urns);
        this.metadata = (metadata == null || metadata.equals("")) && doc != null ? Response.extractMetadata(doc) : (metadata == null ? "" : metadata.trim());
        Assert.that(this.metadata != null, "Null metadata");
        try {
            this.metaBytes = this.metadata.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ueex) {
            this.metaBytes = this.metadata.getBytes();
        }
        this.document = doc;
    }

    public static Response createFromStream(InputStream is) throws IOException {
        int c;
        long index = ByteOrder.ubytes2long(ByteOrder.leb2int(is));
        long size = ByteOrder.ubytes2long(ByteOrder.leb2int(is));
        if ((index & 0xFFFFFFFF00000000L) != 0L) {
            throw new IOException("invalid index: " + index);
        }
        if (size > Integer.MAX_VALUE || size < 0L) {
            throw new IOException("invalid size: " + size);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((c = is.read()) != 0) {
            baos.write(c);
        }
        String name = new String(baos.toByteArray());
        if (name.length() == 0) {
            throw new IOException("empty name in response");
        }
        baos.reset();
        while ((c = is.read()) != 0) {
            baos.write(c);
        }
        byte[] rawMeta = baos.toByteArray();
        String betweenNulls = new String(rawMeta);
        if (betweenNulls == null || betweenNulls.equals("")) {
            if (is.available() < 16) {
                throw new IOException("not enough room for the GUID");
            }
            return new Response(index, size, name);
        }
        StringTokenizer stok = new StringTokenizer(betweenNulls, "\u001c");
        HashSet<URN> urns = null;
        String metaString = null;
        while (stok.hasMoreTokens()) {
            String ext = stok.nextToken();
            if (URN.isUrn(ext)) {
                try {
                    URN urn = URN.createSHA1Urn(ext);
                    if (urns == null) {
                        urns = new HashSet<URN>();
                    }
                    urns.add(urn);
                }
                catch (IOException e) {}
                continue;
            }
            metaString = Response.createXmlString(name, ext);
        }
        return new Response(index, size, name, metaString, urns, null, rawMeta);
    }

    private static String createXmlString(String name, String ext) {
        StringTokenizer tok = new StringTokenizer(ext);
        if (tok.countTokens() < 2) {
            return "";
        }
        String first = tok.nextToken();
        String second = tok.nextToken();
        if (first != null) {
            first = first.toLowerCase();
        }
        if (second != null) {
            second = second.toLowerCase();
        }
        String length = "";
        String bitrate = "";
        boolean bearShare1 = false;
        boolean bearShare2 = false;
        boolean gnotella = false;
        if (second.startsWith(KBPS)) {
            bearShare1 = true;
        } else if (first.endsWith(KBPS)) {
            bearShare2 = true;
        }
        if (bearShare1) {
            bitrate = first;
        } else if (bearShare2) {
            int j = first.indexOf(KBPS);
            bitrate = first.substring(0, j);
        }
        if (bearShare1 || bearShare2) {
            while (tok.hasMoreTokens()) {
                length = tok.nextToken();
            }
        } else if (ext.endsWith(KHZ)) {
            gnotella = true;
            length = first;
            int i = second.indexOf(KBPS);
            if (i > -1) {
                bitrate = second.substring(0, i);
            } else {
                gnotella = false;
            }
        }
        if (bearShare1 || bearShare2 || gnotella) {
            StringBuffer sb = new StringBuffer();
            sb.append(AUDIOS_NAMESPACE);
            sb.append(AUDIO_TITLE);
            sb.append(name);
            sb.append(QUOTE_SPACE);
            sb.append(AUDIO_BITRATE);
            sb.append(bitrate);
            sb.append(QUOTE_SPACE);
            sb.append(AUDIO_SECONDS);
            sb.append(length);
            sb.append(CLOSE_TAG);
            sb.append(AUDIOS_CLOSE);
            return sb.toString();
        }
        return "";
    }

    private static byte[] createExtBytes(Set urns) {
        try {
            if (urns == null) {
                return DataUtils.EMPTY_BYTE_ARRAY;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Iterator iter = urns.iterator();
            while (iter.hasNext()) {
                URN urn = (URN)iter.next();
                Assert.that(urn != null, "Null URN");
                baos.write(urn.toString().getBytes());
                if (!iter.hasNext()) continue;
                baos.write(28);
            }
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            return DataUtils.EMPTY_BYTE_ARRAY;
        }
    }

    private static String extractMetadata(LimeXMLDocument doc) {
        if (doc == null) {
            return "";
        }
        try {
            return doc.getXMLString();
        }
        catch (SchemaNotFoundException schemaNotFoundException) {
            return "";
        }
    }

    public int writeToArray(byte[] array, int i) {
        ByteOrder.int2leb((int)this.index, array, i);
        ByteOrder.int2leb((int)this.size, array, i + 4);
        System.arraycopy(this.nameBytes, 0, array, i += 8, this.nameBytes.length);
        i += this.nameBytes.length;
        array[i++] = 0;
        System.arraycopy(this.extBytes, 0, array, i, this.extBytes.length);
        i += this.extBytes.length;
        array[i++] = 0;
        return i;
    }

    public void writeToStream(OutputStream os) throws IOException {
        int i;
        ByteOrder.int2leb((int)this.index, os);
        ByteOrder.int2leb((int)this.size, os);
        for (i = 0; i < this.nameBytes.length; ++i) {
            os.write(this.nameBytes[i]);
        }
        os.write(0);
        for (i = 0; i < this.extBytes.length; ++i) {
            os.write(this.extBytes[i]);
        }
        os.write(0);
    }

    public void setDocument(LimeXMLDocument doc) {
        this.document = doc;
        this.metadata = Response.extractMetadata(this.document);
        this.metaBytes = this.metadata.getBytes();
    }

    public int getLength() {
        return 8 + this.nameBytes.length + 1 + this.extBytes.length + 1;
    }

    public long getIndex() {
        return this.index;
    }

    public long getSize() {
        return this.size;
    }

    public int getNameBytesSize() {
        return this.nameBytes.length;
    }

    public int getMetaBytesSize() {
        return this.metaBytes.length;
    }

    public byte[] getNameBytes() {
        byte[] copy = new byte[this.nameBytes.length];
        System.arraycopy(this.nameBytes, 0, copy, 0, this.nameBytes.length);
        return copy;
    }

    public byte[] getMetaBytes() {
        byte[] copy = new byte[this.metaBytes.length];
        System.arraycopy(this.metaBytes, 0, copy, 0, this.metaBytes.length);
        return copy;
    }

    public String getName() {
        return this.name;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public LimeXMLDocument getDocument() {
        if (this.document != null) {
            return this.document;
        }
        if (this.metadata != null) {
            try {
                this.document = new LimeXMLDocument(this.metadata);
                return this.document;
            }
            catch (SAXException e) {
            }
            catch (SchemaNotFoundException e) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public Set getUrns() {
        return this.urns;
    }

    byte[] getExtBytes() {
        return this.extBytes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Response)) {
            return false;
        }
        Response r = (Response)o;
        return this.getIndex() == r.getIndex() && this.getSize() == r.getSize() && this.getName().equals(r.getName()) && Arrays.equals(this.getNameBytes(), r.getNameBytes()) && this.getMetadata().equals(r.getMetadata()) && Arrays.equals(this.getMetaBytes(), r.getMetaBytes()) && (this.getDocument() == null ? r.getDocument() == null : this.getDocument().equals(r.getDocument())) && ((Object)this.getUrns()).equals(r.getUrns()) && Arrays.equals(this.getExtBytes(), r.getExtBytes());
    }

    public int hashCode() {
        return this.getName().hashCode() + (int)this.getSize() + (int)this.getIndex();
    }

    public String toString() {
        return "index:        " + this.index + "\r\n" + "size:         " + this.size + "\r\n" + "name:         " + this.name + "\r\n" + "metadata:     " + this.metadata + "\r\n" + "xml document: " + this.document + "\r\n" + "urns:         " + this.urns;
    }
}

