/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BandwidthTrackerImpl;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.HorizonCounter;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.PushProxyInterface;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.connection.MessageQueue;
import com.limegroup.gnutella.connection.PriorityMessageQueue;
import com.limegroup.gnutella.connection.SimpleMessageQueue;
import com.limegroup.gnutella.filters.SpamFilter;
import com.limegroup.gnutella.handshaking.BadHandshakeException;
import com.limegroup.gnutella.handshaking.HandshakeResponder;
import com.limegroup.gnutella.handshaking.LeafHandshakeResponder;
import com.limegroup.gnutella.handshaking.LeafHeaders;
import com.limegroup.gnutella.handshaking.NoGnutellaOkException;
import com.limegroup.gnutella.handshaking.UltrapeerHandshakeResponder;
import com.limegroup.gnutella.handshaking.UltrapeerHeaders;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.PushRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.vendor.HopsFlowVendorMessage;
import com.limegroup.gnutella.messages.vendor.MessagesSupportedVendorMessage;
import com.limegroup.gnutella.messages.vendor.PushProxyAcknowledgement;
import com.limegroup.gnutella.messages.vendor.PushProxyRequest;
import com.limegroup.gnutella.messages.vendor.TCPConnectBackVendorMessage;
import com.limegroup.gnutella.messages.vendor.UDPConnectBackVendorMessage;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.routing.PatchTableMessage;
import com.limegroup.gnutella.routing.QueryRouteTable;
import com.limegroup.gnutella.routing.ResetTableMessage;
import com.limegroup.gnutella.security.User;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.statistics.ReceivedMessageStatHandler;
import com.limegroup.gnutella.util.BandwidthThrottle;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.StringUtils;
import com.limegroup.gnutella.util.ThrottledOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class ManagedConnection
extends Connection
implements ReplyHandler,
PushProxyInterface {
    private long LEAF_QUERY_ROUTE_UPDATE_TIME = 300000L;
    private long ULTRAPEER_QUERY_ROUTE_UPDATE_TIME = 60000L;
    private static final int CONNECT_TIMEOUT = 6000;
    private static final int TOTAL_OUTGOING_MESSAGING_BANDWIDTH = 8000;
    private static final int MAX_UDP_CONNECT_BACK_ATTEMPTS = 15;
    private static final int MAX_TCP_CONNECT_BACK_ATTEMPTS = 10;
    private ConnectionManager _manager;
    private volatile SpamFilter _routeFilter = SpamFilter.newRouteFilter();
    private volatile SpamFilter _personalFilter = SpamFilter.newPersonalFilter();
    private final Object QRP_LOCK = new Object();
    private Object _outputQueueLock = new Object();
    private MessageQueue[] _outputQueue = new MessageQueue[8];
    private int _queued = 0;
    private boolean _runnerDied = false;
    int _lastPriority = 0;
    private static final int BIG_QUEUE_SIZE = 100;
    private static final int QUEUE_SIZE = 1;
    private static int BIG_QUEUE_TIME = 10000;
    static int QUEUE_TIME = 5000;
    private static final int PRIORITIES = 8;
    private static final int PRIORITY_WATCHDOG = 0;
    private static final int PRIORITY_PUSH = 1;
    private static final int PRIORITY_QUERY_REPLY = 2;
    private static final int PRIORITY_QUERY = 3;
    private static final int PRIORITY_PING_REPLY = 4;
    private static final int PRIORITY_PING = 5;
    private static final int PRIORITY_OTHER = 6;
    private static final int PRIORITY_OUR_QUERY = 7;
    private static final BandwidthThrottle _throttle = new BandwidthThrottle(8000.0f);
    private static final int REJECT_TIMEOUT = 500;
    private int _numMessagesSent;
    private int _numMessagesReceived;
    private int _numReceivedMessagesDropped;
    private int _numSentMessagesDropped;
    private int _lastReceived;
    private int _lastRecvDropped;
    private int _lastSent;
    private int _lastSentDropped;
    private long _nextQRPForwardTime;
    private BandwidthTrackerImpl _upBandwidthTracker = new BandwidthTrackerImpl();
    private BandwidthTrackerImpl _downBandwidthTracker = new BandwidthTrackerImpl();
    private boolean _isKillable = true;
    private Set _domains = null;
    private int softMaxHops = -1;
    private InetAddress pushProxyAddr = null;
    private int pushProxyPort = -1;
    private static int _numUDPConnectBackRequests = 0;
    private static int _numTCPConnectBackRequests = 0;
    private QueryRouteTable _lastQRPTableReceived;
    private QueryRouteTable _lastQRPTableSent;
    private boolean _horizonEnabled = true;
    private long numFiles = 0L;

    public ManagedConnection(String host, int port) {
        this(host, port, RouterService.isSupernode() ? new UltrapeerHeaders(host) : new LeafHeaders(host), RouterService.isSupernode() ? new UltrapeerHandshakeResponder(host) : new LeafHandshakeResponder(host));
    }

    static ManagedConnection createTestConnection(String host, int port, Properties props, HandshakeResponder responder) {
        return new ManagedConnection(host, port, props, responder);
    }

    private ManagedConnection(String host, int port, Properties props, HandshakeResponder responder) {
        super(host, port, props, responder);
        this._manager = RouterService.getConnectionManager();
    }

    ManagedConnection(Socket socket) {
        super(socket, RouterService.isSupernode() ? new UltrapeerHandshakeResponder(socket.getInetAddress().getHostAddress()) : new LeafHandshakeResponder(socket.getInetAddress().getHostAddress()));
        this._manager = RouterService.getConnectionManager();
    }

    public void initialize() throws IOException, NoGnutellaOkException, BadHandshakeException {
        super.initialize(6000);
    }

    public void resetQueryRouteTable(ResetTableMessage rtm) {
        if (this._lastQRPTableReceived == null) {
            this._lastQRPTableReceived = new QueryRouteTable(rtm.getTableSize());
        } else {
            this._lastQRPTableReceived.reset(rtm);
        }
    }

    public void patchQueryRouteTable(PatchTableMessage ptm) {
        if (this._lastQRPTableReceived == null) {
            this._lastQRPTableReceived = new QueryRouteTable();
        }
        try {
            this._lastQRPTableReceived.patch(ptm);
        }
        catch (BadPacketException badPacketException) {
            // empty catch block
        }
    }

    public boolean hitsQueryRouteTable(QueryRequest query) {
        if (this._lastQRPTableReceived == null) {
            return false;
        }
        return this._lastQRPTableReceived.contains(query);
    }

    public QueryRouteTable getQueryRouteTableReceived() {
        return this._lastQRPTableReceived;
    }

    public double getQueryRouteTablePercentFull() {
        return this._lastQRPTableReceived == null ? 0.0 : this._lastQRPTableReceived.getPercentFull();
    }

    protected OutputStream getOutputStream() throws IOException {
        return new ThrottledOutputStream(super.getOutputStream(), _throttle);
    }

    public Message receive() throws IOException, BadPacketException {
        Message m = super.receive();
        this.addReceived();
        return m;
    }

    public Message receive(int timeout) throws IOException, BadPacketException, InterruptedIOException {
        Message m = super.receive(timeout);
        this.addReceived();
        return m;
    }

    public void send(Message m) {
        this.send(m, this.calculatePriority(m));
    }

    public void originateQuery(QueryRequest query) {
        this.send(query, 7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(Message m, int priority) {
        if (!this.supportsGGEP()) {
            m = m.stripExtendedPayload();
        }
        if (this.softMaxHops > -1 && m instanceof QueryRequest && m.getHops() >= this.softMaxHops) {
            return;
        }
        this.repOk();
        Assert.that(this._outputQueue != null, "Connection not initialized");
        Object object = this._outputQueueLock;
        synchronized (object) {
            ++this._numMessagesSent;
            this._outputQueue[priority].add(m);
            int dropped = this._outputQueue[priority].resetDropped();
            this.addSentDropped(dropped);
            this._queued += 1 - dropped;
            this._lastPriority = priority;
            this._outputQueueLock.notify();
        }
        this.repOk();
    }

    public void flushSuper() throws IOException {
        super.flush();
    }

    private void addSentDropped(int dropped) {
        this._numSentMessagesDropped += dropped;
    }

    public void addReceivedDropped() {
        ++this._numReceivedMessagesDropped;
    }

    public void addReceived() {
        ++this._numMessagesReceived;
    }

    private int calculatePriority(Message m) {
        byte opcode = m.getFunc();
        switch (opcode) {
            case -128: {
                return 3;
            }
            case -127: {
                return 2;
            }
            case 1: {
                return m.getHops() == 0 && m.getTTL() <= 2 ? 0 : 4;
            }
            case 0: {
                return m.getHops() == 0 && m.getTTL() == 1 ? 0 : 5;
            }
            case 64: {
                return 1;
            }
        }
        return 6;
    }

    public void flush() throws IOException {
    }

    public void buildAndStartQueues() {
        this._outputQueue[0] = new SimpleMessageQueue(1, Integer.MAX_VALUE, 100, true);
        this._outputQueue[1] = new PriorityMessageQueue(6, BIG_QUEUE_TIME, 100);
        this._outputQueue[2] = new PriorityMessageQueue(6, BIG_QUEUE_TIME, 100);
        this._outputQueue[3] = new PriorityMessageQueue(3, QUEUE_TIME, 100);
        this._outputQueue[4] = new PriorityMessageQueue(1, QUEUE_TIME, 1);
        this._outputQueue[5] = new PriorityMessageQueue(1, QUEUE_TIME, 1);
        this._outputQueue[7] = new PriorityMessageQueue(10, BIG_QUEUE_TIME, 100);
        this._outputQueue[6] = new SimpleMessageQueue(1, Integer.MAX_VALUE, 100, false);
        new OutputRunner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpQueueStats() {
        Object object = this._outputQueueLock;
        synchronized (object) {
            for (int i = 0; i < 8; ++i) {
                System.out.println(i + " " + this._outputQueue[i].size());
            }
            System.out.println("* " + this._queued + "\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this._outputQueueLock;
        synchronized (object) {
            super.close();
            this._outputQueueLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loopToReject() {
        try {
            for (int i = 0; i < 10; ++i) {
                Message m = null;
                try {
                    m = super.receive(500);
                    if (m == null) {
                        return;
                    }
                }
                catch (BadPacketException e) {
                    return;
                }
                if (!(m instanceof PingRequest) || m.getHops() != 0 || m.getTTL() != 2) continue;
                this.handleCrawlerPing((PingRequest)m);
                return;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.close();
        }
    }

    private void handleCrawlerPing(PingRequest m) throws IOException {
        List nonLeafConnections = this._manager.getInitializedConnections2();
        this.supersendNeighborPongs(m, nonLeafConnections);
        List leafConnections = this._manager.getInitializedClientConnections2();
        this.supersendNeighborPongs(m, leafConnections);
    }

    private void supersendNeighborPongs(PingRequest m, List neighbors) throws IOException {
        Iterator iterator = neighbors.iterator();
        while (iterator.hasNext()) {
            ManagedConnection connection = (ManagedConnection)iterator.next();
            PingReply pr = connection.isSupernodeConnection() ? PingReply.createExternal(m.getGUID(), (byte)2, connection.getListeningPort(), connection.getInetAddress().getAddress(), true) : (connection.isLeafConnection() || connection.isOutgoing() ? PingReply.createExternal(m.getGUID(), (byte)2, connection.getListeningPort(), connection.getInetAddress().getAddress(), false) : PingReply.createExternal(m.getGUID(), (byte)2, 0, connection.getInetAddress().getAddress(), false));
            pr.hop();
            super.send(pr);
        }
        super.flush();
    }

    void loopForMessages() throws IOException {
        MessageRouter router = RouterService.getMessageRouter();
        while (true) {
            Message m = null;
            try {
                m = this.receive();
                if (m == null) {
                }
            }
            catch (BadPacketException e) {}
            continue;
            if (this.isSpam(m)) {
                if (!CommonUtils.isJava118()) {
                    ReceivedMessageStatHandler.TCP_FILTERED_MESSAGES.addMessage(m);
                }
                this.addReceivedDropped();
                continue;
            }
            router.handleMessage(m, this);
        }
    }

    public boolean isSpam(Message m) {
        return !this._routeFilter.allow(m);
    }

    public void countDroppedMessage() {
        ++this._numReceivedMessagesDropped;
    }

    public boolean isPersonalSpam(Message m) {
        return !this._personalFilter.allow(m);
    }

    public void setRouteFilter(SpamFilter filter) {
        this._routeFilter = filter;
    }

    public void setPersonalFilter(SpamFilter filter) {
        this._personalFilter = filter;
    }

    public Set getDomains() {
        if (this._domains == null) {
            this._domains = this.createDomainSet();
        }
        return this._domains;
    }

    private Set createDomainSet() {
        String domainsAuthenticated = this.isOutgoing() ? this.getDomainsAuthenticated() : this.getPropertyWritten("X-Domains-Authenticated");
        Set domainSet = domainsAuthenticated == null ? User.createDefaultDomainSet() : StringUtils.getSetofValues(domainsAuthenticated);
        return domainSet;
    }

    public void handlePingReply(PingReply pingReply, ReplyHandler receivingConnection) {
        this.send(pingReply);
    }

    public void handleQueryReply(QueryReply queryReply, ReplyHandler receivingConnection) {
        this.send(queryReply);
    }

    public void handlePushRequest(PushRequest pushRequest, ReplyHandler receivingConnection) {
        this.send(pushRequest);
    }

    protected void handleVendorMessage(VendorMessage vm) {
        super.handleVendorMessage(vm);
        if (vm instanceof HopsFlowVendorMessage) {
            HopsFlowVendorMessage hops = (HopsFlowVendorMessage)vm;
            this.softMaxHops = hops.getHopValue();
        } else if (vm instanceof PushProxyAcknowledgement) {
            PushProxyAcknowledgement ack = (PushProxyAcknowledgement)vm;
            if (Arrays.equals(ack.getGUID(), RouterService.getMessageRouter()._clientGUID)) {
                this.pushProxyPort = ack.getListeningPort();
                this.pushProxyAddr = ack.getListeningAddress();
            }
        } else if (vm instanceof MessagesSupportedVendorMessage) {
            if (this.remoteHostSupportsPushProxy() > -1) {
                GUID clientGUID = new GUID(RouterService.getMessageRouter()._clientGUID);
                try {
                    PushProxyRequest req = new PushProxyRequest(clientGUID);
                    this.send(req);
                }
                catch (BadPacketException never) {
                    ErrorService.error(never);
                }
            }
            if (ConnectionSettings.LOCAL_IS_PRIVATE.getValue() && (this.isLocal() || !this.isConnectBackCapable())) {
                return;
            }
            if (!UDPService.instance().canReceiveUnsolicited() && _numUDPConnectBackRequests < 15 && this.remoteHostSupportsUDPConnectBack() > -1) {
                try {
                    GUID connectBackGUID = RouterService.getUDPConnectBackGUID();
                    UDPConnectBackVendorMessage udp = new UDPConnectBackVendorMessage(RouterService.getPort(), connectBackGUID);
                    this.send(udp);
                    ++_numUDPConnectBackRequests;
                }
                catch (BadPacketException ignored) {
                    ErrorService.error(ignored);
                }
            }
            if (!RouterService.acceptedIncomingConnection() && _numTCPConnectBackRequests < 10 && this.remoteHostSupportsTCPConnectBack() > -1) {
                try {
                    TCPConnectBackVendorMessage tcp = new TCPConnectBackVendorMessage(RouterService.getPort());
                    this.send(tcp);
                    ++_numTCPConnectBackRequests;
                }
                catch (BadPacketException ignored) {
                    ErrorService.error(ignored);
                }
            }
        }
    }

    public int getNumMessagesSent() {
        return this._numMessagesSent;
    }

    public int getNumMessagesReceived() {
        return this._numMessagesReceived;
    }

    public int getNumSentMessagesDropped() {
        return this._numSentMessagesDropped;
    }

    public long getNumReceivedMessagesDropped() {
        return this._numReceivedMessagesDropped;
    }

    public synchronized float getPercentReceivedDropped() {
        int rdiff = this._numMessagesReceived - this._lastReceived;
        int ddiff = this._numReceivedMessagesDropped - this._lastRecvDropped;
        float percent = rdiff == 0 ? 0.0f : (float)ddiff / (float)rdiff * 100.0f;
        this._lastReceived = this._numMessagesReceived;
        this._lastRecvDropped = this._numReceivedMessagesDropped;
        return percent;
    }

    public synchronized float getPercentSentDropped() {
        int rdiff = this._numMessagesSent - this._lastSent;
        int ddiff = this._numSentMessagesDropped - this._lastSentDropped;
        float percent = rdiff == 0 ? 0.0f : (float)ddiff / (float)rdiff * 100.0f;
        this._lastSent = this._numMessagesSent;
        this._lastSentDropped = this._numSentMessagesDropped;
        return percent;
    }

    public void measureBandwidth() {
        this._upBandwidthTracker.measureBandwidth(ByteOrder.long2int(this.getBytesSent()));
        this._downBandwidthTracker.measureBandwidth(ByteOrder.long2int(this.getBytesReceived()));
    }

    public float getMeasuredUpstreamBandwidth() {
        float retValue = 0.0f;
        try {
            retValue = this._upBandwidthTracker.getMeasuredBandwidth();
        }
        catch (InsufficientDataException ide) {
            return 0.0f;
        }
        return retValue;
    }

    public float getMeasuredDownstreamBandwidth() {
        float retValue = 0.0f;
        try {
            retValue = this._downBandwidthTracker.getMeasuredBandwidth();
        }
        catch (InsufficientDataException ide) {
            return 0.0f;
        }
        return retValue;
    }

    public synchronized void setHorizonEnabled(boolean enable) {
        this._horizonEnabled = enable;
    }

    public synchronized void updateHorizonStats(PingReply pingReply) {
        if (!this._horizonEnabled) {
            return;
        }
        HorizonCounter.instance().addPong(pingReply);
        this.numFiles += pingReply.getFiles();
    }

    public long getNumFiles() {
        return this.numFiles;
    }

    public long getNextQRPForwardTime() {
        return this._nextQRPForwardTime;
    }

    public void incrementNextQRPForwardTime(long curTime) {
        this._nextQRPForwardTime = this.isLeafConnection() ? curTime + this.LEAF_QUERY_ROUTE_UPDATE_TIME : curTime + this.ULTRAPEER_QUERY_ROUTE_UPDATE_TIME;
    }

    public boolean isKillable() {
        return this._isKillable;
    }

    public QueryRouteTable getQueryRouteTableSent() {
        return this._lastQRPTableSent;
    }

    public void setQueryRouteTableSent(QueryRouteTable qrt) {
        this._lastQRPTableSent = qrt;
    }

    public int getPushProxyPort() {
        return this.pushProxyPort;
    }

    public InetAddress getPushProxyAddress() {
        return this.pushProxyAddr;
    }

    private final void repOk() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopOutputRunner() {
        Object object = this._outputQueueLock;
        synchronized (object) {
            this._closed = true;
            this._outputQueueLock.notify();
        }
        while (!this._runnerDied) {
            Thread.yield();
        }
        this._runnerDied = false;
        this._closed = false;
    }

    void startOutputRunner() {
        new OutputRunner();
    }

    boolean runnerDied() {
        return this._runnerDied;
    }

    public Object getQRPLock() {
        return this.QRP_LOCK;
    }

    private class OutputRunner
    extends Thread {
        public OutputRunner() {
            this.setName("OutputRunner");
            this.setDaemon(true);
            this.start();
        }

        public void run() {
            try {
                while (true) {
                    ManagedConnection.this.repOk();
                    this.waitForQueued();
                    this.sendQueued();
                    ManagedConnection.this.repOk();
                }
            }
            catch (IOException e) {
                ManagedConnection.this._runnerDied = true;
            }
            catch (Throwable t) {
                ManagedConnection.this._runnerDied = true;
                ErrorService.error(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void waitForQueued() throws IOException {
            Object object = ManagedConnection.this._outputQueueLock;
            synchronized (object) {
                while (ManagedConnection.this.isOpen() && ManagedConnection.this._queued == 0) {
                    try {
                        ManagedConnection.this._outputQueueLock.wait();
                    }
                    catch (InterruptedException e) {
                        Assert.that(false, "OutputRunner Interrupted");
                    }
                }
            }
            if (!ManagedConnection.this.isOpen()) {
                throw Connection.CONNECTION_CLOSED;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void sendQueued() throws IOException {
            boolean emptied;
            int start;
            int i = start = ManagedConnection.this._lastPriority;
            block3: do {
                MessageQueue queue = ManagedConnection.this._outputQueue[i];
                queue.resetCycle();
                emptied = false;
                while (true) {
                    Message m = null;
                    Object object = ManagedConnection.this._outputQueueLock;
                    synchronized (object) {
                        m = queue.removeNext();
                        int dropped = queue.resetDropped();
                        ManagedConnection.this.addSentDropped(dropped);
                        ManagedConnection.this._queued -= (m == null ? 0 : 1) + dropped;
                        if (ManagedConnection.this._queued == 0) {
                            emptied = true;
                        }
                        if (m == null) {
                            continue block3;
                        }
                    }
                    ManagedConnection.super.send(m);
                }
            } while (!emptied && (i = (i + 1) % 8) != start);
            ManagedConnection.super.flush();
        }
    }
}

