/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.AlternateLocation;
import com.limegroup.gnutella.AlternateLocationCollection;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.downloader.Interval;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.downloader.VerifyingFile;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Set;

public class IncompleteFileDesc
extends FileDesc
implements HTTPHeaderValue {
    private static final int MIN_CHUNK_SIZE = 102400;
    private VerifyingFile _verifyingFile;
    private final String _name;
    private final int _size;

    public IncompleteFileDesc(File file, Set urns, int index, String completedName, int completedSize, VerifyingFile vf) {
        super(file, urns, index);
        this._name = completedName;
        this._size = completedSize;
        this._verifyingFile = vf;
    }

    public long getSize() {
        return this._size;
    }

    public String getName() {
        return this._name;
    }

    public InputStream createInputStream() throws FileNotFoundException {
        if (this.getFile().length() == 0L) {
            throw new FileNotFoundException();
        }
        return new FileInputStream(this.getFile());
    }

    public boolean addAlternateLocation(AlternateLocation al) {
        ManagedDownloader md;
        boolean ret = super.addAlternateLocation(al);
        if (ret && (md = this._verifyingFile.getManagedDownloader()) != null) {
            md.addAlternateLocation(al, (int)this.getSize());
        }
        return ret;
    }

    public int addAlternateLocationCollection(AlternateLocationCollection alc) {
        ManagedDownloader md = this._verifyingFile.getManagedDownloader();
        if (md == null) {
            return super.addAlternateLocationCollection(alc);
        }
        int added = 0;
        Iterator iter = alc.values().iterator();
        while (iter.hasNext()) {
            AlternateLocation al = (AlternateLocation)iter.next();
            if (!super.addAlternateLocation(al)) continue;
            md.addAlternateLocation(al, (int)this.getSize());
            ++added;
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAvailableRanges() {
        StringBuffer ret = new StringBuffer("bytes");
        boolean added = false;
        VerifyingFile verifyingFile = this._verifyingFile;
        synchronized (verifyingFile) {
            Iterator iter = this._verifyingFile.getBlocks();
            while (iter.hasNext()) {
                Interval interval = (Interval)iter.next();
                if (interval.high - interval.low + 1 < 102400) continue;
                added = true;
                ret.append(" " + interval.low + "-" + (interval.high - 1) + ",");
            }
        }
        if (added) {
            ret.setLength(ret.length() - 1);
        }
        return ret.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRangeSatisfiable(int low, int high) {
        VerifyingFile verifyingFile = this._verifyingFile;
        synchronized (verifyingFile) {
            Iterator iter = this._verifyingFile.getBlocks();
            while (iter.hasNext()) {
                Interval interval = (Interval)iter.next();
                if (low < interval.low || high > interval.high) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isRangeSatisfiable(Interval range) {
        return this.isRangeSatisfiable(range.low, range.high);
    }

    public String httpStringValue() {
        return this.getAvailableRanges();
    }

    public String toString() {
        return "IncompleteFileDesc:\r\nname:     " + this._name + "\r\n" + "index:    " + this.getIndex() + "\r\n";
    }
}

