/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PushRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.search.SearchResultHandler;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Set;

public final class ForMeReplyHandler
implements ReplyHandler {
    private static final ReplyHandler INSTANCE = new ForMeReplyHandler();

    public static ReplyHandler instance() {
        return INSTANCE;
    }

    private ForMeReplyHandler() {
    }

    public void handlePingReply(PingReply pingReply, ReplyHandler handler) {
        if (pingReply.getHops() <= 1 && handler.getNumMessagesReceived() <= 2 && !handler.isOutgoing() && handler.isKillable() && pingReply.getFiles() < (long)SharingSettings.FREELOADER_FILES.getValue() && (int)(Math.random() * 100.0) > SharingSettings.FREELOADER_ALLOWED.getValue() && handler instanceof ManagedConnection && handler.isStable()) {
            ConnectionManager cm = RouterService.getConnectionManager();
            cm.remove((ManagedConnection)handler);
        }
    }

    public void handleQueryReply(QueryReply reply, ReplyHandler handler) {
        if (handler.isPersonalSpam(reply)) {
            return;
        }
        try {
            if (reply.isReplyToMulticastQuery()) {
                if (reply.isTCP()) {
                    return;
                }
                if (reply.getHops() != 1 || reply.getTTL() != 0) {
                    return;
                }
            }
        }
        catch (BadPacketException bpe) {
            return;
        }
        SearchResultHandler resultHandler = RouterService.getSearchResultHandler();
        resultHandler.handleQueryReply(reply);
        DownloadManager dm = RouterService.getDownloadManager();
        dm.handleQueryReply(reply);
    }

    public void handlePushRequest(PushRequest pushRequest, ReplyHandler handler) {
        if (handler.isPersonalSpam(pushRequest)) {
            return;
        }
        byte[] ip = pushRequest.getIP();
        StringBuffer buf = new StringBuffer();
        buf.append(ByteOrder.ubyte2int(ip[0]) + ".");
        buf.append(ByteOrder.ubyte2int(ip[1]) + ".");
        buf.append(ByteOrder.ubyte2int(ip[2]) + ".");
        buf.append(ByteOrder.ubyte2int(ip[3]) + "");
        String h = buf.toString();
        if (RouterService.getAcceptor().isBannedIP(h)) {
            return;
        }
        int port = pushRequest.getPort();
        if (!NetworkUtils.isValidPort(port)) {
            return;
        }
        int index = (int)pushRequest.getIndex();
        FileManager fm = RouterService.getFileManager();
        if (!fm.isValidIndex(index)) {
            return;
        }
        String req_guid_hexstring = new GUID(pushRequest.getClientGUID()).toString();
        FileDesc desc = fm.get(index);
        if (desc == null) {
            return;
        }
        String file = desc.getName();
        RouterService.getPushManager().acceptPushUpload(file, h, port, index, req_guid_hexstring, pushRequest.isMulticast());
    }

    public boolean isOpen() {
        return true;
    }

    public int getNumMessagesReceived() {
        return 0;
    }

    public void countDroppedMessage() {
    }

    public boolean isSupernodeClientConnection() {
        return false;
    }

    public Set getDomains() {
        return DataUtils.EMPTY_SET;
    }

    public boolean isPersonalSpam(Message m) {
        return false;
    }

    public void updateHorizonStats(PingReply pingReply) {
    }

    public boolean isOutgoing() {
        return false;
    }

    public boolean isKillable() {
        return false;
    }

    public boolean isLeafConnection() {
        return !RouterService.isSupernode();
    }

    public boolean isHighDegreeConnection() {
        return false;
    }

    public boolean isUltrapeerQueryRoutingConnection() {
        return false;
    }

    public boolean isGoodUltrapeer() {
        return false;
    }

    public boolean isGoodLeaf() {
        return false;
    }

    public boolean supportsPongCaching() {
        return true;
    }

    public boolean allowNewPings() {
        return true;
    }

    public InetAddress getInetAddress() {
        try {
            return InetAddress.getByName(NetworkUtils.ip2string(RouterService.getAddress()));
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public boolean isStable() {
        return true;
    }
}

