/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.bitzi.util.Base32;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BandwidthTracker;
import com.limegroup.gnutella.BrowseHostHandler;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.PushProxyInterface;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.AlreadyDownloadingException;
import com.limegroup.gnutella.downloader.AutoDownloadDetails;
import com.limegroup.gnutella.downloader.CantResumeException;
import com.limegroup.gnutella.downloader.FileExistsException;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.downloader.MagnetDownloader;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.downloader.RequeryDownloader;
import com.limegroup.gnutella.downloader.ResumeDownloader;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.PushRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.DownloadSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.URLDecoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class DownloadManager
implements BandwidthTracker {
    private int SNAPSHOT_CHECKPOINT_TIME = 30000;
    private ActivityCallback callback;
    private MessageRouter router;
    private FileManager fileManager;
    private IncompleteFileManager incompleteFileManager = new IncompleteFileManager();
    private List active = new LinkedList();
    private List waiting = new LinkedList();
    public static long TIME_BETWEEN_REQUERIES = 2700000L;
    private long lastRequeryTime = 0L;
    private List querySentMDs = new ArrayList();
    private int numMeasures = 0;
    private float averageBandwidth = 0.0f;
    private final boolean debugOn = false;

    public List getActiveDownloads() {
        ArrayList clone = new ArrayList();
        clone.addAll(this.active);
        return clone;
    }

    public List getWaitingDownloads() {
        ArrayList clone = new ArrayList();
        clone.addAll(this.waiting);
        return clone;
    }

    public void initialize() {
        this.callback = RouterService.getCallback();
        this.router = RouterService.getMessageRouter();
        this.fileManager = RouterService.getFileManager();
    }

    public void postGuiInit() {
        File real = SharingSettings.DOWNLOAD_SNAPSHOT_FILE.getValue();
        File backup = SharingSettings.DOWNLOAD_SNAPSHOT_BACKUP_FILE.getValue();
        if (!this.readSnapshot(real) && this.readSnapshot(backup)) {
            this.copyBackupToReal();
        }
        Runnable checkpointer = new Runnable(){

            public void run() {
                try {
                    if (DownloadManager.this.downloadsInProgress() > 0 && !DownloadManager.this.writeSnapshot()) {
                        DownloadManager.this.copyBackupToReal();
                    }
                }
                catch (Throwable t) {
                    ErrorService.error(t);
                }
            }
        };
        RouterService.schedule(checkpointer, this.SNAPSHOT_CHECKPOINT_TIME, this.SNAPSHOT_CHECKPOINT_TIME);
    }

    private synchronized void copyBackupToReal() {
        File real = SharingSettings.DOWNLOAD_SNAPSHOT_FILE.getValue();
        File backup = SharingSettings.DOWNLOAD_SNAPSHOT_BACKUP_FILE.getValue();
        real.delete();
        CommonUtils.copy(backup, real);
    }

    public IncompleteFileManager getIncompleteFileManager() {
        return this.incompleteFileManager;
    }

    public synchronized int downloadsInProgress() {
        return this.active.size() + this.waiting.size();
    }

    public synchronized int getNumIndividualDownloaders() {
        int ret = 0;
        Iterator iter = this.active.iterator();
        while (iter.hasNext()) {
            ManagedDownloader md = (ManagedDownloader)iter.next();
            ret += md.getNumDownloaders();
        }
        return ret;
    }

    public synchronized int getNumActiveDownloads() {
        return this.active.size();
    }

    public synchronized int getNumWaitingDownloads() {
        return this.waiting.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean writeSnapshot() {
        ArrayList buf = new ArrayList();
        buf.addAll(this.active);
        buf.addAll(this.waiting);
        File outFile = SharingSettings.DOWNLOAD_SNAPSHOT_FILE.getValue();
        outFile.renameTo(SharingSettings.DOWNLOAD_SNAPSHOT_BACKUP_FILE.getValue());
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(SharingSettings.DOWNLOAD_SNAPSHOT_FILE.getValue()));
            out.writeObject(buf);
            IncompleteFileManager incompleteFileManager = this.incompleteFileManager;
            synchronized (incompleteFileManager) {
                out.writeObject(this.incompleteFileManager);
            }
            out.flush();
            out.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public synchronized boolean readSnapshot(File file) {
        System.err.println("DownloadManager reading file: " + file);
        List buf = null;
        try {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(file));
            buf = (List)in.readObject();
            this.incompleteFileManager = (IncompleteFileManager)in.readObject();
        }
        catch (IOException e) {
            return false;
        }
        catch (ClassCastException e) {
            return false;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        if (this.incompleteFileManager.purge(true)) {
            this.writeSnapshot();
        }
        try {
            Iterator iter = buf.iterator();
            while (iter.hasNext()) {
                ManagedDownloader downloader = (ManagedDownloader)iter.next();
                this.waiting.add(downloader);
                downloader.initialize(this, this.fileManager, this.callback, true);
                this.callback.addDownload(downloader);
            }
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public synchronized Downloader download(RemoteFileDesc[] files, boolean overwrite) throws FileExistsException, AlreadyDownloadingException, FileNotFoundException {
        String filename;
        File downloadDir;
        File completeFile;
        String conflict = this.conflicts(files, null);
        if (conflict != null) {
            throw new AlreadyDownloadingException(conflict);
        }
        if (!overwrite && (completeFile = new File(downloadDir = SharingSettings.getSaveDirectory(), filename = files[0].getFileName())).exists()) {
            throw new FileExistsException(filename);
        }
        this.incompleteFileManager.purge(false);
        ManagedDownloader downloader = new ManagedDownloader(files, this.incompleteFileManager);
        this.startDownload(downloader, false);
        return downloader;
    }

    public synchronized Downloader download(URN urn, String textQuery, String filename, String[] defaultURL) throws IllegalArgumentException, AlreadyDownloadingException {
        if (textQuery == null && urn == null) {
            throw new IllegalArgumentException("Need something for requeries");
        }
        MagnetDownloader downloader = new MagnetDownloader(this, this.fileManager, this.incompleteFileManager, this.callback, urn, textQuery, filename, defaultURL);
        this.startDownload(downloader, false);
        return downloader;
    }

    public synchronized Downloader download(File incompleteFile) throws AlreadyDownloadingException, CantResumeException {
        ManagedDownloader md;
        Iterator iter = this.active.iterator();
        while (iter.hasNext()) {
            md = (ManagedDownloader)iter.next();
            if (!md.conflicts(incompleteFile)) continue;
            throw new AlreadyDownloadingException(md.getFileName());
        }
        iter = this.waiting.iterator();
        while (iter.hasNext()) {
            md = (ManagedDownloader)iter.next();
            if (!md.conflicts(incompleteFile)) continue;
            throw new AlreadyDownloadingException(md.getFileName());
        }
        this.incompleteFileManager.purge(false);
        ResumeDownloader downloader = null;
        try {
            String name = IncompleteFileManager.getCompletedName(incompleteFile);
            int size = ByteOrder.long2int(IncompleteFileManager.getCompletedSize(incompleteFile));
            downloader = new ResumeDownloader(this.incompleteFileManager, incompleteFile, name, size);
        }
        catch (IllegalArgumentException e) {
            throw new CantResumeException(incompleteFile.getName());
        }
        this.startDownload(downloader, false);
        return downloader;
    }

    public synchronized Downloader download(String query, String richQuery, byte[] guid, MediaType type) throws AlreadyDownloadingException {
        AutoDownloadDetails add = new AutoDownloadDetails(query, richQuery, guid, type);
        if (this.requeryConflicts(add)) {
            throw new AlreadyDownloadingException(query);
        }
        this.incompleteFileManager.purge(false);
        RequeryDownloader downloader = new RequeryDownloader(this.incompleteFileManager, add);
        this.startDownload(downloader, false);
        return downloader;
    }

    private void startDownload(ManagedDownloader md, boolean deserialized) {
        md.initialize(this, this.fileManager, this.callback, deserialized);
        this.waiting.add(md);
        this.callback.addDownload(md);
        this.writeSnapshot();
    }

    public synchronized String conflicts(RemoteFileDesc[] files, ManagedDownloader dloader) {
        for (int i = 0; i < files.length; ++i) {
            ManagedDownloader md;
            Iterator iter = this.active.iterator();
            while (iter.hasNext()) {
                md = (ManagedDownloader)iter.next();
                if (dloader != null && md == dloader || !md.conflicts(files[i])) continue;
                return files[i].getFileName();
            }
            iter = this.waiting.iterator();
            while (iter.hasNext()) {
                md = (ManagedDownloader)iter.next();
                if (dloader != null && md == dloader || !md.conflicts(files[i])) continue;
                return files[i].getFileName();
            }
        }
        return null;
    }

    private synchronized boolean requeryConflicts(AutoDownloadDetails add) {
        RequeryDownloader rd;
        ManagedDownloader md;
        boolean retVal = false;
        Iterator iter = this.active.iterator();
        while (iter.hasNext() && !retVal) {
            md = (ManagedDownloader)iter.next();
            if (!(md instanceof RequeryDownloader)) continue;
            rd = (RequeryDownloader)md;
            retVal = rd.conflicts(add);
        }
        iter = this.waiting.iterator();
        while (iter.hasNext() && !retVal) {
            md = (ManagedDownloader)iter.next();
            if (!(md instanceof RequeryDownloader)) continue;
            rd = (RequeryDownloader)md;
            retVal = rd.conflicts(add);
        }
        return retVal;
    }

    public void handleQueryReply(QueryReply qr) {
        if (qr.calculateQualityOfService(!RouterService.acceptedIncomingConnection()) < 1) {
            return;
        }
        RemoteFileDesc[] rfds = null;
        try {
            rfds = qr.toRemoteFileDescArray();
        }
        catch (BadPacketException bpe) {
            this.debug(bpe);
            rfds = new RemoteFileDesc[]{};
        }
        this.handleManagedDownloaderAdditions(rfds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleManagedDownloaderAdditions(RemoteFileDesc[] rfds) {
        if (rfds.length == 0) {
            return;
        }
        ArrayList downloaders = new ArrayList();
        DownloadManager downloadManager = this;
        synchronized (downloadManager) {
            downloaders.addAll(this.active);
            downloaders.addAll(this.waiting);
        }
        for (int i = 0; i < rfds.length; ++i) {
            ManagedDownloader currD;
            for (int j = 0; j < downloaders.size() && !(currD = (ManagedDownloader)downloaders.get(j)).addDownload(rfds[i], true); ++j) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptDownload(Socket socket) {
        Thread.currentThread().setName("PushDownloadThread");
        try {
            GIVLine line = DownloadManager.parseGIV(socket);
            String file = line.file;
            int index = line.index;
            byte[] clientGUID = line.clientGUID;
            DownloadManager downloadManager = this;
            synchronized (downloadManager) {
                ManagedDownloader md;
                if (BrowseHostHandler.handlePush(index, new GUID(clientGUID), socket)) {
                    return;
                }
                Iterator iter = this.active.iterator();
                while (iter.hasNext()) {
                    md = (ManagedDownloader)iter.next();
                    if (!md.acceptDownload(file, socket, index, clientGUID)) continue;
                    return;
                }
                iter = this.waiting.iterator();
                while (iter.hasNext()) {
                    md = (ManagedDownloader)iter.next();
                    if (!md.acceptDownload(file, socket, index, clientGUID)) continue;
                    return;
                }
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean hasFreeSlot() {
        return this.active.size() < DownloadSettings.MAX_SIM_DOWNLOAD.getValue();
    }

    public synchronized void waitForSlot(ManagedDownloader downloader) throws InterruptedException {
        while (!this.hasFreeSlot()) {
            this.wait();
        }
        this.waiting.remove(downloader);
        this.active.add(downloader);
    }

    public synchronized void yieldSlot(ManagedDownloader downloader) {
        Assert.that(downloader != null, "Null downloader");
        Assert.that(this.active != null, "Null active");
        Assert.that(this.waiting != null, "Null waiting");
        this.active.remove(downloader);
        this.waiting.add(downloader);
        this.notify();
    }

    public synchronized void remove(ManagedDownloader downloader, boolean success) {
        this.active.remove(downloader);
        this.waiting.remove(downloader);
        this.querySentMDs.remove(downloader);
        downloader.finish();
        this.notify();
        this.callback.removeDownload(downloader);
        this.writeSnapshot();
        if (this.active.isEmpty() && this.waiting.isEmpty()) {
            this.callback.downloadsComplete();
        }
    }

    public synchronized boolean sendQuery(ManagedDownloader requerier, QueryRequest query) {
        this.debug("DM.sendQuery():" + query.getQuery());
        Assert.that(this.waiting.contains(requerier), "Unknown or non-waiting MD trying to send requery.");
        boolean isRequery = GUID.isLimeRequeryGUID(query.getGUID());
        long elapsed = System.currentTimeMillis() - this.lastRequeryTime;
        if (isRequery && elapsed <= TIME_BETWEEN_REQUERIES) {
            return false;
        }
        if (this.querySentMDs.size() >= this.waiting.size()) {
            this.debug("DM.sendQuery(): reseting query sent queue");
            this.querySentMDs.clear();
        }
        if (this.querySentMDs.contains(requerier)) {
            this.debug("DM.sendQuery(): out of turn:" + query.getQuery());
            return false;
        }
        this.debug("DM.sendQuery(): requery allowed:" + query.getQuery());
        this.querySentMDs.add(requerier);
        this.lastRequeryTime = System.currentTimeMillis();
        this.router.sendDynamicQuery(query);
        return true;
    }

    public boolean sendPush(RemoteFileDesc file) {
        this.debug("DM.sendPush(): entered.");
        if (file.isReplyToMulticast()) {
            PushRequest pr = new PushRequest(GUID.makeGuid(), 1, file.getClientGUID(), file.getIndex(), RouterService.getNonForcedAddress(), RouterService.getNonForcedPort());
            this.router.sendMulticastPushRequest(pr);
            return true;
        }
        Set proxies = file.getPushProxies();
        if (!proxies.isEmpty()) {
            this.debug("DM.sendPush(): proxy info exists.");
            boolean requestSuccessful = false;
            String requestString = "/gnutella/push-proxy?ServerID=" + Base32.encode(file.getClientGUID());
            String nodeString = "X-Node:";
            String nodeValue = NetworkUtils.ip2string(RouterService.getAddress()) + ":" + RouterService.getPort();
            Iterator iter = proxies.iterator();
            while (iter.hasNext() && !requestSuccessful) {
                PushProxyInterface ppi = (PushProxyInterface)iter.next();
                try {
                    String ip = ppi.getPushProxyAddress().getHostName();
                    int port = ppi.getPushProxyPort();
                    URL url = new URL("http", ip, port, requestString);
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.setUseCaches(false);
                    connection.setRequestProperty("X-Node:", nodeValue);
                    requestSuccessful = connection.getResponseCode() == 202;
                    connection.disconnect();
                }
                catch (MalformedURLException url) {
                    ErrorService.error(url);
                }
                catch (IOException ioe) {}
            }
            if (requestSuccessful) {
                return requestSuccessful;
            }
        }
        PushRequest pr = new PushRequest(GUID.makeGuid(), ConnectionSettings.TTL.getValue(), file.getClientGUID(), file.getIndex(), RouterService.getAddress(), RouterService.getPort());
        try {
            this.router.sendPushRequest(pr);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private static GIVLine parseGIV(Socket s) throws IOException {
        InputStream istream = null;
        try {
            istream = s.getInputStream();
        }
        catch (Exception e) {
            throw new IOException();
        }
        ByteReader br = new ByteReader(istream);
        String command = br.readLine();
        if (command == null) {
            throw new IOException();
        }
        String next = br.readLine();
        if (next == null || !next.equals("")) {
            throw new IOException();
        }
        try {
            int i = command.indexOf(":");
            int index = Integer.parseInt(command.substring(0, i));
            int j = command.indexOf("/", i);
            byte[] guid = GUID.fromHexString(command.substring(i + 1, j));
            String filename = URLDecoder.decode(command.substring(j + 1));
            return new GIVLine(filename, index, guid);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IOException();
        }
        catch (NumberFormatException e) {
            throw new IOException();
        }
        catch (IllegalArgumentException e) {
            throw new IOException();
        }
    }

    public synchronized void measureBandwidth() {
        float currentTotal = 0.0f;
        boolean c = false;
        Iterator iter = this.active.iterator();
        while (iter.hasNext()) {
            c = true;
            BandwidthTracker bt = (BandwidthTracker)iter.next();
            bt.measureBandwidth();
            currentTotal += bt.getAverageBandwidth();
        }
        if (c) {
            this.averageBandwidth = (this.averageBandwidth * (float)this.numMeasures + currentTotal) / (float)(++this.numMeasures);
        }
    }

    public synchronized float getMeasuredBandwidth() {
        float sum = 0.0f;
        Iterator iter = this.active.iterator();
        while (iter.hasNext()) {
            BandwidthTracker bt = (BandwidthTracker)iter.next();
            float curr = 0.0f;
            try {
                curr = bt.getMeasuredBandwidth();
            }
            catch (InsufficientDataException ide) {
                curr = 0.0f;
            }
            sum += curr;
        }
        return sum;
    }

    public synchronized float getAverageBandwidth() {
        return this.averageBandwidth;
    }

    private final void debug(String out) {
    }

    private final void debug(Exception e) {
    }

    private static final class GIVLine {
        final String file;
        final int index;
        final byte[] clientGUID;

        GIVLine(String file, int index, byte[] clientGUID) {
            this.file = file;
            this.index = index;
            this.clientGUID = clientGUID;
        }
    }
}

