/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.HostCatcher;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.QueryUnicaster;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SupernodeAssigner;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.handshaking.BadHandshakeException;
import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.handshaking.NoGnutellaOkException;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.security.Authenticator;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.UltrapeerSettings;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class ConnectionManager {
    public static final int ULTRAPEER_CONNECTIONS = ConnectionSettings.NUM_CONNECTIONS.getValue();
    public static final int PREFERRED_CONNECTIONS_FOR_LEAF = 4;
    public static final int RESERVED_GOOD_LEAF_CONNECTIONS = UltrapeerSettings.MAX_LEAVES.getValue() - 15;
    public static final int ALLOWED_BAD_LEAF_CONNECTIONS = 2;
    private static final int MAX_ULTRAPEER_ENDPOINTS = 10;
    private static final int MAX_LEAVES = UltrapeerSettings.MAX_LEAVES.getValue();
    private HostCatcher _catcher;
    private volatile int _keepAlive = 0;
    private final List _fetchers = new ArrayList();
    private final List _initializingFetchedConnections = new ArrayList();
    private volatile List _connections = new ArrayList();
    private volatile List _initializedConnections = new ArrayList();
    private volatile List _initializedClientConnections = new ArrayList();
    private volatile int _shieldedConnections = 0;
    private final Authenticator _authenticator;
    private volatile int _leafTries;
    private volatile int _demotionLimit = 0;

    public ConnectionManager(Authenticator authenticator) {
        this._authenticator = authenticator;
    }

    public void initialize() {
        this._catcher = RouterService.getHostCatcher();
    }

    public ManagedConnection createConnectionBlocking(String hostname, int portnum) throws IOException {
        ManagedConnection c = new ManagedConnection(hostname, portnum);
        this.initializeExternallyGeneratedConnection(c);
        Thread conn = new Thread((Runnable)new OutgoingConnector(c, false), "OutgoingConnector");
        conn.setDaemon(true);
        conn.start();
        return c;
    }

    public void createConnectionAsynchronously(String hostname, int portnum) {
        OutgoingConnector outgoingRunner = new OutgoingConnector(new ManagedConnection(hostname, portnum), true);
        Thread outgoingConnectionRunner = new Thread((Runnable)outgoingRunner, "OutgoingConnectionThread");
        outgoingConnectionRunner.setDaemon(true);
        outgoingConnectionRunner.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acceptConnection(Socket socket) {
        Thread.currentThread().setName("IncommingConnectionThread");
        ManagedConnection connection = new ManagedConnection(socket);
        try {
            this.initializeExternallyGeneratedConnection(connection);
        }
        catch (IOException e) {
            connection.close();
            return;
        }
        try {
            this.startConnection(connection);
        }
        catch (IOException e) {
        }
        catch (Throwable e) {
            ErrorService.error(e);
        }
        finally {
            if (connection.isClientSupernodeConnection()) {
                this.lostShieldedClientSupernodeConnection();
            }
        }
    }

    public synchronized void remove(ManagedConnection mc) {
        if (!ConnectionSettings.REMOVE_ENABLED.getValue()) {
            return;
        }
        this.removeInternal(mc);
        this.adjustConnectionFetchers();
    }

    public int getKeepAlive() {
        return this._keepAlive;
    }

    public synchronized void setKeepAlive(int newKeep) {
        System.err.println("ConnectionManager setKeepAlive: " + newKeep);
        this._keepAlive = newKeep;
        if (this._catcher != null) {
            this.adjustConnectionFetchers();
        }
    }

    public synchronized void ensureConnectionsForSupernode() {
        if (this.getNumInitializedClientConnections() > 0 && this._keepAlive < ULTRAPEER_CONNECTIONS) {
            this.setKeepAlive(ULTRAPEER_CONNECTIONS);
        }
    }

    public boolean isSupernode() {
        return UltrapeerSettings.EVER_ULTRAPEER_CAPABLE.getValue() && !this.isShieldedLeaf();
    }

    public boolean isShieldedLeaf() {
        return this._shieldedConnections != 0;
    }

    public boolean hasSupernodeClientConnection() {
        return this.getNumInitializedClientConnections() > 0;
    }

    public boolean hasFreeSlots() {
        return this.isSupernode() && (this.hasFreeUltrapeerSlots() || this.hasFreeLeafSlots());
    }

    private boolean hasFreeUltrapeerSlots() {
        return this.getNumFreeNonLeafSlots() > 0;
    }

    private boolean hasFreeLeafSlots() {
        return this.getNumFreeLeafSlots() > 0;
    }

    private boolean isConnectedTo(Endpoint host) {
        String hostName = host.getHostname();
        List connections = this.getConnections();
        Iterator iter = connections.iterator();
        while (iter.hasNext()) {
            ManagedConnection mc = (ManagedConnection)iter.next();
            if (!mc.getIPString().equals(hostName)) continue;
            return true;
        }
        return false;
    }

    public int getNumConnections() {
        return this._connections.size();
    }

    public int getNumInitializedConnections() {
        return this._initializedConnections.size();
    }

    public int getNumInitializedClientConnections() {
        return this._initializedClientConnections.size();
    }

    public int getNumClientSupernodeConnections() {
        return this._shieldedConnections;
    }

    public synchronized int getNumUltrapeerConnections() {
        return this.ultrapeerToUltrapeerConnections();
    }

    public synchronized int getNumOldConnections() {
        return this.oldConnections();
    }

    public int getNumFreeLeafSlots() {
        if (this.isSupernode()) {
            return MAX_LEAVES - this.getNumInitializedClientConnections();
        }
        return 0;
    }

    int getNumFreeNonLeafSlots() {
        return ULTRAPEER_CONNECTIONS - this.getNumInitializedConnections();
    }

    public boolean isConnected() {
        return this._initializedClientConnections.size() > 0 || this._initializedConnections.size() > 0;
    }

    public void measureBandwidth() {
        List connections = this.getInitializedConnections();
        Iterator iter = connections.iterator();
        while (iter.hasNext()) {
            ManagedConnection mc = (ManagedConnection)iter.next();
            mc.measureBandwidth();
        }
    }

    public float getMeasuredUpstreamBandwidth() {
        float sum = 0.0f;
        List connections = this.getInitializedConnections();
        Iterator iter = connections.iterator();
        while (iter.hasNext()) {
            ManagedConnection mc = (ManagedConnection)iter.next();
            sum += mc.getMeasuredUpstreamBandwidth();
        }
        return sum;
    }

    public float getMeasuredDownstreamBandwidth() {
        float sum = 0.0f;
        List connections = this.getInitializedConnections();
        Iterator iter = connections.iterator();
        while (iter.hasNext()) {
            ManagedConnection mc = (ManagedConnection)iter.next();
            sum += mc.getMeasuredDownstreamBandwidth();
        }
        return sum;
    }

    private boolean allowConnection(ManagedConnection c) {
        if (!c.receivedHeaders()) {
            return false;
        }
        return this.allowConnection(c.headers(), false);
    }

    public boolean allowConnectionAsLeaf(HandshakeResponse hr) {
        return this.allowConnection(hr, true);
    }

    public boolean allowConnection(HandshakeResponse hr) {
        return this.allowConnection(hr, false);
    }

    public boolean allowAnyConnection() {
        if (this.isShieldedLeaf()) {
            return false;
        }
        return this.getNumInitializedConnections() < this._keepAlive || this.isSupernode() && this.getNumInitializedClientConnections() < MAX_LEAVES;
    }

    public boolean allowConnection(HandshakeResponse hr, boolean leaf) {
        if (!ConnectionSettings.PREFERENCING_ACTIVE.getValue()) {
            return true;
        }
        if (!ConnectionSettings.IGNORE_KEEP_ALIVE.getValue() && this._keepAlive <= 0) {
            return false;
        }
        if (RouterService.isShieldedLeaf()) {
            return false;
        }
        if (hr.isLeaf() || leaf) {
            if (hr.isGoodLeaf()) {
                return this.getNumInitializedClientConnections() < UltrapeerSettings.MAX_LEAVES.getValue();
            }
            return this.getNumInitializedClientConnections() < (ConnectionManager.trustedVendor(hr.getUserAgent()) ? UltrapeerSettings.MAX_LEAVES.getValue() - RESERVED_GOOD_LEAF_CONNECTIONS : 2);
        }
        if (hr.isUltrapeer()) {
            return this.hasFreeUltrapeerSlots();
        }
        return false;
    }

    private static boolean trustedVendor(String userAgentHeader) {
        boolean result;
        if (userAgentHeader == null) {
            return false;
        }
        System.err.println("filter_unf: " + ConnectionSettings.FILTER_UNF.getValue());
        if (!ConnectionSettings.FILTER_UNF.getValue()) {
            return true;
        }
        boolean bl = result = userAgentHeader.startsWith("LimeWire") || userAgentHeader.startsWith("Acquisition") || userAgentHeader.startsWith("AcqLite") || userAgentHeader.startsWith("Furi");
        if (!result) {
            System.err.println("Not trusting: " + userAgentHeader);
        }
        return result;
    }

    private int ultrapeerConnections() {
        int ret = 0;
        Iterator iter = this._initializedConnections.iterator();
        while (iter.hasNext()) {
            ManagedConnection mc = (ManagedConnection)iter.next();
            if (!mc.isSupernodeConnection()) continue;
            ++ret;
        }
        return ret;
    }

    private int ultrapeerToUltrapeerConnections() {
        int ret = 0;
        Iterator iter = this._initializedConnections.iterator();
        while (iter.hasNext()) {
            ManagedConnection mc = (ManagedConnection)iter.next();
            if (!mc.isSupernodeSupernodeConnection()) continue;
            ++ret;
        }
        return ret;
    }

    private int oldConnections() {
        int ret = 0;
        Iterator iter = this._initializedConnections.iterator();
        while (iter.hasNext()) {
            ManagedConnection mc = (ManagedConnection)iter.next();
            if (mc.isSupernodeConnection()) continue;
            ++ret;
        }
        return ret;
    }

    public boolean supernodeNeeded() {
        return (double)this.getNumInitializedClientConnections() >= (double)UltrapeerSettings.MAX_LEAVES.getValue() * 0.9;
    }

    public Authenticator getAuthenticator() {
        return this._authenticator;
    }

    public List getInitializedConnections() {
        ArrayList clone = new ArrayList();
        clone.addAll(this._initializedConnections);
        return clone;
    }

    public List getInitializedClientConnections() {
        ArrayList clone = new ArrayList();
        clone.addAll(this._initializedClientConnections);
        return clone;
    }

    public List getInitializedConnections2() {
        return this._initializedConnections;
    }

    public List getInitializedClientConnections2() {
        return this._initializedClientConnections;
    }

    public List getConnections() {
        ArrayList clone = new ArrayList(this._connections);
        return clone;
    }

    public Set getPushProxies() {
        if (this.isShieldedLeaf()) {
            Iterator ultrapeers = this.getInitializedConnections().iterator();
            HashSet<ManagedConnection> proxies = new HashSet<ManagedConnection>();
            while (ultrapeers.hasNext() && proxies.size() < 4) {
                ManagedConnection currMC = (ManagedConnection)ultrapeers.next();
                if (currMC.getPushProxyPort() < 0) continue;
                proxies.add(currMC);
            }
            return proxies;
        }
        return DataUtils.EMPTY_SET;
    }

    public Set getSupernodeEndpoints() {
        HashSet<Endpoint> retSet = new HashSet<Endpoint>();
        Iterator iterator = this._initializedConnections.iterator();
        while (iterator.hasNext()) {
            ManagedConnection connection = (ManagedConnection)iterator.next();
            if (!connection.isSupernodeConnection()) continue;
            retSet.add(new Endpoint(connection.getInetAddress().getAddress(), connection.getListeningPort()));
        }
        iterator = RouterService.getHostCatcher().getUltrapeerHosts(10);
        while (iterator.hasNext()) {
            Endpoint e = (Endpoint)iterator.next();
            retSet.add(e);
        }
        return retSet;
    }

    public Endpoint getConnectedGUESSUltrapeer() {
        Iterator iter = this._initializedConnections.iterator();
        while (iter.hasNext()) {
            ManagedConnection connection = (ManagedConnection)iter.next();
            if (!connection.isSupernodeConnection() || !connection.isGUESSUltrapeer()) continue;
            return new Endpoint(connection.getInetAddress().getAddress(), connection.getListeningPort());
        }
        return null;
    }

    public List getConnectedGUESSUltrapeers() {
        ArrayList<ManagedConnection> retList = new ArrayList<ManagedConnection>();
        Iterator iter = this._initializedConnections.iterator();
        while (iter.hasNext()) {
            ManagedConnection connection = (ManagedConnection)iter.next();
            if (!connection.isSupernodeConnection() || !connection.isGUESSUltrapeer()) continue;
            retList.add(connection);
        }
        return retList;
    }

    private void connectionInitializing(Connection c) {
        ArrayList<Connection> newConnections = new ArrayList<Connection>(this._connections);
        newConnections.add(c);
        this._connections = newConnections;
    }

    private void connectionInitializingIncoming(ManagedConnection c) {
        this.connectionInitializing(c);
    }

    private boolean connectionInitialized(ManagedConnection c) {
        if (this._connections.contains(c)) {
            c.buildAndStartQueues();
            if (!c.isSupernodeClientConnection()) {
                ArrayList<ManagedConnection> newConnections = new ArrayList<ManagedConnection>(this._initializedConnections);
                newConnections.add(c);
                this._initializedConnections = newConnections;
                if (c.isClientSupernodeConnection()) {
                    ++this._shieldedConnections;
                }
            } else {
                ArrayList<ManagedConnection> newConnections = new ArrayList<ManagedConnection>(this._initializedClientConnections);
                newConnections.add(c);
                this._initializedClientConnections = newConnections;
            }
            c.postInit();
            this.sendInitialPingRequest(c);
            return true;
        }
        return false;
    }

    public synchronized void disconnect() {
        this.setKeepAlive(0);
        Iterator iter = this.getConnections().iterator();
        while (iter.hasNext()) {
            ManagedConnection c = (ManagedConnection)iter.next();
            this.remove(c);
            if (!c.isSupernodeConnection()) continue;
            this._catcher.add(new Endpoint(c.getInetAddress().getHostAddress(), c.getListeningPort()), true);
        }
    }

    public synchronized void connect() {
        this._catcher.expire();
        int outgoing = ConnectionSettings.NUM_CONNECTIONS.getValue();
        if (outgoing < 1) {
            ConnectionSettings.NUM_CONNECTIONS.revertToDefault();
            outgoing = ConnectionSettings.NUM_CONNECTIONS.getValue();
        }
        this.setKeepAlive(outgoing);
    }

    private void sendInitialPingRequest(ManagedConnection connection) {
        if (connection.supportsPongCaching()) {
            return;
        }
        PingRequest pr = this.getNumInitializedConnections() >= this._keepAlive ? new PingRequest(1) : new PingRequest(4);
        connection.send(pr);
        try {
            connection.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void removeInternal(ManagedConnection c) {
        ArrayList newConnections;
        int i;
        if (!c.isSupernodeClientConnection()) {
            i = this._initializedConnections.indexOf(c);
            if (i != -1) {
                newConnections = new ArrayList();
                newConnections.addAll(this._initializedConnections);
                newConnections.remove(c);
                this._initializedConnections = newConnections;
                if (c.isClientSupernodeConnection()) {
                    --this._shieldedConnections;
                }
            }
        } else {
            i = this._initializedClientConnections.indexOf(c);
            if (i != -1) {
                newConnections = new ArrayList();
                newConnections.addAll(this._initializedClientConnections);
                newConnections.remove(c);
                this._initializedClientConnections = newConnections;
            }
        }
        i = this._connections.indexOf(c);
        if (i != -1) {
            newConnections = new ArrayList(this._connections);
            newConnections.remove(c);
            this._connections = newConnections;
        }
        c.close();
        RouterService.getMessageRouter().removeConnection(c);
        RouterService.getCallback().connectionClosed(c);
        QueryUnicaster.instance().purgeQuery(c);
    }

    private void adjustConnectionFetchers() {
        ManagedConnection first;
        int need;
        int multiple;
        int goodConnections = this.getNumInitializedConnections();
        int neededConnections = this._keepAlive - goodConnections;
        if (!RouterService.acceptedIncomingConnection()) {
            multiple = 4;
        } else if (this.isShieldedLeaf() || !this.isSupernode() || this.getNumUltrapeerConnections() == 0) {
            multiple = 4;
        } else if (neededConnections > 10) {
            multiple = 4;
        } else {
            multiple = 2;
            neededConnections -= 5;
        }
        for (need = Math.min(20, multiple * neededConnections) - this._fetchers.size() - this._initializingFetchedConnections.size(); need > 0; --need) {
            this._fetchers.add(new ConnectionFetcher());
        }
        int lastFetcherIndex = this._fetchers.size();
        while (need < 0 && lastFetcherIndex > 0) {
            ConnectionFetcher fetcher = (ConnectionFetcher)this._fetchers.remove(--lastFetcherIndex);
            fetcher.interrupt();
            ++need;
        }
        int lastInitializingConnectionIndex = this._initializingFetchedConnections.size();
        while (need < 0 && lastInitializingConnectionIndex > 0) {
            ManagedConnection connection = (ManagedConnection)this._initializingFetchedConnections.remove(--lastInitializingConnectionIndex);
            this.removeInternal(connection);
            ++need;
        }
        if (need < 0 && (first = (ManagedConnection)this._initializedConnections.get(0)) != null) {
            this.remove(first);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeFetchedConnection(ManagedConnection mc, ConnectionFetcher fetcher) throws NoGnutellaOkException, BadHandshakeException, IOException {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            if (fetcher.isInterrupted()) {
                throw new IOException("connection fetcher");
            }
            this._initializingFetchedConnections.add(mc);
            this._fetchers.remove(fetcher);
            this.connectionInitializing(mc);
        }
        RouterService.getCallback().connectionInitializing(mc);
        try {
            mc.initialize();
        }
        catch (IOException e) {
            ConnectionManager connectionManager2 = this;
            synchronized (connectionManager2) {
                this._initializingFetchedConnections.remove(mc);
                this.removeInternal(mc);
                this.adjustConnectionFetchers();
            }
            throw e;
        }
        finally {
            this.processConnectionHeaders(mc);
        }
        this.completeConnectionInitialization(mc, true);
    }

    private synchronized void gotShieldedClientSupernodeConnection() {
    }

    private synchronized void lostShieldedClientSupernodeConnection() {
    }

    private void processConnectionHeaders(Connection connection) {
        if (!connection.receivedHeaders()) {
            return;
        }
        Properties headers = connection.headers().props();
        if (headers == null) {
            return;
        }
        this.updateHostCache(connection.headers());
        String remoteAddress = headers.getProperty("Listen-IP");
        if (remoteAddress == null) {
            remoteAddress = headers.getProperty("X-My-Address");
        }
        if (remoteAddress != null && !connection.isOutgoing()) {
            int colonIndex = remoteAddress.indexOf(58);
            if (colonIndex == -1) {
                return;
            }
            if (++colonIndex > remoteAddress.length()) {
                return;
            }
            try {
                int port = Integer.parseInt(remoteAddress.substring(colonIndex).trim());
                if (NetworkUtils.isValidPort(port)) {
                    connection.setListeningPort(port);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }

    public boolean allowLeafDemotion() {
        ++this._leafTries;
        int connections = this.getNumInitializedConnections() + this.getNumInitializedClientConnections();
        if (UltrapeerSettings.FORCE_ULTRAPEER_MODE.getValue() || this.isSupernode() && connections > 0) {
            return false;
        }
        return !SupernodeAssigner.isTooGoodToPassUp() || this._leafTries >= this._demotionLimit;
    }

    public void tryToBecomeAnUltrapeer(int demotionLimit) {
        if (this.isSupernode()) {
            return;
        }
        this._demotionLimit = demotionLimit;
        this._leafTries = 0;
        this.disconnect();
        this.connect();
    }

    private void updateHostCache(HandshakeResponse headers) {
        if (!headers.hasXTryUltrapeers()) {
            return;
        }
        String hostAddresses = headers.getXTryUltrapeers();
        StringTokenizer st = new StringTokenizer(hostAddresses, ",");
        while (st.hasMoreTokens()) {
            Endpoint e;
            String address = st.nextToken().trim();
            try {
                e = new Endpoint(address);
            }
            catch (IllegalArgumentException iae) {
                continue;
            }
            this._catcher.add(e, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeExternallyGeneratedConnection(ManagedConnection c) throws IOException {
        ConnectionManager connectionManager;
        if (c.isOutgoing()) {
            connectionManager = this;
            synchronized (connectionManager) {
                this.connectionInitializing(c);
                this.adjustConnectionFetchers();
            }
            RouterService.getCallback().connectionInitializing(c);
        }
        try {
            c.initialize();
        }
        catch (IOException e) {
            this.remove(c);
            throw e;
        }
        finally {
            this.processConnectionHeaders(c);
        }
        if (!c.isOutgoing() && !this.allowConnection(c)) {
            c.loopToReject();
            throw new IOException("No space for connection");
        }
        if (!c.isOutgoing()) {
            connectionManager = this;
            synchronized (connectionManager) {
                this.connectionInitializingIncoming(c);
                this.adjustConnectionFetchers();
            }
            RouterService.getCallback().connectionInitializing(c);
        }
        this.completeConnectionInitialization(c, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeConnectionInitialization(ManagedConnection mc, boolean fetched) {
        boolean connectionOpen = false;
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            if (fetched) {
                this._initializingFetchedConnections.remove(mc);
            }
            if ((connectionOpen = this.connectionInitialized(mc)) && mc.isClientSupernodeConnection()) {
                this.gotShieldedClientSupernodeConnection();
            }
            if (connectionOpen) {
                RouterService.getCallback().connectionInitialized(mc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startConnection(ManagedConnection conn) throws IOException {
        Thread.currentThread().setName("MessageLoopingThread");
        try {
            if (conn.isGUESSUltrapeer()) {
                QueryUnicaster.instance().addUnicastEndpoint(conn.getInetAddress(), conn.getListeningPort());
            }
            conn.loopForMessages();
        }
        finally {
            this.remove(conn);
        }
    }

    private class ConnectionFetcher
    extends Thread {
        public ConnectionFetcher() {
            this.setName("ConnectionFetcher");
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Endpoint endpoint = null;
            do {
                try {
                    endpoint = ConnectionManager.this._catcher.getAnEndpoint();
                }
                catch (InterruptedException exc2) {
                    return;
                }
            } while (!IPFilter.instance().allow(endpoint.getHostname()) || ConnectionManager.this.isConnectedTo(endpoint));
            Assert.that(endpoint != null);
            ManagedConnection connection = new ManagedConnection(endpoint.getHostname(), endpoint.getPort());
            try {
                try {
                    ConnectionManager.this.initializeFetchedConnection(connection, this);
                    ConnectionManager.this._catcher.doneWithConnect(endpoint, true);
                }
                catch (NoGnutellaOkException e) {
                    ConnectionManager.this._catcher.doneWithConnect(endpoint, true);
                    throw e;
                }
                catch (IOException e) {
                    ConnectionManager.this._catcher.doneWithConnect(endpoint, false);
                    throw e;
                }
                ConnectionManager.this.startConnection(connection);
            }
            catch (IOException e) {
            }
            catch (Throwable e) {
                ErrorService.error(e);
            }
            finally {
                if (connection.isClientSupernodeConnection()) {
                    ConnectionManager.this.lostShieldedClientSupernodeConnection();
                }
            }
        }
    }

    private class OutgoingConnector
    implements Runnable {
        private final ManagedConnection _connection;
        private final boolean _doInitialization;

        public OutgoingConnector(ManagedConnection connection, boolean initialize) {
            this._connection = connection;
            this._doInitialization = initialize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                if (this._doInitialization) {
                    ConnectionManager.this.initializeExternallyGeneratedConnection(this._connection);
                }
                ConnectionManager.this.startConnection(this._connection);
            }
            catch (IOException e) {
            }
            catch (Throwable e) {
                ErrorService.error(e);
            }
            finally {
                if (this._connection.isClientSupernodeConnection()) {
                    ConnectionManager.this.lostShieldedClientSupernodeConnection();
                }
            }
        }
    }
}

