/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.handshaking.BadHandshakeException;
import com.limegroup.gnutella.handshaking.HandshakeResponder;
import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.handshaking.NoGnutellaOkException;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.MessagesSupportedVendorMessage;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.statistics.BandwidthStat;
import com.limegroup.gnutella.statistics.CompressionStat;
import com.limegroup.gnutella.statistics.ConnectionStat;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.CompressingOutputStream;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.Sockets;
import com.limegroup.gnutella.util.UncompressingInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Properties;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class Connection {
    private final Object PING_LOCK = new Object();
    private final Object PONG_LOCK = new Object();
    private final String _host;
    private int _port;
    private Socket _socket;
    private InputStream _in;
    private OutputStream _out;
    private final boolean OUTGOING;
    private Inflater _inflater;
    private Deflater _deflater;
    private volatile long _bytesSent;
    private volatile long _bytesReceived;
    private volatile long _compressedBytesSent;
    private volatile long _compressedBytesReceived;
    protected MessagesSupportedVendorMessage _messagesSupported = null;
    protected volatile boolean _closed = false;
    private final Properties HEADERS_READ = new Properties();
    private HandshakeResponse _headers = HandshakeResponse.createEmptyResponse();
    private HandshakeResponse _headersWritten = HandshakeResponse.createEmptyResponse();
    private final Properties REQUEST_HEADERS;
    private HandshakeResponder RESPONSE_HEADERS;
    private final Properties HEADERS_WRITTEN = new Properties();
    private String GNUTELLA_CONNECT_06 = "GNUTELLA CONNECT/0.6";
    public static final String GNUTELLA_OK_06 = "GNUTELLA/0.6 200 OK";
    public static final String GNUTELLA_06 = "GNUTELLA/0.6";
    public static final String _200_OK = " 200 OK";
    public static final String GNUTELLA_06_200 = "GNUTELLA/0.6 200";
    public static final String CONNECT = "CONNECT/";
    public static final String CRLF = "\r\n";
    public static final int USER_INPUT_WAIT_TIME = 120000;
    public static final int MAX_HANDSHAKE_ATTEMPTS = 5;
    private long _connectionTime = Long.MAX_VALUE;
    private Boolean _isLeaf = null;
    private Boolean _isUltrapeer = null;
    private Boolean _isUltrapeerToUltrapeer = null;
    private byte _softMax;
    private volatile long _nextPingTime = Long.MIN_VALUE;
    private volatile long _nextPongTime = Long.MIN_VALUE;
    protected static final IOException CONNECTION_CLOSED = new IOException("connection closed");
    private byte[] HEADER_BUF = new byte[23];

    public Connection(String host, int port, Properties requestHeaders, HandshakeResponder responseHeaders) {
        if (host == null) {
            throw new NullPointerException("null host");
        }
        if (!NetworkUtils.isValidPort(port)) {
            throw new IllegalArgumentException("illegal port: " + port);
        }
        if (requestHeaders == null) {
            throw new NullPointerException("null request headers");
        }
        if (responseHeaders == null) {
            throw new NullPointerException("null response headers");
        }
        this._host = host;
        this._port = port;
        this.OUTGOING = true;
        this.REQUEST_HEADERS = requestHeaders;
        this.RESPONSE_HEADERS = responseHeaders;
        if (!CommonUtils.isJava118()) {
            ConnectionStat.OUTGOING_CONNECTION_ATTEMPTS.incrementStat();
        }
    }

    public Connection(Socket socket, HandshakeResponder responseHeaders) {
        if (socket == null) {
            throw new NullPointerException("null socket");
        }
        if (responseHeaders == null) {
            throw new NullPointerException("null response headers");
        }
        this._host = socket.getInetAddress().getHostAddress();
        this._port = socket.getPort();
        this._socket = socket;
        this.OUTGOING = false;
        this.RESPONSE_HEADERS = responseHeaders;
        this.REQUEST_HEADERS = null;
        if (!CommonUtils.isJava118()) {
            ConnectionStat.INCOMING_CONNECTION_ATTEMPTS.incrementStat();
        }
    }

    protected void postInit() {
        try {
            if (this._headers.supportsVendorMessages()) {
                this.send(MessagesSupportedVendorMessage.instance());
            }
        }
        catch (IOException ioe) {
        }
        catch (BadPacketException bpe) {
            ErrorService.error(bpe);
        }
    }

    protected void handleVendorMessage(VendorMessage vm) {
        if (vm instanceof MessagesSupportedVendorMessage) {
            this._messagesSupported = (MessagesSupportedVendorMessage)vm;
        }
    }

    public void initialize() throws IOException, NoGnutellaOkException, BadHandshakeException {
        this.initialize(0);
    }

    public void initialize(int timeout) throws IOException, NoGnutellaOkException, BadHandshakeException {
        if (this.isOutgoing()) {
            this._socket = Sockets.connect(this._host, this._port, timeout);
        }
        if (this._closed) {
            this._socket.close();
            throw CONNECTION_CLOSED;
        }
        InetAddress localAddress = this._socket.getLocalAddress();
        if (ConnectionSettings.LOCAL_IS_PRIVATE.getValue() && this._socket.getInetAddress().equals(localAddress) && this._port == ConnectionSettings.PORT.getValue()) {
            throw new IOException("Connection to self");
        }
        try {
            RouterService.getAcceptor().setAddress(localAddress);
            this._in = this.getInputStream();
            this._out = this.getOutputStream();
            if (this._in == null) {
                throw new IOException("null input stream");
            }
            if (this._out == null) {
                throw new IOException("null output stream");
            }
        }
        catch (Exception e) {
            this.close();
            throw new IOException("could not establish connection");
        }
        try {
            if (this.isOutgoing()) {
                this.initializeOutgoing();
            } else {
                this.initializeIncoming();
            }
            this._headers = HandshakeResponse.createResponse(this.HEADERS_READ);
            this._headersWritten = HandshakeResponse.createResponse(this.HEADERS_WRITTEN);
            this._connectionTime = System.currentTimeMillis();
            this._softMax = ConnectionSettings.SOFT_MAX.getValue();
            if (this.isGoodUltrapeer() || this.isGoodLeaf()) {
                this._softMax = (byte)(this._softMax + 1);
            }
            if (this.isWriteDeflated()) {
                this._deflater = new Deflater();
                this._out = new CompressingOutputStream(this._out, this._deflater);
            }
            if (this.isReadDeflated()) {
                this._inflater = new Inflater();
                this._in = new UncompressingInputStream(this._in, this._inflater);
            }
            this.RESPONSE_HEADERS = null;
        }
        catch (NoGnutellaOkException e) {
            this.close();
            throw e;
        }
        catch (IOException e) {
            this.close();
            throw new BadHandshakeException(e);
        }
    }

    public boolean isInitialized() {
        return this._socket != null;
    }

    private void initializeOutgoing() throws IOException {
        this.writeLine(this.GNUTELLA_CONNECT_06 + CRLF);
        this.sendHeaders(this.REQUEST_HEADERS);
        this.concludeOutgoingHandshake();
    }

    private void concludeOutgoingHandshake() throws IOException {
        for (int i = 0; i < 5; ++i) {
            String connectLine = this.readLine();
            Assert.that(connectLine != null, "null connectLine");
            if (!connectLine.startsWith(GNUTELLA_06)) {
                throw new IOException("Bad connect string");
            }
            this.readHeaders();
            HandshakeResponse theirResponse = HandshakeResponse.createResponse(connectLine.substring(GNUTELLA_06.length()).trim(), this.HEADERS_READ);
            Assert.that(theirResponse != null, "null theirResponse");
            int code = theirResponse.getStatusCode();
            if (code != 200 && code != 401) {
                if (code == 503) {
                    throw NoGnutellaOkException.SERVER_REJECT;
                }
                throw NoGnutellaOkException.createServerUnknown(code);
            }
            Assert.that(this.RESPONSE_HEADERS != null, "null RESPONSE_HEADERS");
            HandshakeResponse ourResponse = this.RESPONSE_HEADERS.respond(theirResponse, true);
            Assert.that(ourResponse != null, "null ourResponse");
            this.writeLine("GNUTELLA/0.6 " + ourResponse.getStatusLine() + CRLF);
            this.sendHeaders(ourResponse.props());
            code = ourResponse.getStatusCode();
            if (code == 200) {
                if (!"OK".equals(ourResponse.getStatusMessage())) continue;
                return;
            }
            if (code == 503) {
                throw NoGnutellaOkException.CLIENT_REJECT;
            }
            throw NoGnutellaOkException.createClientUnknown(code);
        }
        throw NoGnutellaOkException.UNRESOLVED_SERVER;
    }

    private void initializeIncoming() throws IOException {
        String connectString = this.readLine();
        if (!Connection.notLessThan06(connectString)) {
            throw new IOException("Unexpected connect string: " + connectString);
        }
        this.readHeaders();
        this.concludeIncomingHandshake();
    }

    private void concludeIncomingHandshake() throws IOException {
        for (int i = 0; i < 5; ++i) {
            String connectLine;
            boolean isCrawler = this._headers.isCrawler();
            HandshakeResponse ourResponse = this.RESPONSE_HEADERS.respond(this._headers, false);
            this.writeLine("GNUTELLA/0.6 " + ourResponse.getStatusLine() + CRLF);
            this.sendHeaders(ourResponse.props());
            int code = ourResponse.getStatusCode();
            if (code != 200 && code != 401) {
                if (code == 503) {
                    throw NoGnutellaOkException.CLIENT_REJECT;
                }
                throw NoGnutellaOkException.createClientUnknown(code);
            }
            if (ourResponse.getStatusCode() == 401) {
                connectLine = this.readLine(120000);
                this.readHeaders(120000);
                this._headers = HandshakeResponse.createResponse(this.HEADERS_READ);
            } else {
                connectLine = this.readLine();
                this.readHeaders();
            }
            if (!connectLine.startsWith(GNUTELLA_06)) {
                throw new IOException("Bad connect string");
            }
            HandshakeResponse theirResponse = HandshakeResponse.createResponse(connectLine.substring(GNUTELLA_06.length()).trim(), this.HEADERS_READ);
            code = ourResponse.getStatusCode();
            if (code == 200) {
                if (theirResponse.getStatusCode() == 200) {
                    if (isCrawler) {
                        throw new IOException("connection from crawler -- disconnect");
                    }
                    return;
                }
            } else {
                Assert.that(code == 401, "Response code: " + code);
                if (theirResponse.getStatusCode() == 200) continue;
            }
            throw NoGnutellaOkException.createServerUnknown(theirResponse.getStatusCode());
        }
        throw NoGnutellaOkException.UNRESOLVED_CLIENT;
    }

    private static boolean notLessThan06(String line) {
        int i = line.indexOf(CONNECT);
        if (i < 0) {
            return false;
        }
        try {
            Float F = new Float(line.substring(i + CONNECT.length()));
            float f = F.floatValue();
            return f >= 0.6f;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private void sendHeaders(Properties props) throws IOException {
        if (props != null) {
            Enumeration<?> enumeration = props.propertyNames();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                String value = props.getProperty(key);
                if ("Remote-IP".equals(key)) {
                    value = this.getInetAddress().getHostAddress();
                }
                if (value == null) {
                    value = "";
                }
                this.writeLine(key + ": " + value + CRLF);
                this.HEADERS_WRITTEN.put(key, value);
            }
        }
        this.writeLine(CRLF);
    }

    private void readHeaders() throws IOException {
        this.readHeaders(8000);
        this._headers = HandshakeResponse.createResponse(this.HEADERS_READ);
    }

    private void readHeaders(int timeout) throws IOException {
        while (true) {
            String line;
            if ((line = this.readLine(timeout)) == null) {
                throw new IOException("unexpected end of file");
            }
            if (line.equals("")) {
                String remoteIP = (String)this.HEADERS_READ.get("Remote-IP");
                if (remoteIP == null) {
                    return;
                }
                String localIP = InetAddress.getLocalHost().getHostAddress();
                if (!remoteIP.equals(localIP) && !remoteIP.equals(ConnectionSettings.FORCED_IP_ADDRESS_STRING.getValue())) {
                    System.err.println("Forcing IP: " + remoteIP + " / " + localIP);
                    ConnectionSettings.FORCE_IP_ADDRESS.setValue(true);
                    ConnectionSettings.FORCED_IP_ADDRESS_STRING.setValue(remoteIP);
                }
                return;
            }
            int i = line.indexOf(58);
            if (i < 0) continue;
            String key = line.substring(0, i);
            String value = line.substring(i + 1).trim();
            this.HEADERS_READ.put(key, value);
        }
    }

    private void writeLine(String s) throws IOException {
        if (s == null || s.equals("")) {
            throw new NullPointerException("null or empty string: " + s);
        }
        byte[] bytes = s.getBytes();
        if (!CommonUtils.isJava118()) {
            BandwidthStat.GNUTELLA_HEADER_UPSTREAM_BANDWIDTH.addData(bytes.length);
        }
        this._out.write(bytes);
        this._out.flush();
    }

    private String readLine() throws IOException {
        return this.readLine(8000);
    }

    private String readLine(int timeout) throws IOException {
        int oldTimeout = this._socket.getSoTimeout();
        try {
            this._socket.setSoTimeout(timeout);
            String line = new ByteReader(this._in).readLine();
            if (line == null) {
                throw new IOException("read null line");
            }
            if (!CommonUtils.isJava118()) {
                BandwidthStat.GNUTELLA_HEADER_DOWNSTREAM_BANDWIDTH.addData(line.length());
            }
            String string = line;
            return string;
        }
        catch (NullPointerException npe) {
            throw CONNECTION_CLOSED;
        }
        finally {
            this._socket.setSoTimeout(oldTimeout);
        }
    }

    protected OutputStream getOutputStream() throws IOException {
        return new BufferedOutputStream(this._socket.getOutputStream());
    }

    protected InputStream getInputStream() throws IOException {
        return new BufferedInputStream(this._socket.getInputStream());
    }

    public boolean isOutgoing() {
        return this.OUTGOING;
    }

    protected Message receive() throws IOException, BadPacketException {
        if (this._closed) {
            throw CONNECTION_CLOSED;
        }
        Message m = null;
        while (m == null) {
            m = this.readAndUpdateStatistics();
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receive(int timeout) throws IOException, BadPacketException, InterruptedIOException {
        if (this._closed) {
            throw CONNECTION_CLOSED;
        }
        int oldTimeout = this._socket.getSoTimeout();
        this._socket.setSoTimeout(timeout);
        try {
            Message m = this.readAndUpdateStatistics();
            if (m == null) {
                throw new InterruptedIOException("null message read");
            }
            Message message = m;
            return message;
        }
        finally {
            this._socket.setSoTimeout(oldTimeout);
        }
    }

    private Message readAndUpdateStatistics() throws IOException, BadPacketException {
        int pCompressed = 0;
        int pUncompressed = 0;
        Message msg = null;
        try {
            if (this.isReadDeflated()) {
                pCompressed = this._inflater.getTotalIn();
                pUncompressed = this._inflater.getTotalOut();
            }
            try {
                msg = Message.read(this._in, this.HEADER_BUF, 1, this._softMax);
            }
            catch (IOException ioe) {
                this.close();
                throw ioe;
            }
            if (this.isReadDeflated()) {
                this._compressedBytesReceived = this._inflater.getTotalIn();
                this._bytesReceived = this._inflater.getTotalOut();
                if (!CommonUtils.isJava118()) {
                    CompressionStat.GNUTELLA_UNCOMPRESSED_DOWNSTREAM.addData(this._inflater.getTotalOut() - pUncompressed);
                    CompressionStat.GNUTELLA_COMPRESSED_DOWNSTREAM.addData(this._inflater.getTotalIn() - pCompressed);
                }
            } else if (msg != null) {
                this._bytesReceived += (long)msg.getTotalLength();
            }
        }
        catch (NullPointerException npe) {
            throw CONNECTION_CLOSED;
        }
        return msg;
    }

    public void send(Message m) throws IOException {
        long priorCompressed = 0L;
        long priorUncompressed = 0L;
        try {
            if (this.isWriteDeflated()) {
                priorUncompressed = this._deflater.getTotalIn();
                priorCompressed = this._deflater.getTotalOut();
            }
            try {
                m.write(this._out);
            }
            catch (IOException ioe) {
                this.close();
                throw ioe;
            }
            this.updateWriteStatistics(m, priorUncompressed, priorCompressed);
        }
        catch (NullPointerException e) {
            throw CONNECTION_CLOSED;
        }
    }

    public void flush() throws IOException {
        long priorCompressed = 0L;
        long priorUncompressed = 0L;
        try {
            if (this.isWriteDeflated()) {
                priorUncompressed = this._deflater.getTotalIn();
                priorCompressed = this._deflater.getTotalOut();
            }
            try {
                this._out.flush();
            }
            catch (IOException ioe) {
                this.close();
                throw ioe;
            }
            this.updateWriteStatistics(null, priorUncompressed, priorCompressed);
        }
        catch (NullPointerException npe) {
            throw CONNECTION_CLOSED;
        }
    }

    private void updateWriteStatistics(Message m, long pUn, long pComp) {
        if (m != null) {
            this._bytesSent += (long)m.getTotalLength();
        }
        if (this.isWriteDeflated()) {
            this._compressedBytesSent = this._deflater.getTotalOut();
            if (!CommonUtils.isJava118()) {
                CompressionStat.GNUTELLA_UNCOMPRESSED_UPSTREAM.addData((int)((long)this._deflater.getTotalIn() - pUn));
                CompressionStat.GNUTELLA_COMPRESSED_UPSTREAM.addData((int)((long)this._deflater.getTotalOut() - pComp));
            }
        }
    }

    public long getBytesSent() {
        if (this.isWriteDeflated()) {
            return this._compressedBytesSent;
        }
        return this._bytesSent;
    }

    public long getUncompressedBytesSent() {
        return this._bytesSent;
    }

    public long getBytesReceived() {
        if (this.isReadDeflated()) {
            return this._compressedBytesReceived;
        }
        return this._bytesReceived;
    }

    public long getUncompressedBytesReceived() {
        return this._bytesReceived;
    }

    public float getSentSavedFromCompression() {
        if (!this.isWriteDeflated() || this._bytesSent == 0L) {
            return 0.0f;
        }
        return 1.0f - (float)this._compressedBytesSent / (float)this._bytesSent;
    }

    public float getReadSavedFromCompression() {
        if (!this.isReadDeflated() || this._bytesReceived == 0L) {
            return 0.0f;
        }
        return 1.0f - (float)this._compressedBytesReceived / (float)this._bytesReceived;
    }

    public String getIPString() {
        return this._host;
    }

    public int getListeningPort() {
        return this._port;
    }

    void setListeningPort(int port) {
        if (!NetworkUtils.isValidPort(port)) {
            throw new IllegalArgumentException("invalid port: " + port);
        }
        this._port = port;
    }

    public InetAddress getInetAddress() throws IllegalStateException {
        if (this._socket == null) {
            throw new IllegalStateException("Not initialized");
        }
        return this._socket.getInetAddress();
    }

    public Socket getSocket() throws IllegalStateException {
        if (this._socket == null) {
            throw new IllegalStateException("Not initialized");
        }
        return this._socket;
    }

    public boolean isConnectBackCapable() throws IllegalStateException {
        byte[] remote = this.getInetAddress().getAddress();
        byte[] local = this._socket.getLocalAddress().getAddress();
        return !NetworkUtils.isCloseIP(local, remote);
    }

    public long getConnectionTime() {
        return this._connectionTime;
    }

    public byte getSoftMax() {
        return this._softMax;
    }

    public boolean isStable() {
        return this.isStable(System.currentTimeMillis());
    }

    public boolean isStable(long millis) {
        return (millis - this.getConnectionTime()) / 1000L > 5L;
    }

    public int supportsVendorMessage(byte[] vendorID, int selector) {
        if (this._messagesSupported != null) {
            return this._messagesSupported.supportsMessage(vendorID, selector);
        }
        return -1;
    }

    public int remoteHostSupportsUDPConnectBack() {
        if (this._messagesSupported != null) {
            return this._messagesSupported.supportsUDPConnectBack();
        }
        return -1;
    }

    public int remoteHostSupportsTCPConnectBack() {
        if (this._messagesSupported != null) {
            return this._messagesSupported.supportsTCPConnectBack();
        }
        return -1;
    }

    public int remoteHostSupportsHopsFlow() {
        if (this._messagesSupported != null) {
            return this._messagesSupported.supportsHopsFlow();
        }
        return -1;
    }

    public int remoteHostSupportsPushProxy() {
        if (this._messagesSupported != null && this.isClientSupernodeConnection()) {
            return this._messagesSupported.supportsPushProxy();
        }
        return -1;
    }

    protected boolean isLocal() {
        return NetworkUtils.isLocalAddress(this._socket.getInetAddress());
    }

    public String getPropertyWritten(String name) {
        return this.HEADERS_WRITTEN.getProperty(name);
    }

    public boolean isOpen() {
        return !this._closed;
    }

    public void close() {
        this._closed = true;
        if (this._socket != null) {
            try {
                this._socket.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this._deflater != null) {
            this._deflater.end();
        }
        if (this._inflater != null) {
            this._inflater.end();
        }
        if (this._in != null) {
            try {
                this._in.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this._out != null) {
            try {
                this._out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String getUserAgent() {
        return this._headers.getUserAgent();
    }

    public boolean isWriteDeflated() {
        return this._headersWritten.isDeflateEnabled();
    }

    public boolean isReadDeflated() {
        return this._headers.isDeflateEnabled();
    }

    public boolean isGoodUltrapeer() {
        return this._headers.isGoodUltrapeer();
    }

    public boolean isGoodLeaf() {
        return this._headers.isGoodLeaf();
    }

    public boolean supportsPongCaching() {
        return this._headers.supportsPongCaching();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allowNewPings() {
        Object object = this.PING_LOCK;
        synchronized (object) {
            long curTime = System.currentTimeMillis();
            if (!this.isStable(curTime)) {
                return false;
            }
            if (curTime < this._nextPingTime) {
                return false;
            }
            this._nextPingTime = System.currentTimeMillis() + 2500L;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allowNewPongs() {
        Object object = this.PONG_LOCK;
        synchronized (object) {
            long curTime = System.currentTimeMillis();
            if (!this.isStable(curTime)) {
                return false;
            }
            if (curTime < this._nextPongTime) {
                return false;
            }
            int interval = curTime - this.getConnectionTime() < 10000L ? 300 : 12000;
            this._nextPongTime = curTime + (long)interval;
            return true;
        }
    }

    public int getNumIntraUltrapeerConnections() {
        return this._headers.getNumIntraUltrapeerConnections();
    }

    public boolean isHighDegreeConnection() {
        return this._headers.isHighDegreeConnection();
    }

    public boolean isUltrapeerQueryRoutingConnection() {
        return this._headers.isUltrapeerQueryRoutingConnection();
    }

    public boolean supportsProbeQueries() {
        return this._headers.supportsProbeQueries();
    }

    public String getDomainsAuthenticated() {
        return this._headers.getDomainsAuthenticated();
    }

    public boolean receivedHeaders() {
        return this._headers != null;
    }

    public HandshakeResponse headers() {
        return this._headers;
    }

    public String getVersion() {
        return this._headers.getVersion();
    }

    public boolean isLeafConnection() {
        return this._headers.isLeaf();
    }

    public boolean isSupernodeConnection() {
        return this._headers.isUltrapeer();
    }

    public boolean isClientSupernodeConnection() {
        if (this._isUltrapeer == null) {
            this._isUltrapeer = this.isClientSupernodeConnection2() ? Boolean.TRUE : Boolean.FALSE;
        }
        return this._isUltrapeer;
    }

    private boolean isClientSupernodeConnection2() {
        if (!this.isSupernodeConnection()) {
            return false;
        }
        String value = this.getPropertyWritten("X-Ultrapeer");
        if (value == null) {
            return false;
        }
        return Boolean.valueOf(value) == false;
    }

    public boolean isSupernodeSupernodeConnection() {
        if (this._isUltrapeerToUltrapeer == null) {
            this._isUltrapeerToUltrapeer = this.isSupernodeSupernodeConnection2() ? Boolean.TRUE : Boolean.FALSE;
        }
        return this._isUltrapeerToUltrapeer;
    }

    private boolean isSupernodeSupernodeConnection2() {
        if (!this.isSupernodeConnection()) {
            return false;
        }
        String value = this.getPropertyWritten("X-Ultrapeer");
        if (value == null) {
            return false;
        }
        return Boolean.valueOf(value);
    }

    public boolean isGUESSCapable() {
        return this._headers.isGUESSCapable();
    }

    public boolean isGUESSUltrapeer() {
        return this._headers.isGUESSUltrapeer();
    }

    public boolean isTempConnection() {
        return this._headers.isTempConnection();
    }

    public boolean isSupernodeClientConnection() {
        if (this._isLeaf == null) {
            this._isLeaf = this.isSupernodeClientConnection2() ? Boolean.TRUE : Boolean.FALSE;
        }
        return this._isLeaf;
    }

    private boolean isSupernodeClientConnection2() {
        if (!this.isLeafConnection()) {
            return false;
        }
        String value = this.getPropertyWritten("X-Ultrapeer");
        if (value == null) {
            return false;
        }
        if (!Boolean.valueOf(value).booleanValue()) {
            return false;
        }
        return this.isQueryRoutingEnabled();
    }

    public boolean supportsGGEP() {
        return this._headers.supportsGGEP();
    }

    boolean isQueryRoutingEnabled() {
        return this._headers.isQueryRoutingEnabled();
    }

    public String toString() {
        return "CONNECTION: host=" + this._host + " port=" + this._port;
    }
}

