/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.MulticastService;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.browser.ExternalControl;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.http.HTTPRequestMethod;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.SettingsHandler;
import com.limegroup.gnutella.statistics.HTTPStat;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;

public class Acceptor
implements Runnable {
    private volatile ServerSocket _socket = null;
    private volatile int _port = 6346;
    private final Object SOCKET_LOCK = new Object();
    private static byte[] _address = new byte[4];
    private volatile boolean _acceptedIncoming = false;
    private static final boolean RECORD_STATS = !CommonUtils.isJava118();
    private static final boolean debug = false;
    static /* synthetic */ Class class$com$limegroup$gnutella$Acceptor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAddress(InetAddress address) {
        byte[] byteAddr = address.getAddress();
        if (byteAddr[0] == 127 && ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return;
        }
        Class clazz = class$com$limegroup$gnutella$Acceptor == null ? (class$com$limegroup$gnutella$Acceptor = Acceptor.class$("com.limegroup.gnutella.Acceptor")) : class$com$limegroup$gnutella$Acceptor;
        synchronized (clazz) {
            _address = byteAddr;
        }
    }

    public void start() {
        MulticastService.instance().start();
        UDPService.instance().start();
        Thread at = new Thread((Runnable)this, "Acceptor");
        at.setDaemon(true);
        at.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getAddress(boolean checkForce) {
        if (checkForce && ConnectionSettings.FORCE_IP_ADDRESS.getValue()) {
            String address = ConnectionSettings.FORCED_IP_ADDRESS_STRING.getValue();
            if (address.equals("0.0.0.0")) {
                return new byte[]{0, 0, 0, 0};
            }
            try {
                InetAddress ia = InetAddress.getByName(address);
                return ia.getAddress();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        Class clazz = class$com$limegroup$gnutella$Acceptor == null ? (class$com$limegroup$gnutella$Acceptor = Acceptor.class$("com.limegroup.gnutella.Acceptor")) : class$com$limegroup$gnutella$Acceptor;
        synchronized (clazz) {
            return _address;
        }
    }

    public int getPort(boolean checkForce) {
        return this._port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListeningPort(int port) throws IOException {
        Acceptor.debug("Acceptor.setListeningPort(): entered.");
        if (this._socket != null && this._port == port) {
            return;
        }
        if (port == 0) {
            Acceptor.debug("Acceptor.setListeningPort(): shutting off service.");
            if (this._socket != null) {
                try {
                    this._socket.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            Object e = this.SOCKET_LOCK;
            synchronized (e) {
                this._socket = null;
                this._port = 0;
                this.SOCKET_LOCK.notify();
            }
            UDPService.instance().setListeningSocket(null);
            MulticastService.instance().setListeningSocket(null);
            Acceptor.debug("Acceptor.setListeningPort(): service OFF.");
            return;
        }
        Acceptor.debug("Acceptor.setListeningPort(): changing port to " + port);
        DatagramSocket udpServiceSocket = UDPService.instance().newListeningSocket(port);
        Acceptor.debug("Acceptor.setListeningPort(): UDP Service is ready.");
        MulticastSocket mcastServiceSocket = null;
        try {
            InetAddress mgroup = InetAddress.getByName(ConnectionSettings.MULTICAST_ADDRESS.getValue());
            mcastServiceSocket = MulticastService.instance().newListeningSocket(ConnectionSettings.MULTICAST_PORT.getValue(), mgroup);
            Acceptor.debug("Acceptor.setListeningPort(): Multicast Service is ready.");
        }
        catch (IOException e) {
            mcastServiceSocket = null;
            Acceptor.debug("Acceptor.setListeningPort(): Unable to start multicast service.");
        }
        ServerSocket newSocket = null;
        try {
            newSocket = new ServerSocket(port);
        }
        catch (IOException e) {
            udpServiceSocket.close();
            throw e;
        }
        catch (IllegalArgumentException e) {
            udpServiceSocket.close();
            throw new IOException("could not create a listening socket");
        }
        if (this._socket != null) {
            try {
                this._socket.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        Object object = this.SOCKET_LOCK;
        synchronized (object) {
            this._socket = newSocket;
            this._port = port;
            this.SOCKET_LOCK.notify();
        }
        Acceptor.debug("Acceptor.setListeningPort(): I am ready.");
        UDPService.instance().setListeningSocket(udpServiceSocket);
        if (mcastServiceSocket != null) {
            MulticastService.instance().setListeningSocket(mcastServiceSocket);
        }
        Acceptor.debug("Acceptor.setListeningPort(): listening UDP/TCP on " + this._port);
    }

    public boolean acceptedIncoming() {
        return this._acceptedIncoming;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        IOException socketError;
        int oldPort;
        block26: {
            int tempPort = ConnectionSettings.PORT.getValue();
            try {
                this.setAddress(InetAddress.getLocalHost());
            }
            catch (UnknownHostException e) {
            }
            catch (SecurityException e) {
                // empty catch block
            }
            oldPort = tempPort;
            socketError = null;
            try {
                this.setListeningPort(tempPort);
                this._port = tempPort;
            }
            catch (IOException e) {
                socketError = e;
                int numToTry = 10;
                for (int i = 0; i < numToTry; ++i) {
                    tempPort = i + 6346;
                    if (tempPort == ConnectionSettings.MULTICAST_PORT.getValue()) {
                        ++numToTry;
                        continue;
                    }
                    try {
                        this.setListeningPort(tempPort);
                        this._port = tempPort;
                        break;
                    }
                    catch (IOException e2) {
                        socketError = e2;
                    }
                }
                if (this._socket != null) break block26;
                ErrorService.error(socketError);
            }
        }
        socketError = null;
        if (this._port != oldPort) {
            ConnectionSettings.PORT.setValue(this._port);
            SettingsHandler.save();
        }
        while (true) {
            try {
                while (true) {
                    Socket client = null;
                    Object numToTry = this.SOCKET_LOCK;
                    synchronized (numToTry) {
                        if (this._socket != null) {
                            try {
                                client = this._socket.accept();
                            }
                            catch (IOException e) {
                                continue;
                            }
                        }
                        try {
                            this.SOCKET_LOCK.wait();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        continue;
                    }
                    InetAddress address = client.getInetAddress();
                    if (this.isBannedIP(address.getHostAddress())) {
                        if (RECORD_STATS) {
                            HTTPStat.BANNED_REQUESTS.incrementStat();
                        }
                        client.close();
                        continue;
                    }
                    if (!NetworkUtils.isCloseIP(address.getAddress(), this.getAddress(false)) || !ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
                        this._acceptedIncoming = true;
                        ConnectionSettings.EVER_ACCEPTED_INCOMING.setValue(this._acceptedIncoming);
                    }
                    ConnectionDispatchRunner dispatcher = new ConnectionDispatchRunner(client);
                    Thread dispatchThread = new Thread((Runnable)dispatcher, "ConnectionDispatchRunner");
                    dispatchThread.setDaemon(true);
                    dispatchThread.start();
                }
            }
            catch (SecurityException e) {
                ErrorService.error(e);
                continue;
            }
            catch (Throwable e) {
                ErrorService.error(e);
                continue;
            }
            break;
        }
    }

    public boolean isBannedIP(String ip) {
        return !IPFilter.instance().allow(ip);
    }

    private static void debug(String out) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ConnectionDispatchRunner
    implements Runnable {
        private final Socket _socket;

        public ConnectionDispatchRunner(Socket socket) {
            this._socket = socket;
        }

        public void run() {
            block23: {
                ConnectionManager cm = RouterService.getConnectionManager();
                UploadManager um = RouterService.getUploadManager();
                DownloadManager dm = RouterService.getDownloadManager();
                try {
                    InputStream in = null;
                    try {
                        in = this._socket.getInputStream();
                    }
                    catch (Exception e) {
                        if (RECORD_STATS) {
                            HTTPStat.CLOSED_REQUESTS.incrementStat();
                        }
                        throw new IOException("could not access socket stream");
                    }
                    this._socket.setSoTimeout(8000);
                    String word = IOUtils.readWord(in, 8);
                    this._socket.setSoTimeout(0);
                    if (!word.equals("MAGNET")) {
                        InetAddress address = this._socket.getInetAddress();
                        byte[] addressBytes = address.getAddress();
                        if (ConnectionSettings.LOCAL_IS_PRIVATE.getValue() && addressBytes[0] == 127) {
                            this._socket.close();
                            return;
                        }
                    }
                    boolean useDefaultConnect = ConnectionSettings.CONNECT_STRING.isDefault();
                    if (word.equals("GNUTELLA")) {
                        if (RECORD_STATS) {
                            HTTPStat.GNUTELLA_REQUESTS.incrementStat();
                        }
                        cm.acceptConnection(this._socket);
                        break block23;
                    }
                    if (useDefaultConnect && word.equals("LIMEWIRE")) {
                        if (RECORD_STATS) {
                            HTTPStat.GNUTELLA_LIMEWIRE_REQUESTS.incrementStat();
                        }
                        cm.acceptConnection(this._socket);
                        break block23;
                    }
                    if (word.equals("GET")) {
                        if (RECORD_STATS) {
                            HTTPStat.GET_REQUESTS.incrementStat();
                        }
                        um.acceptUpload(HTTPRequestMethod.GET, this._socket, false);
                        break block23;
                    }
                    if (word.equals("HEAD")) {
                        if (RECORD_STATS) {
                            HTTPStat.HEAD_REQUESTS.incrementStat();
                        }
                        um.acceptUpload(HTTPRequestMethod.HEAD, this._socket, false);
                        break block23;
                    }
                    if (word.equals("GIV")) {
                        if (RECORD_STATS) {
                            HTTPStat.GIV_REQUESTS.incrementStat();
                        }
                        dm.acceptDownload(this._socket);
                        break block23;
                    }
                    if (word.equals("MAGNET")) {
                        if (RECORD_STATS) {
                            HTTPStat.MAGNET_REQUESTS.incrementStat();
                        }
                        ExternalControl.fireMagnet(this._socket);
                        break block23;
                    }
                    if (RECORD_STATS) {
                        HTTPStat.UNKNOWN_REQUESTS.incrementStat();
                    }
                    throw new IOException("UNKOWN PROTOCOL: " + word);
                }
                catch (IOException e) {
                    try {
                        this._socket.close();
                    }
                    catch (IOException e2) {}
                }
                catch (Throwable e) {
                    ErrorService.error(e);
                }
            }
        }
    }
}

