/*
 * Decompiled with CFR 0.152.
 */
package com.bitzi.util;

public class Base32 {
    private static final String base32Chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567";
    private static final byte[] base32Lookup = new byte[]{26, 27, 28, 29, 30, 31, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25};
    private static final String errorCanonicalLength = "non canonical Base32 string length";
    private static final String errorCanonicalEnd = "non canonical bits at end of Base32 string";
    private static final String errorInvalidChar = "invalid character in Base32 string";

    public static String encode(byte[] bytes) {
        StringBuffer base32 = new StringBuffer((bytes.length * 8 + 4) / 5);
        int i = 0;
        while (i < bytes.length) {
            int currByte = bytes[i++] & 0xFF;
            base32.append(base32Chars.charAt(currByte >> 3));
            int digit = (currByte & 7) << 2;
            if (i >= bytes.length) {
                base32.append(base32Chars.charAt(digit));
                break;
            }
            currByte = bytes[i++] & 0xFF;
            base32.append(base32Chars.charAt(digit | currByte >> 6));
            base32.append(base32Chars.charAt(currByte >> 1 & 0x1F));
            digit = (currByte & 1) << 4;
            if (i >= bytes.length) {
                base32.append(base32Chars.charAt(digit));
                break;
            }
            currByte = bytes[i++] & 0xFF;
            base32.append(base32Chars.charAt(digit | currByte >> 4));
            digit = (currByte & 0xF) << 1;
            if (i >= bytes.length) {
                base32.append(base32Chars.charAt(digit));
                break;
            }
            currByte = bytes[i++] & 0xFF;
            base32.append(base32Chars.charAt(digit | currByte >> 7));
            base32.append(base32Chars.charAt(currByte >> 2 & 0x1F));
            digit = (currByte & 3) << 3;
            if (i >= bytes.length) {
                base32.append(base32Chars.charAt(digit));
                break;
            }
            currByte = bytes[i++] & 0xFF;
            base32.append(base32Chars.charAt(digit | currByte >> 5));
            base32.append(base32Chars.charAt(currByte & 0x1F));
        }
        return base32.toString();
    }

    public static byte[] decode(String base32) throws IllegalArgumentException {
        switch (base32.length() % 8) {
            case 1: 
            case 3: 
            case 6: {
                throw new IllegalArgumentException(errorCanonicalLength);
            }
        }
        byte[] bytes = new byte[base32.length() * 5 / 8];
        int offset = 0;
        int i = 0;
        while (i < base32.length()) {
            int lookup;
            if ((lookup = base32.charAt(i++) - 50) < 0 || lookup >= base32Lookup.length) {
                throw new IllegalArgumentException(errorInvalidChar);
            }
            byte digit = base32Lookup[lookup];
            if (digit == -1) {
                throw new IllegalArgumentException(errorInvalidChar);
            }
            byte nextByte = (byte)(digit << 3);
            if ((lookup = base32.charAt(i++) - 50) < 0 || lookup >= base32Lookup.length) {
                throw new IllegalArgumentException(errorInvalidChar);
            }
            digit = base32Lookup[lookup];
            if (digit == -1) {
                throw new IllegalArgumentException(errorInvalidChar);
            }
            bytes[offset++] = (byte)(nextByte | digit >> 2);
            nextByte = (byte)((digit & 3) << 6);
            if (i >= base32.length()) {
                if (nextByte == 0) break;
                throw new IllegalArgumentException(errorCanonicalEnd);
            }
            if ((lookup = base32.charAt(i++) - 50) < 0 || lookup >= base32Lookup.length) {
                throw new IllegalArgumentException(errorInvalidChar);
            }
            digit = base32Lookup[lookup];
            if (digit == -1) {
                throw new IllegalArgumentException(errorInvalidChar);
            }
            nextByte = (byte)(nextByte | (byte)(digit << 1));
            if ((lookup = base32.charAt(i++) - 50) < 0 || lookup >= base32Lookup.length) {
                throw new IllegalArgumentException(errorInvalidChar);
            }
            digit = base32Lookup[lookup];
            if (digit == -1) {
                throw new IllegalArgumentException(errorInvalidChar);
            }
            bytes[offset++] = (byte)(nextByte | digit >> 4);
            nextByte = (byte)((digit & 0xF) << 4);
            if (i >= base32.length()) {
                if (nextByte == 0) break;
                throw new IllegalArgumentException(errorCanonicalEnd);
            }
            if ((lookup = base32.charAt(i++) - 50) < 0 || lookup >= base32Lookup.length) {
                throw new IllegalArgumentException(errorInvalidChar);
            }
            digit = base32Lookup[lookup];
            if (digit == -1) {
                throw new IllegalArgumentException(errorInvalidChar);
            }
            bytes[offset++] = (byte)(nextByte | digit >> 1);
            nextByte = (byte)((digit & 1) << 7);
            if (i >= base32.length()) {
                if (nextByte == 0) break;
                throw new IllegalArgumentException(errorCanonicalEnd);
            }
            if ((lookup = base32.charAt(i++) - 50) < 0 || lookup >= base32Lookup.length) {
                throw new IllegalArgumentException(errorInvalidChar);
            }
            digit = base32Lookup[lookup];
            if (digit == -1) {
                throw new IllegalArgumentException(errorInvalidChar);
            }
            nextByte = (byte)(nextByte | (byte)(digit << 2));
            if ((lookup = base32.charAt(i++) - 50) < 0 || lookup >= base32Lookup.length) {
                throw new IllegalArgumentException(errorInvalidChar);
            }
            digit = base32Lookup[lookup];
            if (digit == -1) {
                throw new IllegalArgumentException(errorInvalidChar);
            }
            bytes[offset++] = (byte)(nextByte | digit >> 3);
            nextByte = (byte)((digit & 7) << 5);
            if (i >= base32.length()) {
                if (nextByte == 0) break;
                throw new IllegalArgumentException(errorCanonicalEnd);
            }
            if ((lookup = base32.charAt(i++) - 50) < 0 || lookup >= base32Lookup.length) {
                throw new IllegalArgumentException(errorInvalidChar);
            }
            digit = base32Lookup[lookup];
            if (digit == -1) {
                throw new IllegalArgumentException(errorInvalidChar);
            }
            bytes[offset++] = (byte)(nextByte | digit);
        }
        return bytes;
    }
}

