/*
 * Decompiled with CFR 0.152.
 */
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.Statistics;
import com.limegroup.gnutella.settings.SettingsHandler;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.CommonUtils;
import java.io.File;

public class AqMain {
    public static Thread cThread;
    public static Thread tThread;
    public static Thread dThread;
    public static Thread gcThread;
    public static Thread dispatchThread;
    public static boolean coreHasStarted;

    public static void main(String[] args) {
        new Thread(new ReaderThread()).start();
        System.err.println(CommonUtils.getVendor());
        if (!CommonUtils.getUserSettingsDir().exists()) {
            CommonUtils.getUserSettingsDir().mkdirs();
        }
        new RouterService(new AqEventHandler()).start();
        gcThread = new Thread(new GCThread());
        cThread = new Thread(new ConnectionUpdate());
        tThread = new Thread(new TransferUpdate());
        dThread = new Thread(new DownloadRetry());
        dispatchThread = new Thread(new DispatchThread());
        cThread.setDaemon(true);
        tThread.setDaemon(true);
        dThread.setDaemon(true);
        gcThread.setDaemon(true);
        dispatchThread.setDaemon(true);
        cThread.start();
        tThread.start();
        dThread.start();
        gcThread.start();
        dispatchThread.start();
        coreHasStarted = true;
    }

    public static void cleanIncompleteDirectory() throws Exception {
        File incompleteDir = SharingSettings.INCOMPLETE_DIRECTORY.getValue();
        String[] files = incompleteDir.list();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File f = new File(incompleteDir, files[i]);
                if (files[i].startsWith("Preview-")) {
                    f.delete();
                    continue;
                }
                if (f.length() != 0L) continue;
                f.delete();
            }
        }
    }

    public static void shutdown() {
        try {
            System.err.println("AqMain: shutdown() A");
            AqMain.cleanIncompleteDirectory();
            Statistics.instance().shutdown();
            RouterService.getHostCatcher().write();
            SettingsHandler.save();
            System.err.println("AqMain: shutdown() B");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        coreHasStarted = false;
    }
}

