/*
 * Decompiled with CFR 0.152.
 */
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.browser.ExternalControl;
import com.limegroup.gnutella.downloader.AlreadyDownloadingException;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.DownloadSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.settings.UltrapeerSettings;
import com.limegroup.gnutella.settings.UploadSettings;
import java.io.File;
import java.util.Iterator;
import java.util.Vector;

public class AqDispatcher {
    public static void dispatchCommand(Vector v) throws Exception {
        String command = (String)v.elementAt(0);
        if (command.equals("handleMagnet")) {
            System.err.println(v);
            ExternalControl.handleMagnetRequest((String)v.elementAt(1));
        }
        if (command.equals("setEnableUltrapeer")) {
            int value = new Integer((String)v.elementAt(1));
            System.err.println(v);
            UltrapeerSettings.DISABLE_ULTRAPEER_MODE.setValue(value == 0);
            return;
        }
        if (command.equals("setFilterUnf")) {
            int value = new Integer((String)v.elementAt(1));
            System.err.println(v);
            ConnectionSettings.FILTER_UNF.setValue(value == 1);
            return;
        }
        if (command.equals("query")) {
            String queryString = (String)v.elementAt(1);
            System.err.println(v);
            GUID guid = new GUID(RouterService.queryWithString2(queryString));
            AqEventHandler.queries.add(guid.toString());
            return;
        }
        if (command.equals("download")) {
            RemoteFileDesc[] files = new RemoteFileDesc[v.size() - 1];
            String name = null;
            for (int i = 1; i < v.size(); ++i) {
                files[i - 1] = (RemoteFileDesc)AqEventHandler.responses.elementAt(new Integer((String)v.elementAt(i)));
                if (name != null) continue;
                name = files[i - 1].getFileName();
            }
            try {
                RouterService.download(files, true);
            }
            catch (AlreadyDownloadingException e) {
                // empty catch block
            }
            return;
        }
        if (command.equals("retryDownload")) {
            System.err.println(v);
            int index = new Integer((String)v.elementAt(1));
            Downloader d = (Downloader)AqEventHandler.downloads.get(index);
            d.resume();
            return;
        }
        if (command.equals("requeryDownload")) {
            System.err.println(v);
            int index = new Integer((String)v.elementAt(1));
            ManagedDownloader d = (ManagedDownloader)AqEventHandler.downloads.get(index);
            d.sendRequery();
            return;
        }
        if (command.equals("cancelDownload")) {
            int index = new Integer((String)v.elementAt(1));
            Downloader d = (Downloader)AqEventHandler.downloads.get(index);
            d.stop();
            return;
        }
        if (command.equals("cancelUpload")) {
            Iterator i = RouterService.getUploadManager().getUploads().iterator();
            while (i.hasNext()) {
                Uploader u = (Uploader)i.next();
                if (!u.getHost().equals(v.elementAt(1)) || !u.getFileName().equals(v.elementAt(2))) continue;
                u.stop();
            }
            return;
        }
        if (command.equals("setMaxUploads")) {
            int value = new Integer((String)v.elementAt(1));
            UploadSettings.MAX_UPLOADS.setValue(value);
            return;
        }
        if (command.equals("setUploadsPerPerson")) {
            int value = new Integer((String)v.elementAt(1));
            UploadSettings.UPLOADS_PER_PERSON.setValue(value);
            return;
        }
        if (command.equals("setUploadSpeed")) {
            int value = new Integer((String)v.elementAt(1));
            UploadSettings.UPLOAD_SPEED.setValue(value);
            return;
        }
        if (command.equals("closeConnection")) {
            String host = (String)v.elementAt(1);
            Iterator i = RouterService.getConnectionManager().getConnections().iterator();
            while (i.hasNext()) {
                Connection c = (Connection)i.next();
                if (!c.getIPString().equals(host)) continue;
                c.close();
            }
            return;
        }
        if (command.equals("setKeepAlive")) {
            int value = new Integer((String)v.elementAt(1));
            if (RouterService.getConnectionManager().getKeepAlive() != value) {
                RouterService.getConnectionManager().setKeepAlive(value);
            }
            return;
        }
        if (command.equals("setConnectionSpeed")) {
            int value = new Integer((String)v.elementAt(1));
            ConnectionSettings.CONNECTION_SPEED.setValue(value);
            return;
        }
        if (command.equals("setPort")) {
            int value = new Integer((String)v.elementAt(1));
            ConnectionSettings.PORT.setValue(value);
            RouterService.setListeningPort(value);
            return;
        }
        if (command.equals("doBrowseHost")) {
            final String host = (String)v.elementAt(1);
            final int port = new Integer((String)v.elementAt(2));
            final GUID serventID = (GUID)AqEventHandler.hosts.get(host + port);
            final GUID queryGUID = new GUID(RouterService.newQueryGUID());
            AqEventHandler.queries.add(queryGUID.toString());
            new Thread(){

                public void run() {
                    RouterService.doBrowseHost(host, port, queryGUID, serventID, null);
                }
            }.start();
            return;
        }
        if (command.equals("setDirectories")) {
            SharingSettings.setDirectoriesWithString((String)v.elementAt(1));
            System.err.println(v);
            RouterService.getFileManager().loadSettings(false);
            return;
        }
        if (command.equals("setSaveDirectory")) {
            String value = (String)v.elementAt(1);
            SharingSettings.DIRECTORY_FOR_SAVING_FILES.setValue(new File(value));
            SharingSettings.INCOMPLETE_DIRECTORY.setValue(new File(SharingSettings.DIRECTORY_FOR_SAVING_FILES.getValue(), "Incomplete"));
            return;
        }
        if (command.equals("setIncompleteDirectory")) {
            String value = (String)v.elementAt(1);
            SharingSettings.INCOMPLETE_DIRECTORY.setValue(new File(value));
            return;
        }
        if (command.equals("setMaxSimDownload")) {
            int value = new Integer((String)v.elementAt(1));
            DownloadSettings.MAX_SIM_DOWNLOAD.setValue(value);
            return;
        }
    }
}

