//
//  PToolbarCategory.m
// -------------------------------------------------------------------------
// Copyright (C) 2003 Poisoned Project (http://www.gottsilla.net/)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// ---------------------------------------------------------------------------

#import "PToolbarCategory.h"

@implementation PMainController (PToolbarCategory)

- (void)initToolbar
{
    if (!toolbarDefaultItems) {
        toolbarDefaultItems = [[NSArray alloc] initWithObjects:
            [NSArray arrayWithObjects:
                @"navigation",@"drawer",NSToolbarSeparatorItemIdentifier,
                @"giFTConnect",NSToolbarFlexibleSpaceItemIdentifier,@"giFTLaunch",nil],
            [NSArray arrayWithObjects:
                @"navigation",@"drawer",NSToolbarSeparatorItemIdentifier,
                @"searchBrowse",/*@"iTMS",*/@"searchDownload",@"searchField",@"searchRealm",@"searchStop",nil],
            [NSArray arrayWithObjects:
                @"navigation",@"drawer",NSToolbarSeparatorItemIdentifier,
                @"downCancel",@"downPause",@"downResume",NSToolbarSeparatorItemIdentifier,
                @"downPreview",@"downDelSource",@"downBrowseHost",NSToolbarSeparatorItemIdentifier,
                @"downClean",
                NSToolbarFlexibleSpaceItemIdentifier,@"downExpand",@"downCollapse",nil],
            [NSArray arrayWithObjects:
                @"navigation",@"drawer",NSToolbarSeparatorItemIdentifier,
                @"upCancel",
                @"upBrowseHost",NSToolbarSeparatorItemIdentifier,
                @"upClean",nil],
            nil];
    }
    if (![userDefaults objectForKey:@"MyToolbarItems"]) {
        // if not yet configured, set default items...
        [userDefaults setObject:toolbarDefaultItems forKey:@"MyToolbarItems"];
    }
    if (!toolbarAllowedItems) {
        toolbarAllowedItems = [[NSArray alloc] initWithObjects:
            [NSArray arrayWithObjects:
                @"navigation",@"drawer",
                @"giFTConnect",@"giFTLaunch",nil],
            [NSArray arrayWithObjects:
                @"navigation",@"drawer",
                @"searchField",@"searchRealm",@"searchBrowse",@"searchDownload",@"searchStop",@"iTMS",nil],
            [NSArray arrayWithObjects:@"navigation",@"drawer",
                @"downExpand",@"downCollapse",
                @"downPreview",@"downCancel",@"downPause",@"downResume",@"downDelSource",@"downBrowseHost",@"downClean",nil],
            [NSArray arrayWithObjects:
                @"navigation",@"drawer",
                @"upCancel",@"upBrowseHost",@"upClean",nil],
            [NSArray arrayWithObjects:NSToolbarFlexibleSpaceItemIdentifier,
                                NSToolbarSpaceItemIdentifier,
                                NSToolbarSeparatorItemIdentifier,
                                nil],
            nil];
    }
    toolbar = [[NSToolbar alloc] initWithIdentifier:@"mainToolbar"];
    [toolbar setAllowsUserCustomization:YES];
    [toolbar setAutosavesConfiguration:YES];
    [toolbar setDelegate:self];
    if (currentView>-1) [mainWindow setToolbar:toolbar];
}

- (NSArray *)toolbarAllowedItemIdentifiers:(NSToolbar*)toolbar
{
    if (currentView>-1) return
        [[NSArray arrayWithArray:[toolbarAllowedItems objectAtIndex:currentView]]
                arrayByAddingObjectsFromArray:[toolbarAllowedItems objectAtIndex:4]
        ];
    else return nil;
}

- (NSArray *)toolbarDefaultItemIdentifiers:(NSToolbar*)toolbar
{
    if (currentView>-1) return [toolbarDefaultItems objectAtIndex:currentView];
    else return nil;
}

- (NSToolbarItem *)toolbar:(NSToolbar *)toolbar itemForItemIdentifier:(NSString *)itemIdentifier willBeInsertedIntoToolbar:(BOOL)flag
{
    NSToolbarItem *item = [[NSToolbarItem alloc] initWithItemIdentifier:itemIdentifier];
    [item setEnabled:NO];
    if ([itemIdentifier isEqualToString:@"navigation"]) {
        [item setLabel:NSLocalizedStringFromTable(@"Navigation",@"Toolbar",nil)];
        [item setPaletteLabel:NSLocalizedStringFromTable(@"Navigation",@"Toolbar",nil)];
        [item setView:navigation];
        [item setMinSize:NSMakeSize(109,25)];
        [item setMaxSize:NSMakeSize(109,32)];
        [item setEnabled:YES];
    }
    if ([itemIdentifier isEqualToString:@"drawer"]) {
        [item setLabel:NSLocalizedStringFromTable(@"Drawer",@"Toolbar",nil)];
        [item setPaletteLabel:NSLocalizedStringFromTable(@"Drawer",@"Toolbar",nil)];
        [item setView:drawerButton];
        [item setMinSize:NSMakeSize(32,29)];
        [item setMaxSize:NSMakeSize(32,32)];
        [item setEnabled:YES];
        [item setToolTip:NSLocalizedStringFromTable(@"Toggle drawer",@"Toolbar",nil)];
    }
    else if ([itemIdentifier isEqualToString:@"giFTConnect"]) {
        [item setLabel:NSLocalizedStringFromTable(@"Connect",@"Toolbar",nil)];
        [item setPaletteLabel:NSLocalizedStringFromTable(@"Connect",@"Toolbar",nil)];
        [item setToolTip:NSLocalizedStringFromTable(@"Connect to the giFT daemon",@"Toolbar",nil)];
        [item setImage:[NSImage imageNamed:@"connect.tiff"]];
        [item setTarget:giFT];
        [item setAction:@selector(connect:)];
    }
    else if ([itemIdentifier isEqualToString:@"giFTLaunch"]) {
        [item setLabel:NSLocalizedStringFromTable(@"Launch giFT",@"Toolbar",nil)];
        [item setPaletteLabel:NSLocalizedStringFromTable(@"Launch giFT",@"Toolbar",nil)];
        [item setToolTip:NSLocalizedStringFromTable(@"Launch the giFT daemon",@"Toolbar",nil)];
        [item setImage:[NSImage imageNamed:@"startgift.tiff"]];
        [item setTarget:giFT];
        [item setAction:@selector(launch:)];
    }
    else if ([itemIdentifier isEqualToString:@"searchField"]) {
        [item setLabel:NSLocalizedStringFromTable(@"Search",@"Toolbar",nil)];
        [item setPaletteLabel:NSLocalizedStringFromTable(@"Search",@"Toolbar",nil)];
        [item setView:toolbarSearch];
        [item setMinSize:NSMakeSize(100,25)];
        [item setMaxSize:NSMakeSize(2000,32)];
        [item setToolTip:NSLocalizedStringFromTable(@"Begin Search Here",@"Toolbar",nil)];
        [item setEnabled:YES];

    }
    else if ([itemIdentifier isEqualToString:@"searchRealm"]) {
        [item setLabel:NSLocalizedStringFromTable(@"Realm",@"Toolbar",nil)];
        [item setPaletteLabel:NSLocalizedStringFromTable(@"Realm",@"Toolbar",nil)];
        [item setView:toolbarSearchRealm];
        [item setMinSize:NSMakeSize(97,25)];
        [item setMaxSize:NSMakeSize(97,32)];
        [item setEnabled:YES];
    }
    else if ([itemIdentifier isEqualToString:@"searchDownload"]) {
        [item setLabel:NSLocalizedStringFromTable(@"Download",@"Toolbar",nil)];
        [item setPaletteLabel:NSLocalizedStringFromTable(@"Download",@"Toolbar",nil)];
        [item setImage:[currentTool objectForKey:@"download"]];
        [item setTarget:search];
        [item setAction:@selector(download:)];
        [item setToolTip:NSLocalizedStringFromTable(@"Download selected item(s)",@"Toolbar",nil)];
    }
    else if ([itemIdentifier isEqualToString:@"searchBrowse"]) {
        [item setLabel:NSLocalizedStringFromTable(@"Browse",@"Toolbar",nil)];
        [item setPaletteLabel:NSLocalizedStringFromTable(@"Browse",@"Toolbar",nil)];
        [item setImage:[NSImage imageNamed:@"browse.tiff"]];
        [item setTarget:search];
        [item setAction:@selector(browse:)];
        [item setToolTip:NSLocalizedStringFromTable(@"View shared files of the selected user",@"Toolbar",nil)];
    }
    else if ([itemIdentifier isEqualToString:@"searchStop"]) {
        [item setLabel:NSLocalizedStringFromTable(@"Stop Search",@"Toolbar",nil)];
        [item setPaletteLabel:NSLocalizedStringFromTable(@"Stop Search",@"Toolbar",nil)];
        [item setImage:[currentTool objectForKey:@"stop"]];
        [item setTarget:search];
        [item setAction:@selector(stop:)];
        [item setToolTip:NSLocalizedStringFromTable(@"Stop the currently viewed search",@"Toolbar",nil)];
    }
    else if ([itemIdentifier isEqualToString:@"downCancel"]) {
        [item setLabel:NSLocalizedStringFromTable(@"Cancel",@"Toolbar",nil)];
        [item setPaletteLabel:NSLocalizedStringFromTable(@"Cancel",@"Toolbar",nil)];
        [item setImage:[currentTool objectForKey:@"cancel"]];
        [item setTarget:download];
        [item setAction:@selector(cancel:)];
        [item setToolTip:NSLocalizedStringFromTable(@"Cancel selected download(s)",@"Toolbar",nil)];
    }
    else if ([itemIdentifier isEqualToString:@"downResume"]) {
        [item setLabel:NSLocalizedStringFromTable(@"Resume",@"Toolbar",nil)];
        [item setPaletteLabel:NSLocalizedStringFromTable(@"Resume",@"Toolbar",nil)];
        [item setImage:[currentTool objectForKey:@"resume"]];
        [item setTarget:download];
        [item setAction:@selector(resume:)];
        [item setToolTip:NSLocalizedStringFromTable(@"Resume selected download(s)",@"Toolbar",nil)];
    }
    else if ([itemIdentifier isEqualToString:@"downPause"]) {
        [item setLabel:NSLocalizedStringFromTable(@"Pause",@"Toolbar",nil)];
        [item setPaletteLabel:NSLocalizedStringFromTable(@"Pause",@"Toolbar",nil)];
        [item setImage:[currentTool objectForKey:@"pause"]];
        [item setTarget:download];
        [item setAction:@selector(pause:)];
        [item setToolTip:NSLocalizedStringFromTable(@"Pause selected download(s)",@"Toolbar",nil)];
    }
    else if ([itemIdentifier isEqualToString:@"downDelSource"]) {
        [item setLabel:NSLocalizedStringFromTable(@"Cancel Source",@"Toolbar",nil)];
        [item setPaletteLabel:NSLocalizedStringFromTable(@"Cancel Source",@"Toolbar",nil)];
        [item setImage:[NSImage imageNamed:@"delsource.tiff"]];
        [item setTarget:download];
        [item setAction:@selector(delsource:)];
        [item setToolTip:NSLocalizedStringFromTable(@"Cancel selected source(s)",@"Toolbar",nil)];
    }
    else if ([itemIdentifier isEqualToString:@"downBrowseHost"]) {
        [item setLabel:NSLocalizedStringFromTable(@"Browse Host",@"Toolbar",nil)];
        [item setPaletteLabel:NSLocalizedStringFromTable(@"Browse Host",@"Toolbar",nil)];
        [item setImage:[NSImage imageNamed:@"browse.tiff"]];
        [item setTarget:self];
        [item setAction:@selector(downbrowsehost:)];
        [item setToolTip:NSLocalizedStringFromTable(@"View shared files of the selected user",@"Toolbar",nil)];
    }
    else if ([itemIdentifier isEqualToString:@"downClean"]) {
        [item setLabel:NSLocalizedStringFromTable(@"Clean Up",@"Toolbar",nil)];
        [item setPaletteLabel:NSLocalizedStringFromTable(@"Clean Up",@"Toolbar",nil)];
        [item setImage:[NSImage imageNamed:@"clean.tiff"]];
        [item setTarget:download];
        [item setAction:@selector(cleanUp:)];
        [item setToolTip:NSLocalizedStringFromTable(@"Remove completed and cancelled downloads",@"Toolbar",nil)];
    }
    else if ([itemIdentifier isEqualToString:@"downExpand"]) {
        [item setLabel:NSLocalizedStringFromTable(@"Expand All",@"Toolbar",nil)];
        [item setPaletteLabel:NSLocalizedStringFromTable(@"Expand All",@"Toolbar",nil)];
        [item setImage:[NSImage imageNamed:@"expand.tiff"]];
        [item setTarget:download];
        [item setAction:@selector(expand:)];
        [item setToolTip:NSLocalizedStringFromTable(@"Expand all items",@"Toolbar",nil)];
    }
    else if ([itemIdentifier isEqualToString:@"downCollapse"]) {
        [item setLabel:NSLocalizedStringFromTable(@"Collapse All",@"Toolbar",nil)];
        [item setPaletteLabel:NSLocalizedStringFromTable(@"Collapse All",@"Toolbar",nil)];
        [item setImage:[NSImage imageNamed:@"collapse.tiff"]];
        [item setTarget:download];
        [item setAction:@selector(collapse:)];
        [item setToolTip:NSLocalizedStringFromTable(@"Collapse all items",@"Toolbar",nil)];
    }
    else if ([itemIdentifier isEqualToString:@"upCancel"]) {
        [item setLabel:NSLocalizedStringFromTable(@"Cancel",@"Toolbar",nil)];
        [item setPaletteLabel:NSLocalizedStringFromTable(@"Cancel",@"Toolbar",nil)];
        [item setImage:[currentTool objectForKey:@"cancel"]];
        [item setTarget:upload];
        [item setAction:@selector(cancel:)];
        [item setToolTip:NSLocalizedStringFromTable(@"Cancel selected upload(s)",@"Toolbar",nil)];
    }
    else if ([itemIdentifier isEqualToString:@"upBrowseHost"]) {
        [item setLabel:NSLocalizedStringFromTable(@"Browse Host",@"Toolbar",nil)];
        [item setPaletteLabel:NSLocalizedStringFromTable(@"Browse Host",@"Toolbar",nil)];
        [item setImage:[NSImage imageNamed:@"browse.tiff"]];
        [item setTarget:self];
        [item setAction:@selector(upbrowsehost:)];
        [item setToolTip:NSLocalizedStringFromTable(@"View shared files of the selected user",@"Toolbar",nil)];
    }
    else if ([itemIdentifier isEqualToString:@"upClean"]) {
        [item setLabel:NSLocalizedStringFromTable(@"Clean Up",@"Toolbar",nil)];
        [item setPaletteLabel:NSLocalizedStringFromTable(@"Clean Up",@"Toolbar",nil)];
        [item setImage:[NSImage imageNamed:@"clean.tiff"]];
        [item setTarget:upload];
        [item setAction:@selector(cleanUp:)];
        [item setToolTip:NSLocalizedStringFromTable(@"Remove completed and cancelled uploads",@"Toolbar",nil)];
    }
    else if ([itemIdentifier isEqualToString:@"downPreview"]) {
        [item setLabel:NSLocalizedStringFromTable(@"Preview",@"Toolbar",nil)];
        [item setPaletteLabel:NSLocalizedStringFromTable(@"Preview",@"Toolbar",nil)];
        [item setImage:[NSImage imageNamed:@"iTMS.tiff"]];
        [item setTarget:download];
        [item setAction:@selector(previewFile:)];
        [item setToolTip:NSLocalizedStringFromTable(@"Preview this download",@"Toolbar",nil)];
    }
    else if ([itemIdentifier isEqualToString:@"iTMS"]) {
        [item setLabel:NSLocalizedStringFromTable(@"Buy",@"Toolbar",nil)];
        [item setPaletteLabel:NSLocalizedStringFromTable(@"Buy",@"Toolbar",nil)];
        [item setImage:[NSImage imageNamed:@"iTMS.tiff"]];
        [item setTarget:search];
        [item setAction:@selector(buyAtiTMS:)];
        [item setToolTip:NSLocalizedStringFromTable(@"Buy at the iTunes Music Store",@"Toolbar",nil)];
    }
    return [item autorelease];
}

- (void)switchToolbarConfigurationTo:(int)conf
{
    [self saveToolbarConfiguration];
    NSMutableDictionary *dict = [NSMutableDictionary dictionaryWithDictionary:[toolbar configurationDictionary]];
    [dict setObject:[[userDefaults arrayForKey:@"MyToolbarItems"] objectAtIndex:conf] forKey:@"TB Item Identifiers"];
    [toolbar setConfigurationFromDictionary:dict];
    currentView = conf;
}

- (void)saveToolbarConfiguration
{
    if (currentView==-1) return;
    NSMutableArray *conf = [NSMutableArray arrayWithArray:[userDefaults arrayForKey:@"MyToolbarItems"]];
    [conf replaceObjectAtIndex:currentView withObject:[[toolbar configurationDictionary] objectForKey:@"TB Item Identifiers"]];
    [userDefaults setObject:conf forKey:@"MyToolbarItems"];
}

- (void)validate;
{
    [toolbar validateVisibleItems];
}

@end
