import os
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from PyQt4 import uic

form_class, base_class = uic.loadUiType(
        os.path.join(
            "plugins","extractionTabs","extractionConfigDialog.ui"))
class ExtractionConfigDialog(base_class, form_class):
    def __init__(self, tabId, *args):
        base_class.__init__(self, *args)

        self.setupUi(self)

        self.settings = QSettings("Twitturn")
        self.tabId = tabId
        self.connectActions()

        self.loadSettings()

    def connectActions(self):
        pass

    def accept(self):
        base_class.accept(self)
        self.saveSettings()

    def loadSettings(self):
        self.settings.beginGroup("plugins/extractionTabs/tabs/"+QString.number(self.tabId+1))

        self.lineEditTabName.setText(
                self.settings.value("tabName").toString())
        self.comboBoxNick.setCurrentIndex(
                self.settings.value("comboBoxNick").toInt()[0])
        self.checkBoxNick.setChecked(
                self.settings.value("checkBoxNick").toBool())
        self.textEditNick.setText(
                self.settings.value("textEditNick").toString())
        self.comboBoxText.setCurrentIndex(
                self.settings.value("comboBoxText").toInt()[0])
        self.checkBoxText.setChecked(
                self.settings.value("checkBoxText").toBool())
        self.textEditText.setText(
                self.settings.value("textEditText").toString())
        self.settings.endGroup()

    def saveSettings(self):
        self.settings.beginGroup("plugins/extractionTabs/tabs/"+QString.number(self.tabId+1))

        self.settings.setValue("configured", QVariant(True))
        self.settings.setValue("tabName",
                QVariant(self.lineEditTabName.text()))
        self.settings.setValue("comboBoxNick",
                QVariant(self.comboBoxNick.currentIndex()))
        self.settings.setValue("checkBoxNick",
                QVariant(self.checkBoxNick.isChecked()))
        self.settings.setValue("textEditNick",
                QVariant(self.textEditNick.toPlainText()))
        self.settings.setValue("comboBoxText",
                QVariant(self.comboBoxText.currentIndex()))
        self.settings.setValue("checkBoxText",
                QVariant(self.checkBoxText.isChecked()))
        self.settings.setValue("textEditText",
                QVariant(self.textEditText.toPlainText()))

        self.settings.endGroup()

