#!/usr/bin/env python
import sys
from PyQt4 import QtCore, QtGui, uic


form_class, base_class = uic.loadUiType("mainwindowTable.ui")


class Twitturn(base_class, form_class):
    def __init__(self, *args):
        base_class.__init__(self, *args)

        self.setupUi(self)

        self.iconCache = {}
       # self.config = Config()
        self.connectActions()
        self.fillSamplePosts()
        self.setUpTableWidget()

    def connectActions(self):
        self.connect(self.actionFocus_Imput_Erea, QtCore.SIGNAL("triggered()"),
                self.textEdit, QtCore.SLOT("setFocus()"))
        self.connect(self.action_Quit, QtCore.SIGNAL("triggered()"),
                QtGui.qApp, QtCore.SLOT("quit()"))
        self.connect(self.actionSelect_Top, QtCore.SIGNAL("triggered()"),
                self.selectTopPost)
#        self.connect(self.tableWidget, QtCore.SIGNAL("itemSelectionChanged()"),
#                self.setSelectedPost)

    def selectTopPost(self):
        #self.tableWidget.
        print 'selectTopPost()'

    def setSelectedPost(self):
        print 'setSelectedPost()'
        self.selectedPosts = self.tableWidget.selectedItems()
#        print self.selectedPosts[0][0]
#        self.textBrowser.setDocument(self.selectedPosts[0][2])
    def setUpTableWidget(self):
        vh = self.tableWidget.verticalHeader()
        #vh.hide()
        #vh.setResizeMode(QtGui.QHeaderView.Fixed)
        vh.setDefaultSectionSize(1000)
    def fillSamplePosts(self):
        p1 = [
                ['loader.gif','j','hazxcbzxcbzxc', 
                    '2008/03/11 13:33:59', 'F', 'False'],
                ['twitter_57.png','i','ihogehoge', 
                    '2008/03/11 13:33:01', "T", 'False'],
                ['loader.gif','j','hohohoge', 
                    '2008/03/11 13:30:02', 'F', 'True'],
                ['loader.gif','j','hohohohh',
                    '2008/03/11 13:30:00', 'F', 'False']
                ]
        for post in p1:
            self.tableWidget.insertRow(0)
            for i, v in enumerate(post):
                if i==0:
                    if not self.iconCache.has_key(v):
                        icon = QtGui.QIcon("/home/yu/work/twitturn2/images/"+v)
                        if icon.isNull():
                            print "Icon cache Failed. Should network fetch"
                        else:
                            self.iconCache[v] = icon
                    self.tableWidget.setItem(0,i,
                            QtGui.QTableWidgetItem(self.iconCache[v],""))
                else:
                    self.tableWidget.setItem(0,i,QtGui.QTableWidgetItem(v))

if __name__=="__main__":
    app = QtGui.QApplication(sys.argv)
    form = Twitturn()
    form.show()
    app.exec_()
