﻿'Copyright (C) 2010 pepetaro, All rights reserved.
'This library is free software; you can redistribute it and/or
'modify it under the terms of the GNU Lesser General Public
'License as published by the Free Software Foundation; either
'version 3 of the License, or (at your option) any later version.

'This library is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'Lesser General Public License for more details.

'You should have received a copy of the GNU Lesser General Public
'License along with this library; if not, write to the Free Software
'Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

Namespace TwitterServices
    ''' <summary>ユーザー情報を操作します。</summary>
    Public Class UsersService
        <DebuggerBrowsable(DebuggerBrowsableState.Never)> Dim tw As Twitter
        Friend Sub New(ByVal tw As Twitter)
            Me.tw = tw
        End Sub

        ''' <summary>指定したユーザーの情報を取得します。</summary>
        ''' <param name="id">取得するユーザーのscreen_nameまたはid</param>
        Public Function GetUser(ByVal id As String) As TwitterUser
            Dim param As New Dictionary(Of String, String)
            param.Add("id", id)
            Dim stream = tw.GetStream(Twitter.CreateUri(1, "users/show.xml"), "GET", param, Nothing)

            Dim doc As New XmlDocument
            doc.Load(stream)
            stream.Close()
            Return TwitterUser.FromXml(doc)
        End Function

        ''' <summary>
        ''' フォロワーのIDを取得します。
        ''' </summary>
        ''' <param name="id">取得元のユーザーのscreen_nameまたはid</param>
        ''' <param name="cursor">カーソル位置</param>
        ''' <param name="resultCursor">Twitterから返されたCursor情報</param>
        Public Overloads Function GetFollowerIds(ByVal id As String, ByVal cursor As Long, <Out()> ByRef resultCursor As CursorResult) As IEnumerable(Of Long)
            Dim param As New Dictionary(Of String, String)
            param.Add("id", id)
            param.Add("cursor", cursor.ToString)
            Dim stream = tw.GetStream(Twitter.CreateUri(1, "followers/ids.xml"), "GET", param, Nothing)
            Dim xd As New XmlDocument
            xd.Load(stream)
            stream.Close()
            resultCursor.NextCursor = Long.Parse(xd.SelectSingleNode("/id_list/next_cursor").InnerText)
            resultCursor.PreviousCursor = Long.Parse(xd.SelectSingleNode("/id_list/previous_cursor").InnerText)
            Dim re As New List(Of Long)
            For Each o As XmlNode In xd.GetElementsByTagName("id")
                re.Add(Long.Parse(o.InnerText))
            Next
            Return re
        End Function
        ''' <summary>
        ''' 自分のフォロワーのIDを取得します。
        ''' </summary>
        ''' <param name="cursor">カーソル位置</param>
        ''' <param name="resultCursor">Twitterから返されたCursor情報</param>
        Public Overloads Function GetFollowerIds(ByVal cursor As Long, <Out()> ByRef resultCursor As CursorResult) As IEnumerable(Of Long)
            Dim param As New Dictionary(Of String, String)
            param.Add("cursor", cursor.ToString)
            Dim stream = tw.GetStream(Twitter.CreateUri(1, "followers/ids.xml"), "GET", param, Nothing)
            Dim xd As New XmlDocument
            xd.Load(stream)
            stream.Close()
            resultCursor.NextCursor = Long.Parse(xd.SelectSingleNode("/id_list/next_cursor").InnerText)
            resultCursor.PreviousCursor = Long.Parse(xd.SelectSingleNode("/id_list/previous_cursor").InnerText)
            Dim re As New List(Of Long)
            For Each o As XmlNode In xd.GetElementsByTagName("id")
                re.Add(Long.Parse(o.InnerText))
            Next
            Return re
        End Function

        ''' <summary>
        ''' フレンド（フォロー中）のIDを取得します。
        ''' </summary>
        ''' <param name="id">取得元のユーザーのscreen_nameまたはid</param>
        ''' <param name="cursor">カーソル位置</param>
        Public Overloads Function GetFriendIds(ByVal id As String, ByVal cursor As Long, <Out()> ByRef resultCursor As CursorResult) As IEnumerable(Of Long)
            Dim param As New Dictionary(Of String, String)
            param.Add("id", id)
            param.Add("cursor", cursor.ToString)
            Dim stream = tw.GetStream(Twitter.CreateUri(1, "friends/ids.xml"), "GET", param, Nothing)
            Dim xd As New XmlDocument
            xd.Load(stream)
            stream.Close()
            resultCursor.NextCursor = Long.Parse(xd.SelectSingleNode("/id_list/next_cursor").InnerText)
            resultCursor.PreviousCursor = Long.Parse(xd.SelectSingleNode("/id_list/previous_cursor").InnerText)
            Dim re As New List(Of Long)
            For Each o As XmlNode In xd.GetElementsByTagName("id")
                re.Add(Long.Parse(o.InnerText))
            Next
            Return re
        End Function
        ''' <summary>
        ''' 自分のフレンド（フォロー中）のIDを取得します。
        ''' </summary>
        ''' <param name="cursor">カーソル位置</param>
        ''' <param name="resultCursor">Twitterから返されたCursor情報</param>
        Public Overloads Function GetFriendIds(ByVal cursor As Long, <Out()> ByRef resultCursor As CursorResult) As IEnumerable(Of Long)
            Dim param As New Dictionary(Of String, String)
            param.Add("cursor", cursor.ToString)
            Dim stream = tw.GetStream(Twitter.CreateUri(1, "friends/ids.xml"), "GET", param, Nothing)
            Dim xd As New XmlDocument
            xd.Load(stream)
            stream.Close()
            resultCursor.NextCursor = Long.Parse(xd.SelectSingleNode("/id_list/next_cursor").InnerText)
            resultCursor.PreviousCursor = Long.Parse(xd.SelectSingleNode("/id_list/previous_cursor").InnerText)
            Dim re As New List(Of Long)
            For Each o As XmlNode In xd.GetElementsByTagName("id")
                re.Add(Long.Parse(o.InnerText))
            Next
            Return re
        End Function

        ''' <summary>プロフィール画面の背景画像を変更します。</summary>
        Public Overloads Sub UpdateProfileBackgroundImage(ByVal image As Image)
            Dim tempfile = Path.GetTempFileName
            Try
                Dim stream As New FileStream(tempfile, FileMode.Create, FileAccess.Write)
                image.Save(stream, Imaging.ImageFormat.Png)
                stream.Close()
                Dim param As New Dictionary(Of String, UploadFile)
                param.Add("image", New UploadFile(tempfile, "image/png"))
                tw.GetStream(Twitter.CreateUri(1, "account/update_profile_background_image.xml"), Nothing, param, Nothing).Close()
            Finally
                File.Delete(tempfile)
            End Try
        End Sub
        ''' <summary>プロフィール画面の背景画像を変更します。</summary>
        Public Overloads Sub UpdateProfileBackgroundImage(ByVal imageFile As String)
            Dim mimetype As String
            Select Case Path.GetExtension(imageFile).ToLower
                Case ".png"
                    mimetype = "image/png"
                Case ".gif"
                    mimetype = "image/gif"
                Case ".jpg", ".jpeg"
                    mimetype = "image/jpeg"
                Case Else
                    Throw New ArgumentException("Twitterが対応していないファイルです。", "imageFile")
            End Select

            Dim param As New Dictionary(Of String, UploadFile)
            param.Add("image", New UploadFile(imageFile, mimetype))
            tw.GetStream(Twitter.CreateUri(1, "account/update_profile_background_image.xml"), Nothing, param, Nothing).Close()
        End Sub

        ''' <summary>プロフィールの画像を変更します。</summary>
        Public Overloads Sub UpdateProfileImage(ByVal image As Image)
            Dim tempfile = Path.GetTempFileName
            Try
                Dim stream As New FileStream(tempfile, FileMode.Create, FileAccess.Write)
                image.Save(stream, Imaging.ImageFormat.Png)
                stream.Close()
                Dim param As New Dictionary(Of String, UploadFile)
                param.Add("image", New UploadFile(tempfile, "image/png"))
                tw.GetStream(Twitter.CreateUri(1, "account/update_profile_image.xml"), Nothing, param, Nothing).Close()
            Finally
                File.Delete(tempfile)
            End Try
        End Sub
        ''' <summary>プロフィールの画像を変更します。</summary>
        Public Overloads Sub UpdateProfileImage(ByVal imageFile As String)
            Dim mimetype As String
            Select Case Path.GetExtension(imageFile).ToLower
                Case ".png"
                    mimetype = "image/png"
                Case ".gif"
                    mimetype = "image/gif"
                Case ".jpg", ".jpeg"
                    mimetype = "image/jpeg"
                Case Else
                    Throw New ArgumentException("Twitterが対応していないファイルです。", "imageFile")
            End Select

            Dim param As New Dictionary(Of String, UploadFile)
            param.Add("image", New UploadFile(imageFile, mimetype))
            tw.GetStream(Twitter.CreateUri(1, "account/update_profile_image.xml"), Nothing, param, Nothing).Close()
        End Sub

        Friend Overloads Shared Function GetUsers(ByVal stream As Stream, ByVal close As Boolean) As IEnumerable(Of TwitterUser)
            Dim xd As New XmlDocument
            xd.Load(stream)
            If close Then stream.Close()
            Dim re As New List(Of TwitterUser)
            For Each o As XmlNode In xd.GetElementsByTagName("user")
                Dim doc As New XmlDocument
                doc.LoadXml(o.OuterXml)
                re.Add(TwitterUser.FromXml(doc))
            Next
            Return re
        End Function
        Friend Overloads Shared Function GetUsers(ByVal stream As Stream, ByVal close As Boolean, <Out()> ByRef resultCursor As CursorResult) As IEnumerable(Of TwitterUser)
            Dim xd As New XmlDocument
            xd.Load(stream)
            If close Then stream.Close()
            Dim re As New List(Of TwitterUser)
            For Each o As XmlNode In xd.GetElementsByTagName("user")
                Dim doc As New XmlDocument
                doc.LoadXml(o.OuterXml)
                re.Add(TwitterUser.FromXml(doc))
            Next
            resultCursor.NextCursor = Long.Parse(xd.SelectSingleNode("/users_list/next_cursor").InnerText)
            resultCursor.PreviousCursor = Long.Parse(xd.SelectSingleNode("/users_list/previous_cursor").InnerText)
            Return re
        End Function

        ''' <summary>自分のフレンド（フォロー中）を取得します。</summary>
        ''' <param name="cursor">カーソル位置</param>
        ''' <param name="resultCursor">Twitterから返されたCursor情報</param>
        Public Overloads Function GetFriends(ByVal cursor As Long, <Out()> ByRef resultCursor As CursorResult) As IEnumerable(Of TwitterUser)
            Dim param As New Dictionary(Of String, String)
            param.Add("cursor", cursor.ToString)
            Dim stream = tw.GetStream(Twitter.CreateUri(1, "statuses/friends.xml"), "GET", param, Nothing)
            Return GetUsers(stream, True, resultCursor)
        End Function
        ''' <summary>フレンド（フォロー中）を取得します。</summary>
        ''' <param name="id">取得元のユーザーのscreen_nameまたはid</param>
        ''' <param name="cursor">カーソル位置</param>
        ''' <param name="resultCursor">Twitterから返されたCursor情報</param>
        Public Overloads Function GetFriends(ByVal id As String, ByVal cursor As Long, <Out()> ByRef resultCursor As CursorResult) As IEnumerable(Of TwitterUser)
            Dim param As New Dictionary(Of String, String)
            param.Add("cursor", cursor.ToString)
            param.Add("id", id)
            Dim stream = tw.GetStream(Twitter.CreateUri(1, "statuses/friends.xml"), "GET", param, Nothing)
            Return GetUsers(stream, True, resultCursor)
        End Function

        ''' <summary>自分のフォロワーを取得します。</summary>
        ''' <param name="cursor">カーソル位置</param>
        ''' <param name="resultCursor">Twitterから返されたCursor情報</param>
        Public Overloads Function GetFollowers(ByVal cursor As Long, <Out()> ByRef resultCursor As CursorResult) As IEnumerable(Of TwitterUser)
            Dim param As New Dictionary(Of String, String)
            param.Add("cursor", cursor.ToString)
            Dim stream = tw.GetStream(Twitter.CreateUri(1, "statuses/followers.xml"), "GET", param, Nothing)
            Return GetUsers(stream, True, resultCursor)
        End Function
        ''' <summary>フォロワーを取得します。</summary>
        ''' <param name="cursor">カーソル位置</param>
        ''' <param name="id">取得元のユーザーののscreen_nameまたはid</param>
        ''' <param name="resultCursor">Twitterから返されたCursor情報</param>
        Public Overloads Function GetFollowers(ByVal id As String, ByVal cursor As Long, <Out()> ByRef resultCursor As CursorResult) As IEnumerable(Of TwitterUser)
            Dim param As New Dictionary(Of String, String)
            param.Add("cursor", cursor.ToString)
            param.Add("id", id)
            Dim stream = tw.GetStream(Twitter.CreateUri(1, "statuses/followers.xml"), "GET", param, Nothing)
            Return GetUsers(stream, True, resultCursor)
        End Function

        ''' <summary>Twitterユーザーを検索します。</summary>
        ''' <param name="q">名称、screen_nameなどの検索内容</param>
        Public Overloads Function Search(ByVal q As String) As IEnumerable(Of TwitterUser)
            Dim param As New Dictionary(Of String, String)
            param.Add("q", q)
            Return GetUsers(tw.GetStream(Twitter.CreateUri(1, "users/search.xml"), "GET", param, Nothing), True)
        End Function
        ''' <summary>Twitterユーザーを検索します。</summary>
        ''' <param name="q">名称、screen_nameなどの検索内容</param>
        ''' <param name="per_page">1ページに返される個数 1～20</param>
        ''' <param name="page">ページ番号 1～</param>
        Public Overloads Function Search(ByVal q As String, ByVal per_page As Integer, ByVal page As Integer) As IEnumerable(Of TwitterUser)
            Dim param As New Dictionary(Of String, String)
            param.Add("q", q)
            Return GetUsers(tw.GetStream(Twitter.CreateUri(1, "users/search.xml"), "GET", param, Nothing), True)
        End Function

        ''' <summary>プロフィールを更新します。</summary>
        Public Sub UpdateProfile(ByVal param As Dictionary(Of ProfileItems, String))
            Dim uploadparam As New Dictionary(Of String, String)
            For Each o In param
                uploadparam.Add(o.Key.ToString.ToLower, o.Value)
            Next
            tw.GetStream(Twitter.CreateUri(1, "account/update_profile.xml"), "POST", uploadparam, Nothing).Close()
        End Sub
    End Class
End Namespace