﻿'Copyright (C) 2010 pepetaro, All rights reserved.
'This library is free software; you can redistribute it and/or
'modify it under the terms of the GNU Lesser General Public
'License as published by the Free Software Foundation; either
'version 3 of the License, or (at your option) any later version.

'This library is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'Lesser General Public License for more details.

'You should have received a copy of the GNU Lesser General Public
'License along with this library; if not, write to the Free Software
'Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

''' <summary>Twitterのリストを表します。</summary>
<DebuggerDisplay("List {Slug}")>
Public Class TwitterList
    Implements ITwitterIdData, IEquatable(Of TwitterList)

    Friend Sub New()
    End Sub

    ''' <summary>取得したXMLから情報を読み取ります。</summary>
    Protected Overridable Sub LoadAll(ByVal doc As XmlDocument)
        On Error Resume Next
        _id = Long.Parse(doc.SelectSingleNode("/list/id").InnerText)
        _name = doc.SelectSingleNode("/list/name").InnerText
        full_name = doc.SelectSingleNode("/list/full_name").InnerText
        _slug = doc.SelectSingleNode("/list/slug").InnerText
        _description = doc.SelectSingleNode("/list/description").InnerText
        subscriber_count = Integer.Parse(doc.SelectSingleNode("/list/subscriber_count").InnerText)
        member_count = Integer.Parse(doc.SelectSingleNode("/list/member_count").InnerText)
        _mode = DirectCast([Enum].Parse(GetType(ListMode), doc.SelectSingleNode("/list/mode").InnerText, True), ListMode)
        _user = GetUser(doc.SelectSingleNode("/list/user").OuterXml)
    End Sub

    Private Function GetUser(ByVal xml As String) As TwitterUser
        Try
            Dim xd As New XmlDocument
            xd.LoadXml(xml)
            Return TwitterUser.FromXml(xd)
        Catch
            Return Nothing
        End Try
    End Function

    ''' <summary>XMLから新しいインスタンスを作成します。</summary>
    Public Shared Function FromXml(ByVal doc As XmlDocument) As TwitterList
        Dim re As New TwitterList
        re.LoadAll(doc)
        Return re
    End Function

    ''' <summary>対応していません。</summary>
    <DebuggerBrowsable(DebuggerBrowsableState.Never)> Private ReadOnly Property CreatedAt As Date Implements ITwitterIdData.CreatedAt
        Get
            Throw New NotSupportedException
        End Get
    End Property
    ''' <summary>対応していません。</summary>
    <DebuggerBrowsable(DebuggerBrowsableState.Never)> Private ReadOnly Property CreatedAtUtc As Date Implements ITwitterIdData.CreatedAtUtc
        Get
            Throw New NotSupportedException
        End Get
    End Property

    <DebuggerBrowsable(DebuggerBrowsableState.Never)> Protected Friend _id As Long
    ''' <summary>リストのID（番号）</summary>
    Public ReadOnly Property Id As Long Implements ITwitterIdData.Id
        Get
            Return _id
        End Get
    End Property

    <DebuggerBrowsable(DebuggerBrowsableState.Never)> Protected Friend _name As String
    ''' <summary>登録した名前。通常はSlugを使用してください。</summary>
    Public ReadOnly Property Name As String
        Get
            Return _name
        End Get
    End Property

    <DebuggerBrowsable(DebuggerBrowsableState.Never)> Protected Friend full_name As String
    ''' <summary>作成したユーザーとリストの表示名</summary>
    Public ReadOnly Property FullName As String
        Get
            Return full_name
        End Get
    End Property

    <DebuggerBrowsable(DebuggerBrowsableState.Never)> Protected Friend _slug As String
    ''' <summary>表示名</summary>
    Public ReadOnly Property Slug As String
        Get
            Return _slug
        End Get
    End Property

    <DebuggerBrowsable(DebuggerBrowsableState.Never)> Protected Friend _description As String
    ''' <summary>説明</summary>
    Public ReadOnly Property Description As String
        Get
            Return _description
        End Get
    End Property

    <DebuggerBrowsable(DebuggerBrowsableState.Never)> Protected Friend subscriber_count As Integer
    ''' <summary>購読者数</summary>
    Public ReadOnly Property SubscriberCount As Integer
        Get
            Return subscriber_count
        End Get
    End Property

    <DebuggerBrowsable(DebuggerBrowsableState.Never)> Protected Friend member_count As Integer
    ''' <summary>フォローしている人数</summary>
    Public ReadOnly Property MemberCount As Integer
        Get
            Return member_count
        End Get
    End Property

    <DebuggerBrowsable(DebuggerBrowsableState.Never)> Protected Friend _mode As ListMode
    ''' <summary>公開モード</summary>
    Public ReadOnly Property Mode As ListMode
        Get
            Return _mode
        End Get
    End Property

    <DebuggerBrowsable(DebuggerBrowsableState.Never)> Protected Friend _user As TwitterUser
    ''' <summary>作者</summary>
    Public ReadOnly Property User As TwitterUser
        Get
            Return _user
        End Get
    End Property

    ''' <summary>常にIdObjectType.Userを返します。</summary>
    Private ReadOnly Property ObjectType As IdObjectType Implements ITwitterIdData.ObjectType
        Get
            Return IdObjectType.List
        End Get
    End Property

    Public Overloads Function Equals(ByVal other As TwitterList) As Boolean Implements System.IEquatable(Of TwitterList).Equals
        Return Me = other
    End Function

    Public Shared Operator =(ByVal ts1 As TwitterList, ByVal ts2 As TwitterList) As Boolean
        Return ts1._id = ts2._id
    End Operator
    Public Shared Operator <>(ByVal ts1 As TwitterList, ByVal ts2 As TwitterList) As Boolean
        Return ts1._id <> ts2._id
    End Operator
End Class
