﻿'Copyright (C) 2010 pepetaro, All rights reserved.
'This library is free software; you can redistribute it and/or
'modify it under the terms of the GNU Lesser General Public
'License as published by the Free Software Foundation; either
'version 3 of the License, or (at your option) any later version.

'This library is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'Lesser General Public License for more details.

'You should have received a copy of the GNU Lesser General Public
'License along with this library; if not, write to the Free Software
'Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

''' <summary>クライアントを表します。</summary>
<DebuggerDisplay("{Name}")> _
Public Class TweetSource
    ''' <param name="atag">クライアントを表すAnchorタグ。"web"も認識します。</param>
    Public Sub New(ByVal atag As String)
        If atag = "web" Then
            _name = "web"
            _uri = New Uri("http://twitter.com/home")
        Else
            Dim doc As New XmlDocument
            doc.LoadXml(atag)
            _uri = New Uri(doc.DocumentElement.GetAttribute("href"))
            _name = doc.DocumentElement.InnerText
        End If
    End Sub

    <DebuggerBrowsable(DebuggerBrowsableState.Never)> _
    Dim _name As String
    ''' <summary>クライアント名</summary>
    Public ReadOnly Property Name As String
        Get
            Return _name
        End Get
    End Property

    <DebuggerBrowsable(DebuggerBrowsableState.Never)> _
    Dim _uri As Uri
    ''' <summary>公開場所</summary>
    Public ReadOnly Property Uri As Uri
        Get
            Return _uri
        End Get
    End Property
End Class