﻿'Copyright (C) 2010 pepetaro, All rights reserved.
'This library is free software; you can redistribute it and/or
'modify it under the terms of the GNU Lesser General Public
'License as published by the Free Software Foundation; either
'version 3 of the License, or (at your option) any later version.

'This library is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'Lesser General Public License for more details.

'You should have received a copy of the GNU Lesser General Public
'License along with this library; if not, write to the Free Software
'Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

Namespace TwitterServices
    ''' <summary>タイムライン関連</summary>
    Public NotInheritable Class TimelinesServices
        Friend Sub New(ByVal tw As Twitter)
            Me.tw = tw
        End Sub
        <DebuggerBrowsable(DebuggerBrowsableState.Never)> _
        Dim tw As Twitter

        Friend Shared Function GetTweets(ByVal content As Stream, ByVal close As Boolean) As IEnumerable(Of TwitterStatus)
            Dim xd As New XmlDocument
            xd.Load(content)
            If close Then content.Close()
            Dim re As New List(Of TwitterStatus)
            For Each o As XmlNode In xd.GetElementsByTagName("status")
                Dim doc As New XmlDocument
                doc.LoadXml(o.OuterXml)
                re.Add(TwitterStatus.FromXml(doc))
            Next
            Return re
        End Function

        ''' <summary>パブリックタイムラインを取得します。</summary>
        ''' <remarks>OAuth認証を使用しません。</remarks>
        Public Shared Function GetPublicTimeline() As IEnumerable(Of TwitterStatus)
            Using wc As New WebClient
                Return GetTweets(wc.OpenRead(Twitter.CreateUri(1, "statuses/public_timeline.xml")), True)
            End Using
        End Function

        ''' <summary>ホームを既定の設定で取得します。</summary>
        Public Overloads Function GetHomeTimeline() As IEnumerable(Of TwitterStatus)
            Return GetTweets(tw.GetStream(Twitter.CreateUri(1, "statuses/home_timeline.xml"), "GET", Nothing, Nothing), True)
        End Function
        ''' <summary>ホームを取得します。</summary>
        ''' <param name="count">1ページに返される個数 1～200</param>
        ''' <param name="page">ページ番号 1～</param>
        Public Overloads Function GetHomeTimeline(ByVal count As Integer, ByVal page As Integer) As IEnumerable(Of TwitterStatus)
            Dim param As New Dictionary(Of String, String)
            param.Add("count", count.ToString)
            param.Add("page", page.ToString)
            Return GetTweets(tw.GetStream(Twitter.CreateUri(1, "statuses/home_timeline.xml"), "GET", param, Nothing), True)
        End Function

        ''' <summary>フレンドタイムラインを既定の設定で取得します。</summary>
        Public Overloads Function GetFriendsTimeline() As IEnumerable(Of TwitterStatus)
            Return GetTweets(tw.GetStream(Twitter.CreateUri(1, "statuses/friends_timeline.xml"), "GET", Nothing, Nothing), True)
        End Function
        ''' <summary>フレンドタイムラインをIDを指定して取得します。</summary>
        ''' <param name="id">タイムラインの取得元のユーザーのscreen_nameまたはid</param>
        Public Overloads Function GetFriendsTimeline(ByVal id As String) As IEnumerable(Of TwitterStatus)
            Return GetTweets(tw.GetStream(Twitter.CreateUri(1, String.Format("statuses/friends_timeline/{0}.xml", id)), "GET", Nothing, Nothing), True)
        End Function
        ''' <summary>フレンドタイムラインを取得します。</summary>
        ''' <param name="count">1ページに返される個数 1～200</param>
        ''' <param name="page">ページ番号 1～</param>
        Public Overloads Function GetFriendsTimeline(ByVal count As Integer, ByVal page As Integer) As IEnumerable(Of TwitterStatus)
            Dim param As New Dictionary(Of String, String)
            param.Add("count", count.ToString)
            param.Add("page", page.ToString)
            Return GetTweets(tw.GetStream(Twitter.CreateUri(1, "statuses/friends_timeline.xml"), "GET", param, Nothing), True)
        End Function
        ''' <summary>フレンドタイムラインを取得します。</summary>
        ''' <param name="id">タイムラインの取得元のユーザーのscreen_nameまたはid</param>
        ''' <param name="count">1ページに返される個数 1～200</param>
        ''' <param name="page">ページ番号 1～</param>
        Public Overloads Function GetFriendsTimeline(ByVal id As String, ByVal count As Integer, ByVal page As Integer) As IEnumerable(Of TwitterStatus)
            Dim param As New Dictionary(Of String, String)
            param.Add("count", count.ToString)
            param.Add("page", page.ToString)
            Return GetTweets(tw.GetStream(Twitter.CreateUri(1, String.Format("statuses/friends_timeline/{0}.xml", id)), "GET", param, Nothing), True)
        End Function

        ''' <summary>ユーザータイムラインを取得します。</summary>
        ''' <param name="id">取得元のユーザーのscreen_nameまたはid</param>
        Public Overloads Function GetUserTimeline(ByVal id As String) As IEnumerable(Of TwitterStatus)
            Return GetTweets(tw.GetStream(Twitter.CreateUri(1, String.Format("statuses/user_timeline/{0}.xml", id)), "GET", Nothing, Nothing), True)
        End Function
        ''' <summary>ユーザータイムラインを取得します。</summary>
        ''' <param name="id">取得元のユーザーのscreen_nameまたはid</param>
        ''' <param name="page">ページ番号 1～160</param>
        Public Overloads Function GetUserTimeline(ByVal id As String, ByVal page As Integer) As IEnumerable(Of TwitterStatus)
            Dim param As New Dictionary(Of String, String)
            param.Add("page", page.ToString)
            Return GetTweets(tw.GetStream(Twitter.CreateUri(1, String.Format("statuses/user_timeline/{0}.xml", id)), "GET", param, Nothing), True)
        End Function

        ''' <summary>自分に関係するつぶやきを取得します。</summary>
        Public Overloads Function GetMentions() As IEnumerable(Of TwitterStatus)
            Return GetTweets(tw.GetStream(Twitter.CreateUri(1, "statuses/mentions.xml"), "GET", Nothing, Nothing), True)
        End Function
        ''' <summary>自分に関係するつぶやきを取得します。</summary>
        ''' <param name="count">1ページに返される個数 1～200</param>
        ''' <param name="page">ページ番号 1～</param>
        Public Overloads Function GetMentions(ByVal count As Integer, ByVal page As Integer) As IEnumerable(Of TwitterStatus)
            Dim param As New Dictionary(Of String, String)
            param.Add("count", count.ToString)
            param.Add("page", page.ToString)
            Return GetTweets(tw.GetStream(Twitter.CreateUri(1, "statuses/mentions.xml"), "GET", param, Nothing), True)
        End Function

        ''' <summary>自分がリツイートしたつぶやきを取得します。</summary>
        Public Overloads Function GetRetweetedByMe() As IEnumerable(Of TwitterStatus)
            Return GetTweets(tw.GetStream(Twitter.CreateUri(1, "statuses/retweeted_by_me.xml"), "GET", Nothing, Nothing), True)
        End Function
        ''' <summary>自分がリツイートしたつぶやきを取得します。</summary>
        ''' <param name="count">1ページに返される個数 1～200</param>
        ''' <param name="page">ページ番号 1～</param>
        Public Overloads Function GetRetweetedByMe(ByVal count As Integer, ByVal page As Integer) As IEnumerable(Of TwitterStatus)
            Dim param As New Dictionary(Of String, String)
            param.Add("count", count.ToString)
            param.Add("page", page.ToString)
            Return GetTweets(tw.GetStream(Twitter.CreateUri(1, "statuses/retweeted_by_me.xml"), "GET", param, Nothing), True)
        End Function

        ''' <summary>フレンドのリツイートを取得します。</summary>
        Public Overloads Function GetRetweetedToMe() As IEnumerable(Of TwitterStatus)
            Return GetTweets(tw.GetStream(Twitter.CreateUri(1, "statuses/retweeted_to_me.xml"), "GET", Nothing, Nothing), True)
        End Function
        ''' <summary>フレンドのリツイートを取得します。</summary>
        ''' <param name="count">1ページに返される個数 1～200</param>
        ''' <param name="page">ページ番号 1～</param>
        Public Overloads Function GetRetweetedToMe(ByVal count As Integer, ByVal page As Integer) As IEnumerable(Of TwitterStatus)
            Dim param As New Dictionary(Of String, String)
            param.Add("count", count.ToString)
            param.Add("page", page.ToString)
            Return GetTweets(tw.GetStream(Twitter.CreateUri(1, "statuses/retweeted_to_me.xml"), "GET", param, Nothing), True)
        End Function

        ''' <summary>誰かがリツイートした自分のつぶやきを取得します。</summary>
        Public Overloads Function GetRetweetsOfMe() As IEnumerable(Of TwitterStatus)
            Return GetTweets(tw.GetStream(Twitter.CreateUri(1, "statuses/retweets_of_me.xml"), "GET", Nothing, Nothing), True)
        End Function
        ''' <summary>誰かがリツイートした自分のつぶやきを取得します。</summary>
        ''' <param name="count">1ページに返される個数 1～200</param>
        ''' <param name="page">ページ番号 1～</param>
        Public Overloads Function GetRetweetsOfMe(ByVal count As Integer, ByVal page As Integer) As IEnumerable(Of TwitterStatus)
            Dim param As New Dictionary(Of String, String)
            param.Add("count", count.ToString)
            param.Add("page", page.ToString)
            Return GetTweets(tw.GetStream(Twitter.CreateUri(1, "statuses/retweets_of_me.xml"), "GET", param, Nothing), True)
        End Function
    End Class
End Namespace