﻿'Copyright (C) 2010 pepetaro, All rights reserved.
'This library is free software; you can redistribute it and/or
'modify it under the terms of the GNU Lesser General Public
'License as published by the Free Software Foundation; either
'version 3 of the License, or (at your option) any later version.

'This library is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'Lesser General Public License for more details.

'You should have received a copy of the GNU Lesser General Public
'License along with this library; if not, write to the Free Software
'Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

''' <summary>GetRateLimitStatusメソッドの戻り値の型です。publicなコンストラクタはありません。</summary>
Public NotInheritable Class RateLimitStatusResult
    <DebuggerBrowsable(DebuggerBrowsableState.Never)> _
    Dim hourly_limit As Integer
    ''' <summary>1時間に取得系APIを実行できる最大値です。</summary>
    Public ReadOnly Property HourlyLimit As Integer
        Get
            Return hourly_limit
        End Get
    End Property
    <DebuggerBrowsable(DebuggerBrowsableState.Never)> _
    Dim remaining_hits As Integer
    ''' <summary>リセット時刻までにあと何回取得系APIを実行できるか。</summary>
    Public ReadOnly Property RemainingHits As Integer
        Get
            Return remaining_hits
        End Get
    End Property
    <DebuggerBrowsable(DebuggerBrowsableState.Never)> _
    Dim reset_time As Date
    ''' <summary>残り回数がリセットされる時刻（UTC）</summary>
    Public ReadOnly Property ResetTimeUtc As Date
        Get
            Return reset_time
        End Get
    End Property
    ''' <summary>残り回数がリセットされる時刻</summary>
    Public ReadOnly Property ResetTime As Date
        Get
            Return reset_time.ToLocalTime
        End Get
    End Property

    ''' <param name="oauth">OAuthを使用するか</param>
    Friend Sub New(ByVal tw As Twitter, ByVal oauth As Boolean)
        Dim doc As New XmlDocument
        If oauth Then
            Dim stream = tw.GetStream(Twitter.CreateUri(1, "account/rate_limit_status.xml"), "GET", Nothing, Nothing)
            doc.Load(stream)
            stream.Close()
        Else
            Using wc As New WebClient
                Dim stream = wc.OpenRead(Twitter.CreateUri(1, "account/rate_limit_status.xml"))
                doc.Load(stream)
                stream.Close()
            End Using
        End If
        hourly_limit = Integer.Parse(doc.SelectSingleNode("/hash/hourly-limit").InnerText)
        remaining_hits = Integer.Parse(doc.SelectSingleNode("/hash/remaining-hits").InnerText)
        reset_time = Date.ParseExact(doc.SelectSingleNode("/hash/reset-time").InnerText, "yyyy-MM-ddTHH:mm:sszzz", New Globalization.CultureInfo("en-US"))
    End Sub
End Class
