﻿'Copyright (C) 2010 pepetaro, All rights reserved.
'This library is free software; you can redistribute it and/or
'modify it under the terms of the GNU Lesser General Public
'License as published by the Free Software Foundation; either
'version 3 of the License, or (at your option) any later version.

'This library is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'Lesser General Public License for more details.

'You should have received a copy of the GNU Lesser General Public
'License along with this library; if not, write to the Free Software
'Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

Namespace TwitterServices
    ''' <summary>DMを操作します。</summary>
    Public Class DirectMessagesService
        Friend Sub New(ByVal tw As Twitter)
            Me.tw = tw
        End Sub
        <DebuggerBrowsable(DebuggerBrowsableState.Never)> _
        Dim tw As Twitter
        Friend Shared Function GetDMList(ByVal stream As Stream, ByVal close As Boolean) As IEnumerable(Of DirectMessage)
            Dim doc As New XmlDocument
            doc.Load(stream)
            If close Then stream.Close()
            Dim re As New List(Of DirectMessage)
            For Each xn As XmlNode In doc.GetElementsByTagName("direct_message")
                Dim xd As New XmlDocument
                xd.LoadXml(xn.OuterXml)
                re.Add(DirectMessage.FromXml(xd))
            Next
            Return re
        End Function

        ''' <summary>自分あてのDMを取得します。</summary>
        Public Overloads Function GetMessages() As IEnumerable(Of DirectMessage)
            Return GetDMList(tw.GetStream(Twitter.CreateUri(1, "direct_messages.xml"), "GET", Nothing, Nothing), True)
        End Function
        ''' <summary>自分あてのDMを取得します。</summary>
        ''' <param name="count">1ページに返される個数 1～200</param>
        ''' <param name="page">ページ番号 1～</param>
        Public Overloads Function GetMessages(ByVal count As Integer, ByVal page As Integer) As IEnumerable(Of DirectMessage)
            Dim param As New Dictionary(Of String, String)
            param.Add("count", count.ToString)
            param.Add("page", page.ToString)
            Return GetDMList(tw.GetStream(Twitter.CreateUri(1, "direct_messages.xml"), "GET", param, Nothing), True)
        End Function

        ''' <summary>自分が送信したDMを取得します。</summary>
        Public Overloads Function GetSentMessages() As IEnumerable(Of DirectMessage)
            Return GetDMList(tw.GetStream(Twitter.CreateUri(1, "direct_messages/sent.xml"), "GET", Nothing, Nothing), True)
        End Function
        ''' <summary>自分が送信したDMを取得します。</summary>
        ''' <param name="count">1ページに返される個数 1～200</param>
        ''' <param name="page">ページ番号 1～</param>
        Public Overloads Function GetSentMessages(ByVal count As Integer, ByVal page As Integer) As IEnumerable(Of DirectMessage)
            Dim param As New Dictionary(Of String, String)
            param.Add("count", count.ToString)
            param.Add("page", page.ToString)
            Return GetDMList(tw.GetStream(Twitter.CreateUri(1, "direct_messages/sent.xml"), "GET", param, Nothing), True)
        End Function

        ''' <summary>DMを投稿します。</summary>
        ''' <param name="user">宛先ユーザーのscreen_nameかid</param>
        ''' <param name="text">投稿内容</param>
        ''' <returns>投稿したDM</returns>
        Public Function Create(ByVal user As String, ByVal text As String) As DirectMessage
            Dim param As New Dictionary(Of String, String)
            param.Add("user", user)
            param.Add("text", text)
            Dim stream = tw.GetStream(Twitter.CreateUri(1, "direct_messages/new.xml"), "POST", param, Nothing)
            Dim xd As New XmlDocument
            xd.Load(stream)
            stream.Close()
            Return DirectMessage.FromXml(xd)
        End Function

        ''' <summary>DMを削除します。</summary>
        ''' <param name="dmid">削除するDMのID</param>
        Public Sub Destroy(ByVal dmid As Long)
            Dim uri = Twitter.CreateUri(1, String.Format("direct_messages/destroy/{0}.xml", dmid))
            tw.GetStream(uri, "POST", Nothing, Nothing).Close()
        End Sub
    End Class
End Namespace