﻿'Copyright (C) 2010 pepetaro, All rights reserved.
'This library is free software; you can redistribute it and/or
'modify it under the terms of the GNU Lesser General Public
'License as published by the Free Software Foundation; either
'version 3 of the License, or (at your option) any later version.

'This library is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'Lesser General Public License for more details.

'You should have received a copy of the GNU Lesser General Public
'License along with this library; if not, write to the Free Software
'Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

''' <summary>TwitterのDMを表します。</summary>
<DebuggerDisplay("DM {Text}")> _
Public Class DirectMessage
    Implements ITwitterIdData, IComparable, IComparable(Of DirectMessage), IEquatable(Of DirectMessage)

    Friend Sub New()
    End Sub

    ''' <summary>取得したXMLから情報を読み取ります。</summary>
    Protected Overridable Sub LoadAll(ByVal doc As XmlDocument)
        On Error Resume Next
        _id = Long.Parse(doc.SelectSingleNode("/direct_message/id").InnerText)
        _text = doc.SelectSingleNode("/direct_message/text").InnerText
        created_at = Date.SpecifyKind(Date.ParseExact(doc.SelectSingleNode("/direct_message/created_at").InnerText, "ddd MMM dd HH:mm:ss +0000 yyyy", New Globalization.CultureInfo("en-US")), DateTimeKind.Utc)
        _sender = GetUser(doc.SelectSingleNode("/direct_message/sender").InnerXml)
        _recipient = GetUser(doc.SelectSingleNode("/direct_message/recipient").InnerXml)
    End Sub

    ''' <summary>XMLから新しいインスタンスを作成します。</summary>
    Public Shared Function FromXml(ByVal doc As XmlDocument) As DirectMessage
        Dim dm As New DirectMessage
        dm.LoadAll(doc)
        Return dm
    End Function

    Private Function GetUser(ByVal innerxml As String) As TwitterUser
        Try
            Dim xml = "<user>" & innerxml & "</user>"
            Dim xd As New XmlDocument
            xd.LoadXml(xml)
            Return TwitterUser.FromXml(xd)
        Catch
            Return Nothing
        End Try
    End Function

    <DebuggerBrowsable(DebuggerBrowsableState.Never)> _
    Protected Friend _id As Long
    ''' <summary>DMのID</summary>
    Public ReadOnly Property Id As Long Implements ITwitterIdData.Id
        Get
            Return _id
        End Get
    End Property

    <DebuggerBrowsable(DebuggerBrowsableState.Never)> _
    Protected Friend _text As String
    ''' <summary>DMの内容</summary>
    Public ReadOnly Property Text As String
        Get
            Return _text
        End Get
    End Property

    <DebuggerBrowsable(DebuggerBrowsableState.Never)> _
    Protected Friend created_at As Date
    ''' <summary>取得日時（UTC）</summary>
    Public ReadOnly Property CreatedAtUtc As Date Implements ITwitterIdData.CreatedAtUtc
        Get
            Return created_at
        End Get
    End Property

    ''' <summary>取得日時</summary>
    Public ReadOnly Property CreatedAt As Date Implements ITwitterIdData.CreatedAt
        Get
            Return created_at.ToLocalTime
        End Get
    End Property

    <DebuggerBrowsable(DebuggerBrowsableState.Never)> _
    Protected Friend _sender As TwitterUser
    ''' <summary>送信者</summary>
    Public ReadOnly Property Sender As TwitterUser
        Get
            Return _sender
        End Get
    End Property

    <DebuggerBrowsable(DebuggerBrowsableState.Never)> _
    Protected Friend _recipient As TwitterUser
    ''' <summary>受信者</summary>
    Public ReadOnly Property Recipient As TwitterUser
        Get
            Return _recipient
        End Get
    End Property

    ''' <summary>常にIdObjectType.DirectMessageを返します。</summary>
    Private ReadOnly Property ObjectType As IdObjectType Implements ITwitterIdData.ObjectType
        Get
            Return IdObjectType.DirectMessage
        End Get
    End Property

    Public Overrides Function ToString() As String
        Return _text
    End Function

    Public Overloads Function CompareTo(ByVal obj As Object) As Integer Implements System.IComparable.CompareTo
        Dim o = DirectCast(obj, TwitterStatus)
        Return _id.CompareTo(obj)
    End Function
    Public Overloads Function CompareTo(ByVal other As DirectMessage) As Integer Implements System.IComparable(Of DirectMessage).CompareTo
        Return _id.CompareTo(other)
    End Function

    Public Overloads Function Equals(ByVal other As DirectMessage) As Boolean Implements System.IEquatable(Of DirectMessage).Equals
        Return Me = other
    End Function

    Public Shared Operator =(ByVal dm1 As DirectMessage, ByVal dm2 As DirectMessage) As Boolean
        Return dm1._id = dm2._id
    End Operator
    Public Shared Operator <>(ByVal dm1 As DirectMessage, ByVal dm2 As DirectMessage) As Boolean
        Return dm1._id <> dm2._id
    End Operator
    Public Shared Operator <(ByVal dm1 As DirectMessage, ByVal dm2 As DirectMessage) As Boolean
        Return dm1._id < dm2._id
    End Operator
    Public Shared Operator >(ByVal dm1 As DirectMessage, ByVal dm2 As DirectMessage) As Boolean
        Return dm1._id > dm2._id
    End Operator
    Public Shared Operator <=(ByVal dm1 As DirectMessage, ByVal dm2 As DirectMessage) As Boolean
        Return dm1._id <= dm2._id
    End Operator
    Public Shared Operator >=(ByVal dm1 As DirectMessage, ByVal dm2 As DirectMessage) As Boolean
        Return dm1._id >= dm2._id
    End Operator
End Class