﻿'Copyright (C) 2010 pepetaro, All rights reserved.
'This library is free software; you can redistribute it and/or
'modify it under the terms of the GNU Lesser General Public
'License as published by the Free Software Foundation; either
'version 3 of the License, or (at your option) any later version.

'This library is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'Lesser General Public License for more details.

'You should have received a copy of the GNU Lesser General Public
'License along with this library; if not, write to the Free Software
'Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

Namespace TwitterServices
    ''' <summary>ブロック関係を操作します。お取り扱いにはご注意を</summary>
    Public NotInheritable Class BlocksService
        <DebuggerBrowsable(DebuggerBrowsableState.Never)> _
        Dim tw As Twitter
        Friend Sub New(ByVal tw As Twitter)
            Me.tw = tw
        End Sub

        ''' <summary>指定したユーザーをブロックします。</summary>
        ''' <param name="id">ブロックするユーザーのscreen_nameまたはid</param>
        Public Sub Create(ByVal id As String)
            tw.GetStream(Twitter.CreateUri(1, String.Format("blocks/create/{0}.xml", id)), "POST", Nothing, Nothing).Close()
        End Sub

        ''' <summary>指定したユーザーのブロックを解除します。</summary>
        ''' <param name="id">ブロックを解除するユーザーのscreen_nameまたはid</param>
        Public Sub Destroy(ByVal id As String)
            tw.GetStream(Twitter.CreateUri(1, String.Format("blocks/destroy/{0}.xml", id)), "POST", Nothing, Nothing).Close()
        End Sub

        ''' <summary>指定したユーザーをブロックしてるか</summary>
        ''' <param name="id">確認するユーザーのscreen_nameまたはid</param>
        Public Function Exists(ByVal id As String) As Boolean
            Try
                tw.GetStream(Twitter.CreateUri(1, String.Format("blocks/exists/{0}.xml", id)), "GET", Nothing, Nothing).Close()
            Catch ex As TwitterException When ex.StatusCode = HttpStatusCode.NotFound
                Return False
            End Try
            Return True
        End Function

        ''' <summary>自分がブロックしているユーザーを取得します。</summary>
        Public Overloads Function GetBlocking() As IEnumerable(Of TwitterUser)
            Return UsersService.GetUsers(tw.GetStream(Twitter.CreateUri(1, "blocks/blocking.xml"), "GET", Nothing, Nothing), True)
        End Function
        ''' <summary>自分がブロックしているユーザーを取得します。</summary>
        ''' <param name="page">ページ番号 1～</param>
        Public Overloads Function GetBlocking(ByVal page As Integer) As IEnumerable(Of TwitterUser)
            Dim param As New Dictionary(Of String, String)
            param.Add("page", page.ToString)
            Return UsersService.GetUsers(tw.GetStream(Twitter.CreateUri(1, "blocks/blocking.xml"), "GET", param, Nothing), True)
        End Function

        ''' <summary>自分がブロックしているユーザーのIDを取得します。</summary>
        Public Function GetBlockingIds() As IEnumerable(Of Long)
            Dim stream = tw.GetStream(Twitter.CreateUri(1, "blocks/blocking/ids.xml"), "GET", Nothing, Nothing)
            Dim xd As New XmlDocument
            xd.Load(stream)
            stream.Close()
            Dim re As New List(Of Long)
            For Each o As XmlNode In xd.GetElementsByTagName("id")
                re.Add(Long.Parse(o.InnerText))
            Next
            Return re
        End Function
    End Class
End Namespace