#include <math.h>
#include <string.h>

typedef unsigned int uint32;

#define gl_malloc api_malloc

typedef struct {
	float x, y, z;
} gl_vertex3d;

typedef struct {
	uint32 *p;
	float *zfar;
	int w,h;
} gl_screen;

typedef struct {
	int nowvert;
	gl_vertex3d pos[256];
	gl_vertex3d mvpos;
	gl_vertex3d rtpos;
	gl_screen pixels;
	uint32 color;
} gl_ctl;

/* useful func */
gl_ctl gl_init(uint32 *p, int w, int h);
void gl_vertex(gl_ctl *ctl, float x, float y, float z);
void gl_color(gl_ctl *ctl, uint32 color);
void gl_render(gl_ctl *ctl, int flags);
void gl_clear(gl_ctl *ctl);

/* difficult use func */
void gl_rotate3D(gl_vertex3d *newvertex,gl_vertex3d oldvertex, float angle, int axis);
void gl_renderpolyfil(gl_ctl ctl,gl_vertex3d *lpVertex,int VerCou);
void gl_renderpolywire(gl_ctl ctl,gl_vertex3d *lpVertex,int VerCou);
gl_vertex3d gl_getvec(float x, float y, float z);
void gl_vec3normalize(gl_vertex3d *pout, gl_vertex3d *pv);
void gl_vec3cross(gl_vertex3d *pout, gl_vertex3d *pv1, gl_vertex3d *pv2);


#define gl_tocolor(r,g,b) (((int)r << 16) | ((int)g << 8) | (int)b)
#define gl_fromcolor(c,r,g,b) (*r = (c >> 16) & 0xff, *g = (c >> 8) & 0xff, *b = c & 0xff)

#define GL_NOSHADE 0
#define GL_FLSHADE 1
#define GL_WFRAME 3
