/* j[֌W */

#include "bootpack.h"
#include <string.h>

struct SHEET *open_menu(struct SHTCTL *shtctl, struct MENU *menu, int menunum, int x, int y);
void close_menu(struct SHEET *sht);
void sel_menu(struct SHEET *sht, int num);
void unsel_menu(struct SHEET *sht, int num);
void exec_menu(char *command, int memtotal, struct MENU me, int num, int y);

extern unsigned int mdata[4];
extern struct SHEET *sht_back;

extern char cpath[256];
extern char epath[1024];

struct MENU main_menu[] = {
	{ 1, "apps     >"	, "<<<submenu>>>"							, 1, 0 },
	{ 1, "terminal"	, "<<<console>>>"							, 1, 0 },
	{ 1, "editer"	, "edit doc0.txt"							, 1, 0 },
	{ 1, "readme"	, "tview -w125 -h45 /etc/doc/readme.txt"	, 1, 0 },
	{ 0, " "			, " "										, 1, 0 },
};

struct MENU sub_menu_0[] = {
	{ 1, "invader"	, "invader"								, 0, 1 },
	{ 1, "guicalc"	, "guicalc"								, 0, 0 },
	{ 1, "ssgl demo"	, "ver"									, 0, 0 },
	{ 0, " "	, " "										, 0, 0 },
};

struct MENU *ctl_menu[] = { main_menu, sub_menu_0, 0 };

struct SHEET *sht_menu[16];
char menu_flag[16];

void menu_task(int memtotal)
{
	struct BOOTINFO *binfo = (struct BOOTINFO *) ADR_BOOTINFO;
	struct MEMMAN *memman = (struct MEMMAN *) MEMMAN_ADDR;
	struct SHTCTL *shtctl = (struct SHTCTL *) *((int *) 0x0fe4);
	struct TASK *task = task_now();
	int x = 0, y = 0;
	int mx = mdata[0];
	int my = mdata[1];
	int exec_flag = 0;
	int buf = 0;
	
	int i, j;

	task->langmode = 1;

	for(;;) {
		if (fifo32_status(&task->fifo) == 0) {
			task_sleep(task);
		}
		
		mx = mdata[0];
		my = mdata[1];
		buf = fifo32_get(&task->fifo);
		if(mdata[2] != 0 && buf == '!') {
			if ((2 <= mx && mx <= 60 && sht_back->bysize - 24 <= my && my <= sht_back->bysize - 3) && menu_flag[0] == 0) {
				push_menu(sht_back->buf, sht_back->bxsize, sht_back->bysize);
				sht_menu[0] = open_menu(shtctl, ctl_menu[0], 4, 0, binfo->scrny - 28 - (4 * 18 + 8));
				menu_flag[0] = 1;
				sheet_refresh(sht_back, 2, sht_back->bysize - 24, 61, sht_back->bysize - 2);
				sheet_refresh(sht_menu[0], 0, 0, sht_menu[0]->bxsize - 1, sht_menu[0]->bysize - 1);
			} else if ((2 <= mx && mx <= 60 && sht_back->bysize - 24 <= my && my <= sht_back->bysize - 3) && menu_flag[0] == 1) {
				pull_menu(sht_back->buf, sht_back->bxsize, sht_back->bysize);
				for(i = 0; ctl_menu[i] != 0; i++) {
					if(menu_flag[i] == 1) {
						close_menu(sht_menu[i]);
						menu_flag[i] = 0;
					}
				}
				sheet_refresh(sht_back, 2, sht_back->bysize - 24, 61, sht_back->bysize - 2);
			}
			
			for(i = 0; ctl_menu[i] != 0; i++) {
				if(menu_flag[i] == 1) {
					x = mx - sht_menu[i]->vx0;
					y = my - sht_menu[i]->vy0;
					for(j = 0; ctl_menu[i][j].enable != 0; j++) {
						if(x >= 4 && x <= 83 && y >= (j * 18 + 4) && y <= ((j + 1) * 18 + 4)) {
							if(exec_flag == 0) {
								if(strncmp(ctl_menu[i][j].command,"<<<submenu>>>",13) != 0) {
									pull_menu(sht_back->buf, sht_back->bxsize, sht_back->bysize);
									exec_menu(ctl_menu[i][j].command, memtotal, ctl_menu[i][j], j, sht_menu[i]->vy0);
									int k;
									for(k = 0; ctl_menu[k] != 0; k++) {
										if(menu_flag[k] == 1) {
											close_menu(sht_menu[k]);
											menu_flag[k] = 0;
										}
									}
									sheet_refresh(sht_back, 2, sht_back->bysize - 24, 61, sht_back->bysize - 2);
								} else {
									if(menu_flag[ctl_menu[i][j].chnum] != 1) {
										exec_menu(ctl_menu[i][j].command, memtotal, ctl_menu[i][j], j, sht_menu[i]->vy0);
										menu_flag[ctl_menu[i][j].chnum] = 1;
									} else {
										close_menu(sht_menu[ctl_menu[i][j].chnum]);
										menu_flag[ctl_menu[i][j].chnum] = 0;
									}
								}
								exec_flag = 1;
							}
						}
					}
				}
			}
			
			for(i = 0; ctl_menu[i] != 0; i++) if(sht_menu[i] != 0) sheet_refresh(sht_menu[i], 0, 0, sht_menu[i]->bxsize, sht_menu[i]->bysize);
		} else {
			exec_flag = 0;
			for(i = 0; ctl_menu[i] != 0; i++) {
				if(menu_flag[i] == 1) {
					x = mx - sht_menu[i]->vx0;
					y = my - sht_menu[i]->vy0;
					for(j = 0; ctl_menu[i][j].enable != 0; j++) {
						if(x >= 4 && x <= 83 && y >= (j * 18 + 4) && y <= ((j + 1) * 18 + 4)) {
							sel_menu(sht_menu[i], j + 1);
						}
					}
				}
				if(sht_menu[i] != 0) {
					sheet_refresh(sht_menu[i], 0, 0, sht_menu[i]->bxsize, sht_menu[i]->bysize);
					for(j = 0; ctl_menu[i][j].enable != 0; j++) unsel_menu(sht_menu[i], j + 1);
				}
			}
		}
	}
}

int menu_nums(struct MENU *me)
{
	int i = 0;
	for(i = 0;me[i].enable != 0;i++) ;
	return i;
}

struct SHEET *open_menu(struct SHTCTL *shtctl, struct MENU *menu, int menunum, int x, int y)
{
	struct BOOTINFO *binfo = (struct BOOTINFO *) ADR_BOOTINFO;
	struct MEMMAN *memman = (struct MEMMAN *) MEMMAN_ADDR;
	struct SHTCTL *shtctl = (struct SHTCTL *) *((int *) 0x0fe4);
	struct SHEET *sht = sheet_alloc(shtctl);
	int i = 0;

	unsigned int *buf = (unsigned int *) memman_alloc_4k(memman, (88) * (menunum * 18 + 8) * 4);
	sheet_updown(sht, -1);
	sheet_setbuf(sht, buf, 88, menunum * 18 + 8, -1); /* FȂ */
	sht->flag2 = 2;
	boxfill8(sht->buf, sht->bxsize, COL8_000000, 0    , 0    , sht->bxsize - 1, sht->bysize - 1);
	boxfill8(sht->buf, sht->bxsize, COL8_333333, 1    , 1    , sht->bxsize - 2, sht->bysize - 2);
	for(i = 0;i < menunum;i++) {
		putfonts8_asc_sht(sht, 4, (i * 18 + 4), COL8_FFFFFF, COL8_333333, menu[i].label, 10);
	}
	sheet_slide(sht, x, y);
	sheet_updown(sht, shtctl->top);
	sheet_refresh(sht, 0, 0, sht_back->bxsize, sht_back->bysize);
	return sht;
}

void close_menu(struct SHEET *sht)
{
	struct MEMMAN *memman = (struct MEMMAN *) MEMMAN_ADDR;
	sheet_updown(sht, -1);
	memman_free_4k(memman, (int) sht->buf, sht->bxsize * sht->bysize * 4);
	sheet_free(sht);
}

void sel_menu(struct SHEET *sht, int num)
{
	int x, y;
	int c, tc_new, tbc_new, tc_old, tbc_old, an1_old, an2_old, an1_new, an2_new, *buf = sht->buf;
	
	tc_new  = COL8_000000;
	tbc_new = COL8_ffffff;
	tc_old  = COL8_FFFFFF;
	tbc_old = COL8_333333;

	if(sht->flag2 == 2) {
		for (y = (((num * 18) - 18) + 4); y <= num * 18 + 2; y++) {
			for (x = 4; x <= 83; x++) {
				c = sht->buf[y * sht->bxsize + x];
				if (c == tc_old) {
					c = tc_new;
				} else if (c == tbc_old) {
					c = tbc_new;
				}
				sht->buf[y * sht->bxsize + x] = c;
			}
		}
	}
}

void unsel_menu(struct SHEET *sht, int num)
{
	int x, y;
	int c, tc_new, tbc_new, tc_old, tbc_old, an1_old, an2_old, an1_new, an2_new, *buf = sht->buf;
	
	tc_new  = COL8_FFFFFF;
	tbc_new = COL8_333333;
	tc_old  = COL8_000000;
	tbc_old = COL8_ffffff;

	if(sht->flag2 == 2) {
		for (y = (((num * 18) - 18) + 4); y <= num * 18 + 2; y++) {
			for (x = 4; x <= 83; x++) {
				c = sht->buf[y * sht->bxsize + x];
				if (c == tc_old) {
					c = tc_new;
				} else if (c == tbc_old) {
					c = tbc_new;
				}
				sht->buf[y * sht->bxsize + x] = c;
			}
		}
	}
}

void exec_menu(char *command, int memtotal, struct MENU me, int num, int y)
{
	struct BOOTINFO *binfo = (struct BOOTINFO *) ADR_BOOTINFO;
	struct FIFO32 *sys_fifo = (struct FIFO32 *) *((int *) 0x0fec);
	struct SHTCTL *shtctl = (struct SHTCTL *) *((int *) 0x0fe4);
	struct TASK *task;
	struct SHEET *key_win;
	struct FIFO32 *fifo;
	int i;

	if (strncmp(command, "<<<submenu>>>", 13) == 0) {
		sht_menu[me.chnum] = open_menu(shtctl, ctl_menu[me.chnum], menu_nums(ctl_menu[me.chnum]), 88 * ctl_menu[me.chnum]->fnum, (((y - (menu_nums(ctl_menu[me.chnum]) * 18 - 2 - 18) + (num * 18))) - 2));
		return;
	} else if (strncmp(command, "<<<console>>>", 13) == 0) {
		key_win = open_console(shtctl, memtotal);
		keywin_on(key_win);
		sheet_slide(key_win, 8, 8);
		sheet_updown(key_win, shtctl->top);
		key_win->flag2 = 0;
	} else {
		task = open_constask(0, memtotal);
		fifo = &task->fifo;
		for (i = 0; command[i] != 0; i++) {
			fifo32_put_io(fifo, command[i] + 256);
		}
		fifo32_put_io(fifo, 10 + 256);	/* Enter */
	}

	return;
}
