/**
   Copyright 2004 TubeRide Project

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
using System;
using System.Text.RegularExpressions;

namespace com.staytube.tuberide.util
{
	/// <summary>
	/// Validatori؁j[eBeB[NX
	/// @author makoto tsuyuki(sf@stay-tube.com)
	/// </summary>
	public class Validator
	{
		/// <summary>
		/// [ɎgpׂłȂpJi̕ꗗi{iso-2022-jpɂ͂܂Ȃɂׂj
		/// </summary>
		private static string specialChar = "[|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||@|A|B|C|D|E|F|G|H|T|U|V|W|X|Y|Z|[|\]";
		/// <summary>
		/// ꕶ񌟍p̐K\
		/// </summary>
		private static Regex regex = new System.Text.RegularExpressions.Regex(specialChar);
		/// <summary>
		/// [AhXɊ܂܂gbvxhC̈ꗗ
		/// </summary>
		static string[] topLevelDomains = new string[]{
														  "jp","kr","com","net","org","biz","info","name","aero","coop","museum","pro","edu",
														  "gov","mil","int","arpa","nato","ac","ad","ae","af","ag","ai","al","am",
														  "an","ao","aq","ar","as","at","au","aw","az","ba","bb","bd","be","bf","bg",
														  "bh","bi","bj","bm","bn","bo","br","bs","bt","bv","bw","by","bz","ca","cc",
														  "cd","cf","cg","ch","ci","ck","cl","cm","cn","co","cr","cu","cv","cx","cy",
														  "cz","de","dj","dk","dm","do","dz","ec","ee","eg","eh","er","es","et","fi",
														  "fj","fk","fm","fo","fr","fx","ga","gb","gd","ge","gf","gg","gh","gi","gl",
														  "gm","gn","gp","gq","gr","gs","gt","gu","gw","gy","hk","hm","hn","hr","ht",
														  "hu","id","ie","il","im","in","io","iq","ir","is","it","je","jm","jo",
														  "ke","kg","kh","ki","km","kn","kp","kw","ky","kz","la","lb","lc","li",
														  "lk","lr","ls","lt","lu","lv","ly","ma","mc","md","mg","mh","mk","ml","mm",
														  "mn","mo","mp","mq","mr","ms","mt","mu","mv","mw","mx","my","mz","na","nc",
														  "ne","nf","ng","ni","nl","no","np","nr","nu","nz","om","pa","pe","pf","pg",
														  "ph","pk","pl","pm","pn","pr","ps","pt","pw","py","qa","re","ro","ru","rw",
														  "sa","sb","sc","sd","se","sg","sh","si","sj","sk","sl","sm","sn","so","sr",
														  "st","sv","sy","sz","tc","td","tf","tg","th","tj","tk","tm","tn","to","tp",
														  "tr","tt","tv","tw","tz","ua","ug","uk","um","us","uy","uz","va","vc","ve",
														  "vg","vi","vn","vu","wf","ws","ye","yt","yu","za","zm","zw"
													  };
		public Validator()
		{
		}

		/// <summary>
		/// [AhX؂
		/// </summary>
		/// <param name="address"></param>
		/// <returns></returns>
		public static bool checkMailAddress(string address) {
			if(address.Length < 6) return false;
			if(address.IndexOf("@") < 1) return false;
			string user = (address.Split('@'))[0];
			string domain = (address.Split('@'))[1];
			if(domain.IndexOf('.') < 1) return false;
			string[] topLevelDomain = (domain.Split('.'));
			if(Validator.notIn(topLevelDomain[topLevelDomain.Length -1],topLevelDomains)) return false;
			return true;
		}

		/// <summary>
		/// [ɎgpׂłȂꕶ܂܂ĂȂ؂B
		/// cOȂAׂĂ̕ԗłĂȂ
		/// </summary>
		/// <param name="str"></param>
		/// <returns></returns>
		public static bool checkSpecialCharcters(string str) {
			if(str == null || str.Equals("")) return true;
			if(regex.IsMatch(str)) return false;
			return true;
		}

		/// <summary>
		/// ɁAƂȂ镶񂪊܂܂ĂȂ؂
		/// </summary>
		/// <param name="str"></param>
		/// <param name="arrays"></param>
		/// <returns></returns>
		public static bool notIn(string str, string[] arrays) {
			for(int i = 0;i < arrays.Length;i++) {
				if(str.Equals(arrays[i])) return false;
			}
			return true;
		}
	}
}
