/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tsukuyomi.japanese;

import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import jp.sourceforge.tsukuyomi.japanese.Consonant;
import jp.sourceforge.tsukuyomi.japanese.Vowel;

public class KanaUtils {
    private static final String[] VOWEL_INDENTIFIER;
    private static final String[] CONSONANT_IDENTIFIER;

    private KanaUtils() {
    }

    public static String toKatakana(String src) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(i);
            if ('\u3040' <= c && c <= '\u309f') {
                sb.append((char)(c - 12352 + 12448));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String toHiragana(String src) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(i);
            if ('\u30a0' <= c && c <= '\u30ff') {
                sb.append((char)(c - 12448 + 12352));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean isHalfWidthKana(char c) {
        return '\uff61' <= c && c <= '\uff9f';
    }

    public static boolean isHiragana(char c) {
        return '\u3040' <= c && c <= '\u309f';
    }

    public static Vowel getVowel(char c) {
        for (int i = 0; i < VOWEL_INDENTIFIER.length; ++i) {
            if (-1 >= VOWEL_INDENTIFIER[i].indexOf(c)) continue;
            return Vowel.values()[i];
        }
        return null;
    }

    public static Consonant getConsonant(char c) {
        for (int i = 0; i < CONSONANT_IDENTIFIER.length; ++i) {
            if (-1 >= CONSONANT_IDENTIFIER[i].indexOf(c)) continue;
            return Consonant.values()[i];
        }
        return null;
    }

    static {
        String v;
        ResourceBundle bundle = ResourceBundle.getBundle("jp/sourceforge/tsukuyomi/japanese/strings", Locale.JAPANESE);
        ArrayList<String> list = new ArrayList<String>();
        for (Vowel vowel : Vowel.values()) {
            v = bundle.getString("vowel." + vowel.toString().toLowerCase());
            list.add(v);
        }
        VOWEL_INDENTIFIER = new String[list.size()];
        list.toArray(VOWEL_INDENTIFIER);
        list = new ArrayList();
        for (Enum enum_ : Consonant.values()) {
            v = bundle.getString("consonant." + enum_.toString().toLowerCase());
            list.add(v);
        }
        CONSONANT_IDENTIFIER = new String[list.size()];
        list.toArray(CONSONANT_IDENTIFIER);
    }
}

