/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.aop;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.seasar.cubby.util.CubbyUtils;
import org.seasar.framework.aop.Pointcut;
import org.seasar.framework.exception.EmptyRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionMethodPointcutImpl
implements Pointcut,
Serializable {
    private static final long serialVersionUID = -5701826062675617117L;
    private String[] methodNames;
    private Pattern[] patterns;

    public ActionMethodPointcutImpl(Class<?> targetClass) throws EmptyRuntimeException {
        if (targetClass == null) {
            throw new EmptyRuntimeException("targetClass");
        }
        this.setMethodNames(ActionMethodPointcutImpl.getMethodNames(targetClass));
    }

    public ActionMethodPointcutImpl(String[] methodNames) throws EmptyRuntimeException {
        if (methodNames == null || methodNames.length == 0) {
            throw new EmptyRuntimeException("methodNames");
        }
        this.setMethodNames(methodNames);
    }

    public boolean isApplied(Method targetMethod) {
        if (!CubbyUtils.isActionMethod(targetMethod)) {
            return false;
        }
        String methodName = targetMethod.getName();
        for (int i = 0; i < this.patterns.length; ++i) {
            if (!this.patterns[i].matcher(methodName).matches()) continue;
            return true;
        }
        return false;
    }

    public String[] getMethodNames() {
        if (this.methodNames == null) {
            return null;
        }
        return (String[])this.methodNames.clone();
    }

    private void setMethodNames(String[] methodNames) {
        this.methodNames = methodNames;
        this.patterns = new Pattern[methodNames.length];
        for (int i = 0; i < this.patterns.length; ++i) {
            this.patterns[i] = Pattern.compile(methodNames[i]);
        }
    }

    private static String[] getMethodNames(Class<?> targetClass) {
        HashSet<String> methodNameSet = new HashSet<String>();
        if (targetClass.isInterface()) {
            ActionMethodPointcutImpl.addInterfaceMethodNames(methodNameSet, targetClass);
        }
        for (Class<?> clazz = targetClass; clazz != Object.class && clazz != null; clazz = clazz.getSuperclass()) {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                ActionMethodPointcutImpl.addInterfaceMethodNames(methodNameSet, interfaces[i]);
            }
        }
        return methodNameSet.toArray(new String[methodNameSet.size()]);
    }

    private static void addInterfaceMethodNames(Set<String> methodNameSet, Class<?> interfaceClass) {
        Method[] methods = interfaceClass.getDeclaredMethods();
        for (int j = 0; j < methods.length; ++j) {
            methodNameSet.add(methods[j].getName());
        }
        Class<?>[] interfaces = interfaceClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            ActionMethodPointcutImpl.addInterfaceMethodNames(methodNameSet, interfaces[i]);
        }
    }
}

