/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.where;

import org.seasar.extension.jdbc.ConditionType;
import org.seasar.extension.jdbc.Where;
import org.seasar.extension.jdbc.where.ComposableWhere;
import org.seasar.extension.jdbc.where.ComposableWhereContext;
import org.seasar.framework.util.StringUtil;

public class SingleValueOperator
extends ComposableWhere {
    protected ConditionType conditionType;
    protected CharSequence propertyName;
    protected Object value;
    protected boolean excludesWhitespace;

    public SingleValueOperator(ConditionType conditionType, CharSequence propertyName, Object value) {
        super(new Where[0]);
        this.conditionType = conditionType;
        this.propertyName = propertyName;
        this.value = value;
    }

    public SingleValueOperator excludesWhitespace() {
        this.excludesWhitespace = true;
        return this;
    }

    protected void visit(ComposableWhereContext context) {
        Object param = this.normalize(this.value);
        if (!this.conditionType.isTarget(param)) {
            return;
        }
        String name = ((Object)this.propertyName).toString();
        context.append(this.conditionType.getCondition(name, param));
        int size = context.addParam(this.conditionType, param);
        for (int i = 0; i < size; ++i) {
            context.addPropertyName(name);
        }
    }

    protected Object normalize(Object value) {
        if (this.excludesWhitespace && value instanceof String && StringUtil.isEmpty((String)((String)String.class.cast(value)).trim())) {
            return null;
        }
        return value;
    }
}

