/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.external.servlet;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.seasar.framework.container.ExternalContext;
import org.seasar.framework.container.external.servlet.CookieMap;
import org.seasar.framework.container.external.servlet.HttpSessionMap;
import org.seasar.framework.container.external.servlet.ServletApplicationMap;
import org.seasar.framework.container.external.servlet.ServletInitParameterMap;
import org.seasar.framework.container.external.servlet.ServletRequestHeaderMap;
import org.seasar.framework.container.external.servlet.ServletRequestHeaderValuesMap;
import org.seasar.framework.container.external.servlet.ServletRequestMap;
import org.seasar.framework.container.external.servlet.ServletRequestParameterMap;
import org.seasar.framework.container.external.servlet.ServletRequestParameterValuesMap;

public class HttpServletExternalContext
implements ExternalContext {
    private ThreadLocal requests = new ThreadLocal();
    private ThreadLocal responses = new ThreadLocal();
    private ServletContext application;

    public Object getRequest() {
        return this.getHttpServletRequest();
    }

    protected HttpServletRequest getHttpServletRequest() {
        return (HttpServletRequest)this.requests.get();
    }

    public void setRequest(Object request) {
        this.requests.set(request);
    }

    public Object getResponse() {
        return this.responses.get();
    }

    public void setResponse(Object response) {
        this.responses.set(response);
    }

    public Object getSession() {
        return this.getHttpSession();
    }

    protected HttpSession getHttpSession() {
        HttpServletRequest request = this.getHttpServletRequest();
        if (request == null) {
            return null;
        }
        return request.getSession();
    }

    public Object getApplication() {
        return this.application;
    }

    public void setApplication(Object application) {
        if (!(application instanceof ServletContext)) {
            throw new IllegalArgumentException("application:" + application);
        }
        this.application = (ServletContext)application;
    }

    public Map getApplicationMap() {
        return new ServletApplicationMap(this.application);
    }

    public Map getInitParameterMap() {
        return new ServletInitParameterMap(this.application);
    }

    public Map getRequestCookieMap() {
        HttpServletRequest request = this.getHttpServletRequest();
        if (request == null) {
            return Collections.EMPTY_MAP;
        }
        return new CookieMap(request);
    }

    public Map getRequestHeaderMap() {
        HttpServletRequest request = this.getHttpServletRequest();
        if (request == null) {
            return Collections.EMPTY_MAP;
        }
        return new ServletRequestHeaderMap(request);
    }

    public Map getRequestHeaderValuesMap() {
        HttpServletRequest request = this.getHttpServletRequest();
        if (request == null) {
            return Collections.EMPTY_MAP;
        }
        return new ServletRequestHeaderValuesMap(request);
    }

    public Map getRequestMap() {
        HttpServletRequest request = this.getHttpServletRequest();
        if (request == null) {
            return new HashMap();
        }
        return new ServletRequestMap((ServletRequest)request);
    }

    public Map getRequestParameterMap() {
        HttpServletRequest request = this.getHttpServletRequest();
        if (request == null) {
            return Collections.EMPTY_MAP;
        }
        return new ServletRequestParameterMap((ServletRequest)request);
    }

    public Map getRequestParameterValuesMap() {
        HttpServletRequest request = this.getHttpServletRequest();
        if (request == null) {
            return Collections.EMPTY_MAP;
        }
        return new ServletRequestParameterValuesMap((ServletRequest)request);
    }

    public Map getSessionMap() {
        HttpServletRequest request = this.getHttpServletRequest();
        if (request == null) {
            return new HashMap();
        }
        return new HttpSessionMap(request);
    }
}

