/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.query;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.seasar.extension.jdbc.AutoUpdate;
import org.seasar.extension.jdbc.ConditionType;
import org.seasar.extension.jdbc.PropertyMeta;
import org.seasar.extension.jdbc.SetClause;
import org.seasar.extension.jdbc.WhereClause;
import org.seasar.extension.jdbc.manager.JdbcManagerImplementor;
import org.seasar.extension.jdbc.query.AbstractAutoUpdate;
import org.seasar.framework.util.FieldUtil;
import org.seasar.framework.util.IntegerConversionUtil;
import org.seasar.framework.util.LongConversionUtil;
import org.seasar.framework.util.tiger.CollectionsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoUpdateImpl<T>
extends AbstractAutoUpdate<T, AutoUpdate<T>>
implements AutoUpdate<T> {
    protected static final String UPDATE_STATEMENT = "update ";
    protected boolean includeVersion;
    protected boolean excludesNull;
    protected final Set<String> includesProperties = CollectionsUtil.newHashSet();
    protected final Set<String> excludesProperties = CollectionsUtil.newHashSet();
    protected Map<String, Object> beforeStates;
    protected final List<PropertyMeta> targetProperties = CollectionsUtil.newArrayList();
    protected final SetClause setClause = new SetClause();
    protected final WhereClause whereClause = new WhereClause();

    public AutoUpdateImpl(JdbcManagerImplementor jdbcManager, T entity) {
        super(jdbcManager, entity);
    }

    @Override
    public AutoUpdate<T> includesVersion() {
        this.includeVersion = true;
        return this;
    }

    @Override
    public AutoUpdate<T> excludesNull() {
        this.excludesNull = true;
        return this;
    }

    @Override
    public AutoUpdate<T> includes(String ... propertyNames) {
        this.includesProperties.addAll(Arrays.asList(propertyNames));
        return this;
    }

    @Override
    public AutoUpdate<T> excludes(String ... propertyNames) {
        this.excludesProperties.addAll(Arrays.asList(propertyNames));
        return this;
    }

    @Override
    public AutoUpdate<T> changedFrom(T beforeEntity) {
        this.beforeStates = CollectionsUtil.newHashMap(this.entityMeta.getPropertyMetaSize());
        for (PropertyMeta propertyMeta : this.entityMeta.getAllPropertyMeta()) {
            String propertyName = propertyMeta.getName();
            Object value = FieldUtil.get((Field)propertyMeta.getField(), beforeEntity);
            this.beforeStates.put(propertyName, value);
        }
        return this;
    }

    @Override
    public AutoUpdate<T> changedFrom(Map<String, ? extends Object> beforeStates) {
        this.beforeStates = CollectionsUtil.newHashMap(beforeStates.size());
        this.beforeStates.putAll(beforeStates);
        return this;
    }

    @Override
    public AutoUpdate<T> suppresOptimisticLockException() {
        this.suppresOptimisticLockException = true;
        return this;
    }

    @Override
    protected void prepare(String methodName) {
        this.prepareCallerClassAndMethodName(methodName);
        this.prepareTargetProperties();
        this.prepareSetClause();
        this.prepareWhereClause();
        this.prepareParams();
        this.prepareSql();
    }

    protected void prepareTargetProperties() {
        for (PropertyMeta propertyMeta : this.entityMeta.getAllColumnPropertyMeta()) {
            Object oldValue;
            String propertyName = propertyMeta.getName();
            Field field = propertyMeta.getField();
            Object value = FieldUtil.get((Field)field, (Object)this.entity);
            if (propertyMeta.isId() || !propertyMeta.getColumnMeta().isUpdatable() || propertyMeta.isVersion() && !this.includeVersion || !this.includesProperties.isEmpty() && !this.includesProperties.contains(propertyName) || this.excludesProperties.contains(propertyName) || this.excludesNull && value == null || this.beforeStates != null && (value == (oldValue = this.beforeStates.get(propertyName)) || value != null && value.equals(oldValue))) continue;
            this.targetProperties.add(propertyMeta);
        }
    }

    protected void prepareSetClause() {
        for (PropertyMeta propertyMeta : this.targetProperties) {
            this.setClause.addSql(propertyMeta.getColumnMeta().getName());
        }
        if (!this.includeVersion && this.entityMeta.hasVersionPropertyMeta()) {
            PropertyMeta propertyMeta = this.entityMeta.getVersionPropertyMeta();
            String columnName = propertyMeta.getColumnMeta().getName();
            this.setClause.addSql(columnName, columnName + " + 1");
        }
    }

    protected void prepareWhereClause() {
        for (PropertyMeta propertyMeta : this.entityMeta.getIdPropertyMetaList()) {
            this.whereClause.addAndSql(ConditionType.EQ.getCondition(propertyMeta.getColumnMeta().getName(), null));
        }
        if (!this.includeVersion && this.entityMeta.hasVersionPropertyMeta()) {
            PropertyMeta propertyMeta = this.entityMeta.getVersionPropertyMeta();
            this.whereClause.addAndSql(ConditionType.EQ.getCondition(propertyMeta.getColumnMeta().getName(), null));
        }
    }

    protected void prepareParams() {
        Object value;
        for (PropertyMeta propertyMeta : this.targetProperties) {
            value = FieldUtil.get((Field)propertyMeta.getField(), (Object)this.entity);
            this.addParam(value, propertyMeta);
        }
        for (PropertyMeta propertyMeta : this.entityMeta.getIdPropertyMetaList()) {
            value = FieldUtil.get((Field)propertyMeta.getField(), (Object)this.entity);
            this.addParam(value, propertyMeta);
        }
        if (!this.includeVersion && this.entityMeta.hasVersionPropertyMeta()) {
            PropertyMeta propertyMeta = this.entityMeta.getVersionPropertyMeta();
            Object value2 = FieldUtil.get((Field)propertyMeta.getField(), (Object)this.entity);
            this.addParam(value2, propertyMeta);
        }
    }

    @Override
    protected String toSql() {
        String tableName = this.entityMeta.getTableMeta().getFullName();
        StringBuilder buf = new StringBuilder(UPDATE_STATEMENT.length() + tableName.length() + this.setClause.getLength() + this.whereClause.getLength());
        return new String(buf.append(UPDATE_STATEMENT).append(tableName).append(this.setClause.toSql()).append(this.whereClause.toSql()));
    }

    @Override
    protected boolean isOptimisticLock() {
        return !this.includeVersion && this.entityMeta.hasVersionPropertyMeta();
    }

    @Override
    protected void incrementVersion() {
        if (this.includeVersion) {
            return;
        }
        Field field = this.entityMeta.getVersionPropertyMeta().getField();
        if (field.getType() == Integer.TYPE || field.getType() == Integer.class) {
            int version = IntegerConversionUtil.toPrimitiveInt((Object)FieldUtil.get((Field)field, (Object)this.entity)) + 1;
            FieldUtil.set((Field)field, (Object)this.entity, (Object)version);
        } else if (field.getType() == Long.TYPE || field.getType() == Long.class) {
            long version = LongConversionUtil.toPrimitiveLong((Object)FieldUtil.get((Field)field, (Object)this.entity)) + 1L;
            FieldUtil.set((Field)field, (Object)this.entity, (Object)version);
        }
    }
}

