/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tsukuyomi.openid.message.sreg;

import jp.sourceforge.tsukuyomi.openid.message.MessageException;
import jp.sourceforge.tsukuyomi.openid.message.MessageExtension;
import jp.sourceforge.tsukuyomi.openid.message.MessageExtensionFactory;
import jp.sourceforge.tsukuyomi.openid.message.ParameterList;
import jp.sourceforge.tsukuyomi.openid.message.sreg.SRegRequest;
import jp.sourceforge.tsukuyomi.openid.message.sreg.SRegResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SRegMessage
implements MessageExtension,
MessageExtensionFactory {
    private static final Log LOG = LogFactory.getLog(SRegMessage.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();
    public static final String OPENID_NS_SREG = "http://openid.net/sreg/1.0";
    protected ParameterList parameters;

    public SRegMessage() {
        this.parameters = new ParameterList();
        if (DEBUG) {
            LOG.debug((Object)"Created empty SRegMessage.");
        }
    }

    public SRegMessage(ParameterList params) {
        this.parameters = params;
        if (DEBUG) {
            LOG.debug((Object)("Created SRegMessage from parameter list:\n" + params));
        }
    }

    public String getTypeUri() {
        return OPENID_NS_SREG;
    }

    public ParameterList getParameters() {
        return this.parameters;
    }

    public String getParameterValue(String name) {
        return this.parameters.getParameterValue(name);
    }

    public void setParameters(ParameterList params) {
        this.parameters = params;
    }

    public String multivalEncode(String value) {
        return value.replaceAll("\\\\", "\\\\\\\\").replaceAll(",", "\\\\,");
    }

    public String multivalDecode(String value) {
        return value.replaceAll("\\\\,", ",").replaceAll("\\\\\\\\", "\\\\");
    }

    public boolean providesIdentifier() {
        return false;
    }

    public MessageExtension getExtension(ParameterList parameterList, boolean isRequest) throws MessageException {
        if (parameterList.hasParameter("required") || parameterList.hasParameter("optional")) {
            return SRegRequest.createSRegRequest(parameterList);
        }
        return SRegResponse.createSRegResponse(parameterList);
    }
}

