/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.validator.validators;

import org.seasar.cubby.validator.MessageHelper;
import org.seasar.cubby.validator.ScalarFieldValidator;
import org.seasar.cubby.validator.ValidationContext;
import org.seasar.framework.util.StringUtil;

public class RangeValidator
implements ScalarFieldValidator {
    private final MessageHelper messageHelper;
    private final long min;
    private final long max;

    public RangeValidator(long min, long max) {
        this(min, max, "valid.range");
    }

    public RangeValidator(long min, long max, String messageKey) {
        this.min = min;
        this.max = max;
        this.messageHelper = new MessageHelper(messageKey);
    }

    public void validate(ValidationContext context, Object value) {
        if (value instanceof String) {
            String str = (String)value;
            if (StringUtil.isEmpty((String)str)) {
                return;
            }
            try {
                long longValue = Long.parseLong(str);
                if (longValue >= this.min && longValue <= this.max) {
                    return;
                }
            }
            catch (NumberFormatException e) {}
        } else if (value == null) {
            return;
        }
        context.addMessageInfo(this.messageHelper.createMessageInfo(this.min, this.max));
    }
}

