/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.controller;

import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.seasar.cubby.controller.CubbyConfiguration;
import org.seasar.cubby.controller.MessagesBehaviour;
import org.seasar.cubby.controller.impl.DefaultMessagesBehaviour;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadContext {
    private static final MessagesBehaviour DEFAULT_MESSAGES_BEHAVIOUR = new DefaultMessagesBehaviour();
    private static final ThreadLocal<ThreadContext> CONTEXT = new ThreadLocal<ThreadContext>(){

        @Override
        protected ThreadContext initialValue() {
            return new ThreadContext();
        }
    };
    private HttpServletRequest request;
    private ResourceBundle messagesResourceBundle = null;
    private Map<String, String> messages = null;
    private MessagesBehaviour messagesBehaviour;

    public static void remove() {
        CONTEXT.remove();
    }

    public static HttpServletRequest getRequest() {
        return ThreadContext.CONTEXT.get().request;
    }

    public static void setRequest(HttpServletRequest request) {
        ThreadContext.CONTEXT.get().request = request;
    }

    public static CubbyConfiguration getConfiguration() {
        S2Container container = SingletonS2ContainerFactory.getContainer();
        return (CubbyConfiguration)container.getComponent(CubbyConfiguration.class);
    }

    public static ResourceBundle getMessagesResourceBundle() {
        ThreadContext context = CONTEXT.get();
        if (context.messagesResourceBundle == null) {
            MessagesBehaviour messagesBehaviour = ThreadContext.getMessagesBehaviour(context);
            context.messagesResourceBundle = messagesBehaviour.getBundle(context.request == null ? null : context.request.getLocale());
        }
        return context.messagesResourceBundle;
    }

    public static Map<String, String> getMessagesMap() {
        ThreadContext context = CONTEXT.get();
        if (context.messages == null) {
            ResourceBundle bundle = ThreadContext.getMessagesResourceBundle();
            MessagesBehaviour messagesBehaviour = ThreadContext.getMessagesBehaviour(context);
            context.messages = messagesBehaviour.toMap(bundle);
        }
        return context.messages;
    }

    private static MessagesBehaviour getMessagesBehaviour(ThreadContext context) {
        if (context.messagesBehaviour == null) {
            S2Container container = SingletonS2ContainerFactory.getContainer();
            context.messagesBehaviour = container.hasComponentDef(MessagesBehaviour.class) ? (MessagesBehaviour)container.getComponent(MessagesBehaviour.class) : DEFAULT_MESSAGES_BEHAVIOUR;
        }
        return context.messagesBehaviour;
    }

    private ThreadContext() {
    }
}

