/*
 * Copyright 2006-2007 Sxip Identity Corporation
 */

package jp.sourceforge.tsukuyomi.openid.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * A date formatter based on the Internet Date/Time format. This is defined in
 * section 5.6 of RFC 3339.
 * 
 * <p>
 * A date formatted in this way looks like:<br />
 * <b><code>2005-05-15T17:11:51Z</code></b>
 * 
 * @see <a href="http://www.ietf.org/rfc/rfc3339.txt">RFC 3339: section 5.6</a>
 * @author Marius Scurtescu, Johnny Bufu
 */
public class InternetDateFormat extends SimpleDateFormat {
	private static final long serialVersionUID = -3325703536403739212L;
	private static final Log LOG = LogFactory.getLog(InternetDateFormat.class);
	private static final boolean DEBUG = LOG.isDebugEnabled();

	public static final String PATTERN = "yyyy-MM-dd'T'HH:mm:ss'Z'";
	public static final TimeZone GMT_TIME_ZONE = TimeZone.getTimeZone("GMT");

	public InternetDateFormat() {
		super(PATTERN, Locale.US);
		setTimeZone(GMT_TIME_ZONE);
	}

	@Override
	public Date parse(String source) throws ParseException {
		Date date = super.parse(source.toUpperCase());

		if (DEBUG) {
			LOG.debug("Parsed " + source + " into Data object: " + date);
		}

		return date;
	}
}
