package jp.sourceforge.tsukuyomi.openid.rp;

import java.util.List;

import jp.sourceforge.tsukuyomi.openid.association.AssociationException;
import jp.sourceforge.tsukuyomi.openid.discovery.DiscoveryException;
import jp.sourceforge.tsukuyomi.openid.discovery.DiscoveryInformation;
import jp.sourceforge.tsukuyomi.openid.discovery.IdentifierException;
import jp.sourceforge.tsukuyomi.openid.message.AuthRequest;
import jp.sourceforge.tsukuyomi.openid.message.MessageException;
import jp.sourceforge.tsukuyomi.openid.message.ParameterList;

public interface RelayParty {
	List<DiscoveryInformation> discover(String identifier)
			throws DiscoveryException, IdentifierException;

	DiscoveryInformation associate(List<DiscoveryInformation> discoveries);

	AuthRequest authenticate(DiscoveryInformation discovered, String returnToUrl)
			throws MessageException, RelayPartyException;

	VerificationResult verify(String receivingUrl, ParameterList response,
			DiscoveryInformation discovered) throws MessageException,
			DiscoveryException, AssociationException, IdentifierException;
}
