/*
 * Copyright 2006-2007 Sxip Identity Corporation
 */

package jp.sourceforge.tsukuyomi.openid.op.impl;

import java.util.Date;

import jp.sourceforge.tsukuyomi.openid.op.NonceGenerator;
import jp.sourceforge.tsukuyomi.openid.util.InternetDateFormat;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author Marius Scurtescu, Johnny Bufu
 */
public class IncrementalNonceGenerator implements NonceGenerator {
	private static final Log LOG =
		LogFactory.getLog(IncrementalNonceGenerator.class);
	private static final boolean DEBUG = LOG.isDebugEnabled();

	private String timestamp = "";
	private int counter = 0;

	public synchronized String next() {
		String currentTimestamp = getCurrentTimpestamp();

		if (timestamp.equals(currentTimestamp)) {
			counter++;
		} else {
			timestamp = currentTimestamp;
			counter = 0;
		}

		String nonce = timestamp + Integer.toString(counter);

		if (DEBUG) {
			LOG.debug("Generated nonce: " + nonce);
		}

		return nonce;

	}

	private String getCurrentTimpestamp() {
		Date now = new Date();
		InternetDateFormat dateFormat = new InternetDateFormat();

		return dateFormat.format(now);
	}
}
