/*
 * Copyright 2006-2007 Sxip Identity Corporation
 */

package jp.sourceforge.tsukuyomi.openid.message;

import java.util.Arrays;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author Marius Scurtescu, Johnny Bufu
 */
public class DirectError extends Message {
	private static final Log LOG = LogFactory.getLog(DirectError.class);

	protected final static List<String> REQUIRED_FIELDS =
		Arrays.asList(new String[] { "ns", "error" });

	protected final static List<String> OPTIONAL_FIELDS =
		Arrays.asList(new String[] { "contact", "reference" });

	protected DirectError(String msg) {
		this(msg, false);
	}

	protected DirectError(String msg, boolean compatibility) {
		set("error", msg);

		if (compatibility) {
			set("ns", OPENID2_NS);
		}
	}

	protected DirectError(ParameterList params) {
		super(params);
	}

	public static DirectError createDirectError(String msg) {
		return createDirectError(msg, false);
	}

	public static DirectError createDirectError(String msg,
			boolean compatibility) {
		DirectError err = new DirectError(msg, compatibility);

		if (!err.isValid()) {
			LOG.error("Invalid "
				+ (compatibility ? "OpenID1" : "OpenID2")
				+ " direct error message created for message: "
				+ msg);
		}

		LOG.debug("Created direct error message:\n"
			+ err.keyValueFormEncoding());

		return err;
	}

	public static DirectError createDirectError(ParameterList params) {
		DirectError err = new DirectError(params);

		if (!err.isValid()) {
			LOG.error("Invalid direct error message created: "
				+ err.keyValueFormEncoding());
		}

		LOG.debug("Created direct error message:\n"
			+ err.keyValueFormEncoding());

		return err;
	}

	@Override
	public List<String> getRequiredFields() {
		return REQUIRED_FIELDS;
	}

	public boolean isVersion2() {
		return hasParameter("ns") && OPENID2_NS.equals(getParameterValue("ns"));
	}

	public void setErrorMsg(String msg) {
		set("error", msg);
	}

	public String getErrorMsg() {
		return getParameterValue("error");
	}

	public void setContact(String contact) {
		set("contact", contact);
	}

	public void setReference(String reference) {
		set("reference", reference);
	}
}
