/*
 * Copyright 2006-2007 Sxip Identity Corporation
 */

package jp.sourceforge.tsukuyomi.openid.message;

import java.util.Arrays;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author Marius Scurtescu, Johnny Bufu
 */
public class AuthFailure extends Message {
	private static final Log LOG = LogFactory.getLog(AuthFailure.class);
	private static final boolean DEBUG = LOG.isDebugEnabled();

	protected static final List<String> REQUIRED_FIELDS =
		Arrays.asList(new String[] { "openid.mode" });

	protected static final List<String> OPTIONAL_FIELDS =
		Arrays.asList(new String[] { "openid.ns" });

	public AuthFailure(boolean compatibility, String returnTo) {
		set("openid.mode", MODE_CANCEL);

		if (!compatibility) {
			set("openid.ns", OPENID2_NS);
		}

		destinationUrl = returnTo;
	}

	protected AuthFailure(ParameterList params) {
		super(params);
	}

	public static AuthFailure createAuthFailure(ParameterList params)
			throws MessageException {
		AuthFailure fail = new AuthFailure(params);

		if (!fail.isValid()) {
			throw new MessageException(
				"Invalid set of parameters for the requested message type");
		}

		if (DEBUG) {
			LOG.debug("Retrieved auth failure from message parameters:\n"
				+ fail.keyValueFormEncoding());
		}

		return fail;
	}

	@Override
	public List<String> getRequiredFields() {
		return REQUIRED_FIELDS;
	}

	public boolean isVersion2() {
		return hasParameter("openid.ns")
			&& OPENID2_NS.equals(getParameterValue("openid.ns"));
	}

	@Override
	public boolean isValid() {
		if (!super.isValid()) {
			return false;
		}

		return MODE_CANCEL.equals(getParameterValue("openid.mode"));
	}
}
