package jp.sourceforge.tsukuyomi.openid.discovery;

import org.openxri.XRI;

public class XriIdentifier implements Identifier {
	private static final long serialVersionUID = -215270939966252358L;

	private XRI xriIdentifier;

	public XriIdentifier(String identifier) {
		// should be in the canonical form
		xriIdentifier = new XRI(identifier);
	}

	@Override
	public boolean equals(Object o) {
		if (this == o) {
			return true;
		}

		if (o == null || getClass() != o.getClass()) {
			return false;
		}

		final XriIdentifier that = (XriIdentifier) o;

		// workaround, XRI should properly implement equals
		String thisNormalForm = this.xriIdentifier.toIRINormalForm();
		String thatNormalForm = that.xriIdentifier.toIRINormalForm();

		return thisNormalForm.equals(thatNormalForm);
	}

	@Override
	public int hashCode() {
		return xriIdentifier.hashCode();
	}

	public String getIdentifier() {
		return xriIdentifier.toString();
	}

	public XRI getXriIdentifier() {
		return xriIdentifier;
	}
}
