package jp.sourceforge.tsukuyomi.openid;

/**
 * OpenID に関するユーティリティクラスです。
 * 
 * @author asuka
 */
public class OpenID {
	private static final String OPENID2 =
		"http://specs.openid.net/auth/2.0/signon";
	private static final String OPENID2_OP =
		"http://specs.openid.net/auth/2.0/server";

	private OpenID() {
		// 何もしない
	}

	/**
	 * OpenID のバージョン表記からバージョン 2 かどうかを取得します。
	 * 
	 * @param version
	 *            バージョン表記
	 * @return バージョン 2 の場合 true
	 * @see OpenIDConsumer#associate()
	 */
	public static boolean isVersion2(String version) {
		if (version == null || version.length() == 0) {
			return false;
		}

		return OPENID2.equals(version) || OPENID2_OP.equals(version);
	}
}
