package jp.sourceforge.tsukuyomi.openid;

import java.util.ResourceBundle;

/**
 * Tsukuyomi OpenID で使用する定数を定義するクラスです。
 * 
 * @author asuka
 * 
 */
public class Consts {
	/**
	 * メッセージリソースなどのキーに用いるプレフィックスです。
	 */
	public static final String KEY_PREFIX = "jp.sourceforge.tsukuyomi.openid.";

	/**
	 * Tsukuyomi OpenID 内で使用するメッセージのリソースバンドルです。
	 */
	public static final ResourceBundle BUNDLE =
		ResourceBundle.getBundle("jp/sourceforge/tsukuyomi/openid/messages");

	/**
	 * ディスカバリー情報をセッションに保存しておくためのキーです。
	 */
	public static final String SN_DISCOVERED =
		"jp.sourceforge.tsukuyomi." + "openid.discovered";

	private Consts() {
		// 何もしない
	}
}
