/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tsukuyomi.openid.rp.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import jp.sourceforge.tsukuyomi.openid.association.Association;
import jp.sourceforge.tsukuyomi.openid.rp.ConsumerAssociationStore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InMemoryConsumerAssociationStore
implements ConsumerAssociationStore {
    private static final Log LOG = LogFactory.getLog(InMemoryConsumerAssociationStore.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();
    private Map<String, Map<String, Association>> idpMap = new HashMap<String, Map<String, Association>>();

    public synchronized void save(String idpUrl, Association association) {
        this.removeExpired();
        Map<String, Association> handleMap = this.idpMap.get(idpUrl);
        if (handleMap == null) {
            handleMap = new HashMap<String, Association>();
            this.idpMap.put(idpUrl, handleMap);
        }
        String handle = association.getHandle();
        if (DEBUG) {
            LOG.debug((Object)("Adding association to the in-memory store: " + handle + " with OP: " + idpUrl));
        }
        handleMap.put(association.getHandle(), association);
    }

    public synchronized Association load(String idpUrl, String handle) {
        Map<String, Association> handleMap;
        this.removeExpired();
        if (this.idpMap.containsKey(idpUrl) && (handleMap = this.idpMap.get(idpUrl)).containsKey(handle)) {
            return handleMap.get(handle);
        }
        return null;
    }

    public synchronized Association load(String idpUrl) {
        this.removeExpired();
        Association latest = null;
        if (this.idpMap.containsKey(idpUrl)) {
            Map<String, Association> handleMap = this.idpMap.get(idpUrl);
            for (Map.Entry<String, Association> ent : handleMap.entrySet()) {
                Association association = ent.getValue();
                if (latest != null && !latest.getExpiry().before(association.getExpiry())) continue;
                latest = association;
            }
        }
        return latest;
    }

    public synchronized void remove(String idpUrl, String handle) {
        this.removeExpired();
        if (this.idpMap.containsKey(idpUrl)) {
            Map<String, Association> handleMap = this.idpMap.get(idpUrl);
            LOG.info((Object)("Removing association: " + handle + " widh OP: " + idpUrl));
            handleMap.remove(handle);
            if (handleMap.size() == 0) {
                this.idpMap.remove(idpUrl);
            }
        }
    }

    private synchronized void removeExpired() {
        HashSet<String> idpToRemove = new HashSet<String>();
        for (Map.Entry<String, Map<String, Association>> ent : this.idpMap.entrySet()) {
            String idpUrl = ent.getKey();
            Map<String, Association> handleMap = ent.getValue();
            HashSet<String> handleToRemove = new HashSet<String>();
            for (Map.Entry<String, Association> ent2 : handleMap.entrySet()) {
                String handle = ent2.getKey();
                Association association = ent2.getValue();
                if (!association.hasExpired()) continue;
                handleToRemove.add(handle);
            }
            for (String handle : handleToRemove) {
                LOG.info((Object)("Removing expired association: " + handle + " with OP: " + idpUrl));
                handleMap.remove(handle);
            }
            if (handleMap.size() != 0) continue;
            idpToRemove.add(idpUrl);
        }
        for (String idpUrl : idpToRemove) {
            this.idpMap.remove(idpUrl);
        }
    }

    public synchronized int size() {
        int total = 0;
        for (Map<String, Association> handleMap : this.idpMap.values()) {
            total += handleMap.size();
        }
        return total;
    }
}

