/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tsukuyomi.openid.message;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import jp.sourceforge.tsukuyomi.openid.message.MessageException;
import jp.sourceforge.tsukuyomi.openid.message.Parameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterList
implements Serializable {
    private static final long serialVersionUID = 5250211330154176713L;
    private static final Log LOG = LogFactory.getLog(ParameterList.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();
    private Map<String, Parameter> parameterMap;

    public ParameterList() {
        this.parameterMap = new LinkedHashMap<String, Parameter>();
        if (DEBUG) {
            LOG.debug((Object)"Created empty parameter list.");
        }
    }

    public ParameterList(ParameterList that) {
        if (DEBUG) {
            LOG.debug((Object)("Cloning parameter list:\n" + that));
        }
        this.parameterMap = new LinkedHashMap<String, Parameter>(that.parameterMap);
    }

    public ParameterList(Map<?, ?> parameterMap) {
        this.parameterMap = new LinkedHashMap<String, Parameter>();
        for (Map.Entry<?, ?> entry : parameterMap.entrySet()) {
            String value;
            String name = (String)entry.getKey();
            Object v = entry.getValue();
            if (v instanceof Object[]) {
                Object[] values = (Object[])v;
                if (values.length > 1) {
                    throw new IllegalArgumentException("Multiple parameters with the same name: " + Arrays.toString(values));
                }
                value = values.length > 0 ? (String)values[0] : null;
            } else {
                value = (String)v;
            }
            this.set(new Parameter(name, value));
        }
        if (DEBUG) {
            LOG.debug((Object)("Creating parameter list:\n" + this));
        }
    }

    public void copyOf(ParameterList that) {
        if (DEBUG) {
            LOG.debug((Object)("Copying parameter list:\n" + that));
        }
        this.parameterMap = new LinkedHashMap<String, Parameter>(that.parameterMap);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ParameterList that = (ParameterList)obj;
        return ((Object)this.parameterMap).equals(that.parameterMap);
    }

    public int hashCode() {
        return ((Object)this.parameterMap).hashCode();
    }

    public void set(Parameter parameter) {
        this.parameterMap.put(parameter.getKey(), parameter);
    }

    public void addParams(ParameterList params) {
        for (Parameter param : params.getParameters()) {
            this.set(param);
        }
    }

    public Parameter getParameter(String name) {
        return this.parameterMap.get(name);
    }

    public String getParameterValue(String name) {
        Parameter param = this.getParameter(name);
        return param != null ? param.getValue() : null;
    }

    public List<Parameter> getParameters() {
        return new ArrayList<Parameter>(this.parameterMap.values());
    }

    public void removeParameters(String name) {
        this.parameterMap.remove(name);
    }

    public boolean hasParameter(String name) {
        return this.parameterMap.containsKey(name);
    }

    public static ParameterList createFromQueryString(String queryString) throws MessageException {
        if (DEBUG) {
            LOG.debug((Object)("Creating parameter list from query string: " + queryString));
        }
        ParameterList parameterList = new ParameterList();
        StringTokenizer tokenizer = new StringTokenizer(queryString, "&");
        while (tokenizer.hasMoreTokens()) {
            String keyValue = tokenizer.nextToken();
            int posEqual = keyValue.indexOf(61);
            if (posEqual == -1) {
                throw new MessageException("Invalid query parameter, = missing: " + keyValue);
            }
            try {
                String key = URLDecoder.decode(keyValue.substring(0, posEqual), "UTF-8");
                String value = URLDecoder.decode(keyValue.substring(posEqual + 1), "UTF-8");
                parameterList.set(new Parameter(key, value));
            }
            catch (UnsupportedEncodingException e) {
                throw new MessageException("Cannot URL decode query parameter: " + keyValue, e);
            }
        }
        return parameterList;
    }

    public static ParameterList createFromKeyValueForm(String keyValueForm) throws MessageException {
        if (DEBUG) {
            LOG.debug((Object)("Creating parameter list from key-value form:\n" + keyValueForm));
        }
        ParameterList parameterList = new ParameterList();
        StringTokenizer tokenizer = new StringTokenizer(keyValueForm, "\n");
        while (tokenizer.hasMoreTokens()) {
            String keyValue = tokenizer.nextToken();
            int posColon = keyValue.indexOf(58);
            if (posColon == -1) {
                throw new MessageException("Invalid Key-Value form, colon missing: " + keyValue);
            }
            String key = keyValue.substring(0, posColon);
            String value = keyValue.substring(posColon + 1);
            parameterList.set(new Parameter(key, value));
        }
        return parameterList;
    }

    public String toString() {
        StringBuffer allParams = new StringBuffer("");
        for (Parameter parameter : this.getParameters()) {
            allParams.append(parameter.getKey());
            allParams.append(':');
            allParams.append(parameter.getValue());
            allParams.append('\n');
        }
        return allParams.toString();
    }
}

