/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tsukuyomi.openid.message;

import java.util.Arrays;
import java.util.List;
import jp.sourceforge.tsukuyomi.openid.message.Message;
import jp.sourceforge.tsukuyomi.openid.message.ParameterList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectError
extends Message {
    private static final Log LOG = LogFactory.getLog(DirectError.class);
    protected static final List<String> REQUIRED_FIELDS = Arrays.asList("ns", "error");
    protected static final List<String> OPTIONAL_FIELDS = Arrays.asList("contact", "reference");

    protected DirectError(String msg) {
        this(msg, false);
    }

    protected DirectError(String msg, boolean compatibility) {
        this.set("error", msg);
        if (compatibility) {
            this.set("ns", "http://specs.openid.net/auth/2.0");
        }
    }

    protected DirectError(ParameterList params) {
        super(params);
    }

    public static DirectError createDirectError(String msg) {
        return DirectError.createDirectError(msg, false);
    }

    public static DirectError createDirectError(String msg, boolean compatibility) {
        DirectError err = new DirectError(msg, compatibility);
        if (!err.isValid()) {
            LOG.error((Object)("Invalid " + (compatibility ? "OpenID1" : "OpenID2") + " direct error message created for message: " + msg));
        }
        LOG.debug((Object)("Created direct error message:\n" + err.keyValueFormEncoding()));
        return err;
    }

    public static DirectError createDirectError(ParameterList params) {
        DirectError err = new DirectError(params);
        if (!err.isValid()) {
            LOG.error((Object)("Invalid direct error message created: " + err.keyValueFormEncoding()));
        }
        LOG.debug((Object)("Created direct error message:\n" + err.keyValueFormEncoding()));
        return err;
    }

    @Override
    public List<String> getRequiredFields() {
        return REQUIRED_FIELDS;
    }

    public boolean isVersion2() {
        return this.hasParameter("ns") && "http://specs.openid.net/auth/2.0".equals(this.getParameterValue("ns"));
    }

    public void setErrorMsg(String msg) {
        this.set("error", msg);
    }

    public String getErrorMsg() {
        return this.getParameterValue("error");
    }

    public void setContact(String contact) {
        this.set("contact", contact);
    }

    public void setReference(String reference) {
        this.set("reference", reference);
    }
}

