/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tsukuyomi.openid.impl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.sourceforge.tsukuyomi.openid.AuthenticationRequest;
import jp.sourceforge.tsukuyomi.openid.Consts;
import jp.sourceforge.tsukuyomi.openid.OpenIDConsumer;
import jp.sourceforge.tsukuyomi.openid.OpenIDException;
import jp.sourceforge.tsukuyomi.openid.OpenIDRuntimeException;
import jp.sourceforge.tsukuyomi.openid.discovery.DiscoveryException;
import jp.sourceforge.tsukuyomi.openid.discovery.DiscoveryInformation;
import jp.sourceforge.tsukuyomi.openid.discovery.Identifier;
import jp.sourceforge.tsukuyomi.openid.discovery.IdentifierException;
import jp.sourceforge.tsukuyomi.openid.impl.AuthenticationRequestImpl;
import jp.sourceforge.tsukuyomi.openid.message.AuthRequest;
import jp.sourceforge.tsukuyomi.openid.message.ParameterList;
import jp.sourceforge.tsukuyomi.openid.rp.RelayParty;
import jp.sourceforge.tsukuyomi.openid.rp.RelayPartyConfig;
import jp.sourceforge.tsukuyomi.openid.rp.VerificationResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OpenIDConsumerImpl
implements OpenIDConsumer {
    private static final Log LOG = LogFactory.getLog(OpenIDConsumerImpl.class);
    private DiscoveryInformation discovered;
    private List<DiscoveryInformation> discoveryList;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private String version;
    private RelayParty relayParty;
    private RelayPartyConfig relayPartyConfig;

    public boolean findProvider(String identifier) {
        if (identifier == null) {
            return false;
        }
        try {
            this.discoveryList = this.relayParty.discover(identifier);
            return true;
        }
        catch (DiscoveryException e) {
            LOG.debug((Object)("identifier=" + identifier), (Throwable)e);
            return false;
        }
        catch (IdentifierException e) {
            LOG.debug((Object)("identifier=" + identifier), (Throwable)e);
            return false;
        }
    }

    public String associate() {
        if (this.discoveryList == null) {
            String s = Consts.BUNDLE.getString("jp.sourceforge.tsukuyomi.openid.DiscoveryListIsNull");
            throw new IllegalStateException(s);
        }
        this.discovered = this.relayParty.associate(this.discoveryList);
        HttpSession session = this.request.getSession(true);
        session.setAttribute("jp.sourceforge.tsukuyomi.openid.discovered", (Object)this.discovered);
        this.version = this.discovered.getVersion();
        return this.version;
    }

    public AuthenticationRequest getAuthenticationRequest() {
        if (this.discovered == null) {
            String s = Consts.BUNDLE.getString("jp.sourceforge.tsukuyomi.openid.DiscoveredIsNull");
            throw new IllegalStateException(s);
        }
        try {
            AuthRequest authReq = this.relayParty.authenticate(this.discovered, this.getURL());
            AuthenticationRequestImpl ar = new AuthenticationRequestImpl(this.response, authReq, this.version);
            return ar;
        }
        catch (OpenIDException e) {
            String s = Consts.BUNDLE.getString("jp.sourceforge.tsukuyomi.openid.AuthenticateException");
            LOG.warn((Object)s, (Throwable)e);
            throw new OpenIDRuntimeException(e);
        }
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    private String getURL() {
        String res;
        String scheme = this.request.getScheme();
        String serverName = this.request.getServerName();
        String context = this.request.getContextPath();
        int port = this.request.getServerPort();
        String path = context + this.relayPartyConfig.getReturnURL();
        try {
            URL url = new URL(scheme, serverName, port, path);
            if (port == url.getDefaultPort()) {
                url = new URL(scheme, serverName, -1, path);
            }
            res = url.toString();
        }
        catch (MalformedURLException e) {
            throw new OpenIDRuntimeException(e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Scheme = " + scheme));
            LOG.debug((Object)("Server name = " + serverName));
            LOG.debug((Object)("Port = " + port));
            LOG.debug((Object)("Path = " + path));
            LOG.debug((Object)("URL = " + res));
        }
        return res;
    }

    public String verify() {
        ParameterList openidResp = new ParameterList(this.request.getParameterMap());
        HttpSession session = this.request.getSession(true);
        DiscoveryInformation discovered = (DiscoveryInformation)session.getAttribute("jp.sourceforge.tsukuyomi.openid.discovered");
        String queryString = this.request.getQueryString();
        String url = this.getURL() + "?" + queryString;
        VerificationResult verification = null;
        try {
            verification = this.relayParty.verify(url, openidResp, discovered);
        }
        catch (OpenIDException e) {
            LOG.error((Object)(Consts.BUNDLE + "VerifyException"));
            throw new OpenIDRuntimeException(e);
        }
        Identifier verifiedId = null;
        if (verification != null) {
            verifiedId = verification.getVerifiedId();
        }
        if (verifiedId == null) {
            return null;
        }
        return verifiedId.getIdentifier();
    }

    public void request() {
        this.associate();
        AuthenticationRequest ar = this.getAuthenticationRequest();
        ar.goNext();
    }

    public void setRelayParty(RelayParty relayParty) {
        this.relayParty = relayParty;
    }

    public void setRelayPartyConfig(RelayPartyConfig relayPartyConfig) {
        this.relayPartyConfig = relayPartyConfig;
    }
}

